/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.common.Entities.living.animal.rammer;

import com.bottomtextdanny.dannys_expansion.client.animation.Easing;
import com.bottomtextdanny.dannys_expansion.client.animation.types.Animation;
import com.bottomtextdanny.dannys_expansion.client.entity.render.entity.MountEntity;
import com.bottomtextdanny.dannys_expansion.common.Entities.ai.goals.FollowTargetGoal;
import com.bottomtextdanny.dannys_expansion.common.Entities.ai.goals.PlayAnimationGoal;
import com.bottomtextdanny.dannys_expansion.core.Registries.DannySounds;
import com.bottomtextdanny.dannys_expansion.core.Util.MathUtil;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class GrandRammerEntity
extends MountEntity {
    private static final DataParameter<Float> SIZE = EntityDataManager.func_187226_a(GrandRammerEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Boolean> TAMED = EntityDataManager.func_187226_a(GrandRammerEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> SADDLED = EntityDataManager.func_187226_a(GrandRammerEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(GrandRammerEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    public static final Animation RAM = new Animation(20);

    public GrandRammerEntity(EntityType<? extends GrandRammerEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.2f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new PlayAnimationGoal(this, RAM, o -> this.hasAttackTarget() && this.isAnimationPlaying(Animation.NO_ANIMATION) && this.func_70032_d((Entity)this.func_70638_az()) < this.targetDistance(1.0f)));
        this.field_70714_bg.func_75776_a(3, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new FollowTargetGoal(this, 1.25));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal(this, new Class[0]){

            public boolean func_75250_a() {
                return super.func_75250_a() && !GrandRammerEntity.this.isTamed();
            }
        });
    }

    public static AttributeModifierMap.MutableAttribute Attributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 60.0).func_233815_a_(Attributes.field_233820_c_, 0.8).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233823_f_, 10.0).func_233815_a_(Attributes.field_233824_g_, 3.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SIZE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(TAMED, (Object)false);
        this.field_70180_af.func_187214_a(SADDLED, (Object)false);
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, Optional.empty());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        UUID uuid;
        super.func_70037_a(compound);
        this.setSize(MathHelper.func_76131_a((float)compound.func_74760_g("Size"), (float)1.0f, (float)5.0f));
        this.setSaddled(compound.func_74767_n("Saddled"));
        if (compound.func_186855_b("Owner")) {
            uuid = compound.func_186857_a("Owner");
        } else {
            String s = compound.func_74779_i("Owner");
            uuid = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setOwnerId(uuid);
                this.setTamed(true);
            }
            catch (Throwable throwable) {
                this.setTamed(false);
            }
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74776_a("Size", this.getSize());
        compound.func_74757_a("Saddled", this.isSaddled());
        if (this.getOwnerId() != null) {
            compound.func_186854_a("Owner", this.getOwnerId());
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        if (SIZE.equals(key)) {
            this.func_213323_x_();
        }
        super.func_184206_a(key);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.isAnimationPlaying(RAM)) {
            if (this.getMainAnimationTick() == 4) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)DannySounds.ENTITY_POSSESSED_ARMOR_SLASH.get(), this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.3f + 0.7f, false);
            }
            if (this.func_184207_aI()) {
                if (this.getMainAnimationTick() == 9) {
                    float f1 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                    float f2 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                    List entities = this.field_70170_p.func_217357_a(LivingEntity.class, new AxisAlignedBB(this.func_226277_ct_() - 1.2 * (double)this.getSize() + (double)(-f1 * 2.0f * this.getSize()), this.func_226278_cu_() - 0.3 * (double)this.getSize(), this.func_226281_cx_() - 1.2 * (double)this.getSize() + (double)(f2 * 2.0f * this.getSize()), this.func_226277_ct_() + (double)(1.2f * this.getSize()) + (double)(-f1 * 2.0f * this.getSize()), this.func_226278_cu_() + (double)this.func_213302_cg() + 0.3 * (double)this.getSize(), this.func_226281_cx_() + (double)(1.2f * this.getSize()) + (double)(f2 * 2.0f * this.getSize())));
                    for (LivingEntity livingEntity : entities) {
                        if (livingEntity == this || livingEntity == this.func_184179_bs()) continue;
                        double d1 = livingEntity.func_226277_ct_() - this.func_226277_ct_();
                        double d2 = livingEntity.func_226281_cx_() - this.func_226281_cx_();
                        double d3 = Math.max(d1 * d1 + d2 * d2, 0.001);
                        livingEntity.func_70024_g(d1 / d3 * 4.0, 0.3, d2 / d3 * 4.0);
                        livingEntity.func_70097_a(DamageSource.func_76358_a((LivingEntity)((LivingEntity)this.func_184179_bs())), (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e());
                    }
                }
            } else {
                this.func_70661_as().func_75499_g();
                this.field_70177_z = this.field_70759_as;
                if (this.hasAttackTarget()) {
                    this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
                    if (this.getMainAnimationTick() == 7 && this.func_70032_d((Entity)this.func_70638_az()) <= 11.0f) {
                        this.func_70652_k((Entity)this.func_70638_az());
                    }
                }
            }
        }
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.setSize(1.0f + this.field_70146_Z.nextFloat() * 0.3f);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vec, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() == Items.field_151153_ao && !this.isTamed()) {
            this.setTamedBy(player);
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187537_bA, this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.3f + 0.7f, false);
            this.consumeItemFromStack(player, itemstack);
            return ActionResultType.CONSUME;
        }
        if (itemstack.func_77973_b() == Items.field_151141_av && this.isTamed()) {
            this.setSaddled(true);
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187726_cu, this.func_184176_by(), 1.0f + this.field_70146_Z.nextFloat(), this.field_70146_Z.nextFloat() * 0.7f + 0.3f, false);
            this.consumeItemFromStack(player, itemstack);
            return ActionResultType.CONSUME;
        }
        if (!this.func_184207_aI() && this.isSaddled() && !this.field_70170_p.func_201670_d() && this.isOwner((LivingEntity)player)) {
            this.setRiddenBy(player);
        }
        return super.func_184199_a(player, vec, hand);
    }

    @Override
    public void func_213352_e(Vector3d p_213352_1_) {
        if (this.func_70089_S() && this.func_184179_bs() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)this.func_184179_bs();
            if (this.func_184207_aI() && livingentity != null) {
                this.field_70126_B = this.field_70177_z = livingentity.field_70177_z;
                this.field_70125_A = livingentity.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70759_as = this.field_70761_aq = this.field_70177_z;
                float f = livingentity.field_70702_br * 0.15f;
                float f1 = livingentity.field_191988_bg * 0.2f;
                if (f1 < 0.0f) {
                    f1 /= 2.0f;
                }
                if (!this.onGround() || this.onGround() && this.func_70090_H()) {
                    f = (float)((double)livingentity.field_70702_br * 0.03);
                    f1 = (float)((double)livingentity.field_191988_bg * 0.04);
                } else if (this.isAnimationPlaying(RAM) && this.getMainAnimationTick() < 10) {
                    f = (float)((double)livingentity.field_70702_br * 0.075);
                    f1 = (float)((double)livingentity.field_191988_bg * 0.1);
                }
                float f2 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                float f3 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                float f4 = MathHelper.func_76126_a((float)(this.func_184229_a(Rotation.COUNTERCLOCKWISE_90) * ((float)Math.PI / 180)));
                float f5 = MathHelper.func_76134_b((float)(this.func_184229_a(Rotation.COUNTERCLOCKWISE_90) * ((float)Math.PI / 180)));
                this.func_213317_d(this.func_213322_ci().func_72441_c((double)(f2 * -f1 + f4 * -f), 0.0, (double)(f3 * f1 + f5 * f)));
            }
        }
        super.func_213352_e(p_213352_1_);
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        passenger.func_70107_b(passenger.func_226277_ct_(), this.func_226278_cu_() + this.func_174813_aQ().func_216360_c() - 0.625, passenger.func_226281_cx_());
        if (this.isAnimationPlaying(RAM)) {
            float f3 = MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180)));
            float f = MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180)));
            float f1 = 0.0f;
            f1 += MathUtil.freeAnimator(0.7f * this.getSize(), 0.0f, 0.0f, 5.0f, Easing.LINEAR, this.getMainAnimationTick());
            f1 += MathUtil.freeAnimator(-1.3f * this.getSize(), 0.7f * this.getSize(), 5.0f, 9.0f, Easing.LINEAR, this.getMainAnimationTick());
            passenger.func_70107_b(this.func_226277_ct_() + (double)((f1 += MathUtil.freeAnimator(0.6f * this.getSize(), -0.6f * this.getSize(), 9.0f, 15.0f, Easing.LINEAR, this.getMainAnimationTick())) * f3), passenger.func_226278_cu_(), this.func_226281_cx_() - (double)(f1 * f));
        }
    }

    protected int func_225508_e_(float p_225508_1_, float p_225508_2_) {
        return super.func_225508_e_(p_225508_1_, p_225508_2_) / 2;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 1.2f;
    }

    public void setSize(float sizeIn) {
        this.field_70180_af.func_187227_b(SIZE, (Object)Float.valueOf(sizeIn));
        this.func_213323_x_();
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a(this.func_110148_a(Attributes.field_233818_a_).func_111125_b() * (double)this.getSize());
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(this.func_110148_a(Attributes.field_233823_f_).func_111125_b() * (double)this.getSize());
    }

    public float getSize() {
        return ((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue();
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return super.func_213305_a(poseIn).func_220313_a(this.getSize());
    }

    public void setSaddled(boolean v) {
        this.field_70180_af.func_187227_b(SADDLED, (Object)v);
    }

    public boolean isSaddled() {
        return (Boolean)this.field_70180_af.func_187225_a(SADDLED);
    }

    public boolean isTamed() {
        return (Boolean)this.field_70180_af.func_187225_a(TAMED);
    }

    public void setTamed(boolean tamed) {
        this.field_70180_af.func_187227_b(TAMED, (Object)tamed);
        this.setupTamedAI();
    }

    protected void setupTamedAI() {
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    public void setTamedBy(PlayerEntity player) {
        this.setTamed(true);
        this.setOwnerId(player.func_110124_au());
    }

    @Nullable
    public LivingEntity getOwner() {
        try {
            UUID uuid = this.getOwnerId();
            return uuid == null ? null : this.field_70170_p.func_217371_b(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public boolean isOwner(LivingEntity entityIn) {
        return entityIn == this.getOwner();
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{RAM};
    }

    @Override
    public void doAct() {
        this.playMainAnimation(RAM);
    }

    @Override
    public int progressAddition() {
        return 1000;
    }

    @Override
    public int progressSubtraction() {
        return -30;
    }

    @Override
    public boolean usesAbilityBar() {
        return false;
    }

    @Override
    protected boolean func_225511_J_() {
        return false;
    }
}

