/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.common.Entities.living.floating;

import com.bottomtextdanny.dannys_expansion.client.animation.types.Animation;
import com.bottomtextdanny.dannys_expansion.common.Entities.living.RangedAvoidingEntity;
import com.bottomtextdanny.dannys_expansion.common.Entities.spell.CursedFireEntity;
import com.bottomtextdanny.dannys_expansion.core.Registries.DannyEntities;
import com.bottomtextdanny.dannys_expansion.core.Registries.DannyParticles;
import com.bottomtextdanny.dannys_expansion.core.Util.EntityUtil;
import com.bottomtextdanny.dannys_expansion.core.Util.MathUtil;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class CursedSkullEntity
extends RangedAvoidingEntity
implements IMob {
    public static final Animation SPIT_FIRE = new Animation(28);

    public CursedSkullEntity(EntityType<? extends CursedSkullEntity> type, World worldIn) {
        super((EntityType<? extends RangedAvoidingEntity>)type, worldIn);
        this.bobbingTicks = 120;
        this.bobbingAmount = 0.004f;
        this.rangedTimer.setBoundBase(60);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SpitFireGoal());
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, false));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, false));
    }

    public static AttributeModifierMap.MutableAttribute Attributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 40.0).func_233815_a_(Attributes.field_233819_b_, 30.0).func_233815_a_(Attributes.field_233820_c_, 0.75).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233823_f_, 7.0);
    }

    @Override
    public boolean func_213397_c(double distanceToClosestPlayer) {
        return true;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        double d0 = this.field_70146_Z.nextGaussian() * (this.func_174813_aQ().func_216364_b() + 0.15) / 2.0;
        double d1 = (double)this.field_70146_Z.nextFloat() * this.func_174813_aQ().func_216360_c() + 0.1;
        double d2 = this.field_70146_Z.nextGaussian() * (this.func_174813_aQ().func_216364_b() + 0.15) / 2.0;
        EntityUtil.particleAt(this.field_70170_p, (IParticleData)DannyParticles.CURSED_FLAME.get(), 1, this.func_226277_ct_() + d0, this.func_226278_cu_() + d1, this.func_226281_cx_() + d2, 0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{SPIT_FIRE};
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_232684_aU_;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_232682_aS_;
    }

    class SpitFireGoal
    extends Goal {
        SpitFireGoal() {
        }

        public void func_75249_e() {
            super.func_75249_e();
            CursedSkullEntity.this.playMainAnimation(SPIT_FIRE);
            CursedSkullEntity.this.rangedTimer.reset();
        }

        public void func_75246_d() {
            CursedFireEntity cursedFireEntity;
            super.func_75246_d();
            if (CursedSkullEntity.this.hasAttackTarget() && CursedSkullEntity.this.getMainAnimationTick() == 16 && (cursedFireEntity = (CursedFireEntity)((EntityType)DannyEntities.CURSED_FIRE.get()).func_200721_a(CursedSkullEntity.this.field_70170_p)) != null) {
                Vector3d forward = Vector3d.func_189986_a((float)CursedSkullEntity.this.field_70125_A, (float)CursedSkullEntity.this.field_70759_as);
                double x = 0.5 * forward.field_72450_a;
                double y = 0.1875 * forward.field_72448_b;
                double z = 0.5 * forward.field_72449_c;
                cursedFireEntity.func_70107_b(CursedSkullEntity.this.func_226277_ct_() + x, CursedSkullEntity.this.func_226278_cu_() + y, CursedSkullEntity.this.func_226281_cx_() + z);
                float yaw = MathUtil.getTargetYaw(cursedFireEntity, (Entity)CursedSkullEntity.this.func_70638_az());
                float pitch = MathUtil.getTargetPitch(cursedFireEntity, (Entity)CursedSkullEntity.this.func_70638_az());
                cursedFireEntity.setRotations(yaw, pitch);
                cursedFireEntity.setCaster((LivingEntity)CursedSkullEntity.this);
                CursedSkullEntity.this.field_70170_p.func_217376_c((Entity)cursedFireEntity);
            }
        }

        public boolean func_75253_b() {
            return CursedSkullEntity.this.isAnimationPlaying(SPIT_FIRE);
        }

        public boolean func_75250_a() {
            return CursedSkullEntity.this.hasAttackTarget() && CursedSkullEntity.this.isAnimationPlaying(Animation.NO_ANIMATION) && CursedSkullEntity.this.rangedTimer.hasEnded() && CursedSkullEntity.this.func_70685_l((Entity)CursedSkullEntity.this.func_70638_az());
        }
    }
}

