/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.common.Entities.living.floating;

import com.bottomtextdanny.dannys_expansion.client.animation.types.Animation;
import com.bottomtextdanny.dannys_expansion.common.Entities.living.RangedAvoidingEntity;
import com.bottomtextdanny.dannys_expansion.common.Entities.spell.IceBulletEntity;
import com.bottomtextdanny.dannys_expansion.core.Registries.DannyEntities;
import com.bottomtextdanny.dannys_expansion.core.Registries.DannyParticles;
import com.bottomtextdanny.dannys_expansion.core.Registries.DannySounds;
import com.bottomtextdanny.dannys_expansion.core.Util.EntityUtil;
import com.bottomtextdanny.dannys_expansion.core.Util.MathUtil;
import com.bottomtextdanny.dannys_expansion.core.Util.Timer;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class IceElementalEntity
extends RangedAvoidingEntity
implements IMob {
    public static Animation THROW_SPIKES = new Animation(20);

    public IceElementalEntity(EntityType<? extends RangedAvoidingEntity> type, World worldIn) {
        super(type, worldIn);
        this.bobbingTicks = 120;
        this.bobbingAmount = 0.004f;
        this.rangedTimer = new Timer(100);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new ThrowSpikesGoal());
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, false));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, false));
    }

    public static AttributeModifierMap.MutableAttribute Attributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 40.0).func_233815_a_(Attributes.field_233819_b_, 30.0).func_233815_a_(Attributes.field_233820_c_, 0.75).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233823_f_, 7.0);
    }

    @Override
    public boolean func_213397_c(double distanceToClosestPlayer) {
        return true;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        double d0 = this.field_70146_Z.nextGaussian() * 0.2;
        double d1 = this.field_70146_Z.nextGaussian() * 0.2;
        double d2 = this.field_70146_Z.nextGaussian() * 0.2;
        EntityUtil.particleAt(this.field_70170_p, (IParticleData)DannyParticles.TINY_SNOWFLAKE.get(), 1, this.func_226277_ct_(), this.func_226278_cu_() + 0.25, this.func_226281_cx_(), d0, d1, d2, 0.2f);
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)DannySounds.ENTITY_ICE_ELEMENTAL_HIT.get();
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)DannySounds.ENTITY_ICE_ELEMENTAL_DEATH.get();
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{THROW_SPIKES};
    }

    class ThrowSpikesGoal
    extends Goal {
        ThrowSpikesGoal() {
        }

        public void func_75249_e() {
            super.func_75249_e();
            IceElementalEntity.this.playMainAnimation(THROW_SPIKES);
            IceElementalEntity.this.rangedTimer.reset();
        }

        public void func_75246_d() {
            super.func_75246_d();
            if (IceElementalEntity.this.hasAttackTarget()) {
                Vector3d counterClockwise90 = Vector3d.func_189986_a((float)(MathHelper.func_76142_g((float)IceElementalEntity.this.field_70125_A) + 270.0f), (float)(MathHelper.func_76142_g((float)IceElementalEntity.this.field_70759_as) + 270.0f));
                double x = 1.5 * counterClockwise90.field_72450_a;
                double y = 0.25 * counterClockwise90.field_72448_b;
                double z = 1.5 * counterClockwise90.field_72449_c;
                if (IceElementalEntity.this.getMainAnimationTick() == 1) {
                    IceBulletEntity rightIceBullet = (IceBulletEntity)((EntityType)DannyEntities.ICE_BULLET.get()).func_200721_a(IceElementalEntity.this.field_70170_p);
                    rightIceBullet.func_70107_b(IceElementalEntity.this.func_226277_ct_() + x, IceElementalEntity.this.func_226278_cu_() + y, IceElementalEntity.this.func_226281_cx_() + z);
                    float yaw0 = MathUtil.getTargetYaw(rightIceBullet, (Entity)IceElementalEntity.this.func_70638_az());
                    float pitch0 = MathUtil.getTargetPitch(rightIceBullet, (Entity)IceElementalEntity.this.func_70638_az());
                    rightIceBullet.setRotations(yaw0, pitch0);
                    rightIceBullet.setCaster((LivingEntity)IceElementalEntity.this);
                    IceElementalEntity.this.field_70170_p.func_217376_c((Entity)rightIceBullet);
                }
                if (IceElementalEntity.this.getMainAnimationTick() == 11) {
                    IceBulletEntity leftIceBullet = (IceBulletEntity)((EntityType)DannyEntities.ICE_BULLET.get()).func_200721_a(IceElementalEntity.this.field_70170_p);
                    leftIceBullet.func_70107_b(IceElementalEntity.this.func_226277_ct_() - x, IceElementalEntity.this.func_226278_cu_() + y, IceElementalEntity.this.func_226281_cx_() - z);
                    float yaw1 = MathUtil.getTargetYaw(leftIceBullet, (Entity)IceElementalEntity.this.func_70638_az());
                    float pitch1 = MathUtil.getTargetPitch(leftIceBullet, (Entity)IceElementalEntity.this.func_70638_az());
                    leftIceBullet.setRotations(yaw1, pitch1);
                    leftIceBullet.setCaster((LivingEntity)IceElementalEntity.this);
                    IceElementalEntity.this.field_70170_p.func_217376_c((Entity)leftIceBullet);
                }
            }
        }

        public boolean func_75253_b() {
            return IceElementalEntity.this.isAnimationPlaying(THROW_SPIKES);
        }

        public boolean func_75250_a() {
            return IceElementalEntity.this.hasAttackTarget() && IceElementalEntity.this.isAnimationPlaying(Animation.NO_ANIMATION) && IceElementalEntity.this.rangedTimer.hasEnded() && IceElementalEntity.this.func_70685_l((Entity)IceElementalEntity.this.func_70638_az());
        }
    }
}

