/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.common.Entities.living.floating;

import com.bottomtextdanny.dannys_expansion.client.animation.AmbientAnimation;
import com.bottomtextdanny.dannys_expansion.client.animation.types.AmbCuttedAnimation;
import com.bottomtextdanny.dannys_expansion.client.animation.types.Animation;
import com.bottomtextdanny.dannys_expansion.common.Entities.ai.controllers.MGLookController;
import com.bottomtextdanny.dannys_expansion.common.Entities.living.FloatingEntity;
import com.bottomtextdanny.dannys_expansion.core.DannysExpansion;
import com.bottomtextdanny.dannys_expansion.core.Registries.DannyParticles;
import com.bottomtextdanny.dannys_expansion.core.Registries.DannySounds;
import com.bottomtextdanny.dannys_expansion.core.Util.DannyRayTraceHelper;
import com.bottomtextdanny.dannys_expansion.core.Util.MathUtil;
import com.bottomtextdanny.dannys_expansion.core.Util.SimpleMotion;
import com.bottomtextdanny.dannys_expansion.core.Util.Timer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MagmaGulperEntity
extends FloatingEntity
implements IMob {
    public static final Animation THAT_THING = new Animation(20);
    public final AmbCuttedAnimation attackAnimation = new AmbCuttedAnimation(21, 11);
    public final AmbientAnimation beatAnimation = new AmbientAnimation(17);
    public MagmaGulperPhase phase;
    public AttackPhase attackPhase = AttackPhase.WAIT;
    public SimpleMotion retrayMotion = this.registerMotion(new SimpleMotion(8, 0.96f));
    BlockRayTraceResult rayTraceResult;
    public Timer beatTimer = new Timer(220);
    public Timer avoidCollisionTimer = new Timer(22);
    public Timer randomParticleTimer;
    public int timeCollidedHorizontally = 0;
    public float glidingVelocityMult = 1.0f;
    public int extraFlaps = 0;
    public int setActiveTimer = 600;
    public float prevRenderYawRot;
    public float renderYawRot;

    public MagmaGulperEntity(EntityType<? extends MagmaGulperEntity> type, World worldIn) {
        super(type, worldIn);
        this.bobbingAmount = 0.0f;
        this.randomParticleTimer = new Timer(80, b -> MathUtil.getRandomOffset(b, 0.5f));
        this.phase = MagmaGulperPhase.ACTIVE;
        this.field_70765_h = new MagmaGulperMovementController((MobEntity)this);
        this.field_70749_g = new MGLookController((MobEntity)this);
        this.setAmbientAnimation(this.attackAnimation, 0);
        this.setAmbientAnimation(this.beatAnimation, 1);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new AttackGoal());
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, false));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, SkeletonEntity.class, false));
    }

    public static AttributeModifierMap.MutableAttribute Attributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233819_b_, 20.0).func_233815_a_(Attributes.field_233820_c_, 0.75).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233823_f_, 3.0);
    }

    @Override
    public boolean func_213397_c(double distanceToClosestPlayer) {
        return true;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_189654_d(true);
        this.field_70143_R = 0.0f;
        if (this.field_70170_p.func_201670_d()) {
            this.prevRenderYawRot = this.renderYawRot;
            this.renderYawRot = (float)MathHelper.func_219803_d((double)0.2, (double)this.renderYawRot, (double)MathHelper.func_203302_c((float)this.field_70758_at, (float)this.field_70759_as));
        } else {
            if (!this.hasAttackTarget() && this.getAmbientAnimation(0).isWoke()) {
                ((AmbCuttedAnimation)this.getAmbientAnimation(0)).setPass(true);
                this.sendClientManagerMsg(1);
            }
            if (this.glidingVelocityMult > 1.2f) {
                this.beatTimer.tryUp();
                if (this.beatTimer.hasEnded()) {
                    this.beatTimer.reset();
                    this.func_184185_a((SoundEvent)DannySounds.ENTITY_MAGMA_GULPER_EXPULSE.get(), 1.0f, 1.0f);
                    this.wakeAmbientAnimation(1);
                    this.sendClientManagerMsg(2);
                }
            }
        }
        if (!this.hasAttackTarget() && this.field_70146_Z.nextInt(50) == 1) {
            ((MGLookController)this.func_70671_ap()).setTargetYaw(this.field_70146_Z.nextInt(360), 5.0f);
        }
        if (this.extraFlaps > 10) {
            this.phase = MagmaGulperPhase.TIRED;
        }
        if (this.phase == MagmaGulperPhase.TIRED) {
            --this.setActiveTimer;
            if (this.setActiveTimer <= 0) {
                this.phase = MagmaGulperPhase.ACTIVE;
                this.extraFlaps = 0;
                this.setActiveTimer = 600;
            }
        }
        this.field_70177_z = this.field_70759_as;
    }

    public void func_70030_z() {
        this.rayTraceResult = DannyRayTraceHelper.rayTraceBlocks((Entity)this);
        super.func_70030_z();
    }

    @Override
    public void func_213352_e(Vector3d travelVector) {
        super.func_213352_e(travelVector);
        this.avoidCollisionTimer.tryUp();
        if (this.field_70123_F) {
            this.timeCollidedHorizontally = MathHelper.func_76125_a((int)(this.timeCollidedHorizontally + 1), (int)0, (int)120);
        } else if (this.timeCollidedHorizontally > 0) {
            this.timeCollidedHorizontally -= 3;
        }
        float gravity = -0.042f;
        if (!this.hasAttackTarget()) {
            gravity -= 0.03f;
        }
        if (this.isAnimationPlaying(THAT_THING)) {
            if (this.getMainAnimationTick() == 1) {
                this.func_184185_a((SoundEvent)DannySounds.ENTITY_MAGMA_GULPER_FLAP.get(), 1.5f, 0.5f);
            } else if (this.getMainAnimationTick() == 3) {
                this.addAccMotion(0.0, 0.45f + 0.04f * this.glidingVelocityMult, 0.0);
                this.glidingVelocityMult = 1.0f;
            }
        }
        if (this.hasAttackTarget() && (this.attackPhase == AttackPhase.WAIT || this.attackPhase == AttackPhase.MOMENTUM)) {
            gravity = -0.22f;
            if (this.isAnimationPlaying(THAT_THING) && this.getMainAnimationTick() == 3) {
                this.addAccMotion(0.0, 0.28f, 0.0);
            }
        }
        this.addSimpleMotion(0.0, gravity, 0.0);
    }

    public boolean func_230270_dK_() {
        return true;
    }

    public int func_213396_dB() {
        return 5;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{THAT_THING};
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76347_k()) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70027_ad() {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void dannyClientManager(int flag, float abstractVal) {
        super.dannyClientManager(flag, abstractVal);
        if (flag == 0) {
            ((MGLookController)this.func_70671_ap()).setTargetYaw(abstractVal, 5.0f);
        } else if (flag == 1) {
            if (this.getAmbientAnimation(0).isWoke()) {
                ((AmbCuttedAnimation)this.getAmbientAnimation(0)).setPass(true);
            }
        } else if (flag == 2) {
            int factor1 = this.field_70146_Z.nextInt(3) + 2;
            Vector3d horizontalDir = MathUtil.fromPitchYaw(0.0f, this.field_70759_as).func_216372_d(1.2, 0.0, 1.2);
            for (int i = 0; i < factor1; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)DannyParticles.MG_BIG_BLOB.get(), this.func_226277_ct_(), this.func_226278_cu_() + 0.2, this.func_226281_cx_(), this.field_70146_Z.nextGaussian() * 0.4 + horizontalDir.field_72450_a, 0.4 + (double)this.field_70146_Z.nextFloat() * 0.4, this.field_70146_Z.nextGaussian() * 0.4 + horizontalDir.field_72449_c);
            }
        } else if (flag == 3) {
            ((MGLookController)this.func_70671_ap()).setTargetPitch(abstractVal, 7.0f);
        } else if (flag == 4) {
            ((MGLookController)this.func_70671_ap()).setTargetYaw(abstractVal, 10.0f);
        }
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)DannySounds.ENTITY_MAGMA_GULPER_HURT.get();
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)DannySounds.ENTITY_MAGMA_GULPER_DEATH.get();
    }

    public static enum AttackPhase {
        WAIT,
        MOMENTUM,
        ATTACK;

    }

    public static enum MagmaGulperPhase {
        ACTIVE,
        TIRED;

    }

    public class MagmaGulperMovementController
    extends MovementController {
        final MagmaGulperEntity magmaGulper;

        public MagmaGulperMovementController(MobEntity mob) {
            super(mob);
            this.magmaGulper = (MagmaGulperEntity)mob;
        }

        public void func_75641_c() {
            super.func_75641_c();
            BlockPos blockpos = this.magmaGulper.func_233580_cy_();
            double d0 = 0.0;
            Block tracedBlock = this.magmaGulper.field_70170_p.func_180495_p(MagmaGulperEntity.this.rayTraceResult.func_216350_a()).func_177230_c();
            Vector3d vec = MathUtil.fromPitchYaw(0.0f, MagmaGulperEntity.this.field_70759_as);
            do {
                BlockState blockstate1;
                VoxelShape voxelshape;
                BlockPos blockpos1;
                BlockState blockstate;
                if ((blockstate = this.magmaGulper.field_70170_p.func_180495_p(blockpos1 = blockpos.func_177977_b())).func_196952_d((IBlockReader)MagmaGulperEntity.this.field_70170_p, blockpos1) == VoxelShapes.func_197880_a() && blockstate.func_177230_c() != Blocks.field_150353_l && blockstate.func_177230_c() != Blocks.field_150355_j) continue;
                if (this.magmaGulper.field_70170_p.func_175623_d(blockpos) || (voxelshape = (blockstate1 = this.magmaGulper.field_70170_p.func_180495_p(blockpos)).func_196952_d((IBlockReader)this.magmaGulper.field_70170_p, blockpos)).func_197766_b()) break;
                d0 = voxelshape.func_197758_c(Direction.Axis.Y);
                break;
            } while ((blockpos = blockpos.func_177977_b()).func_177956_o() >= MathHelper.func_76128_c((double)d0) - 1);
            if ((double)blockpos.func_177956_o() + d0 > (double)(this.magmaGulper.func_233580_cy_().func_177956_o() - 2) && MagmaGulperEntity.this.isAnimationPlaying(Animation.NO_ANIMATION) || !MagmaGulperEntity.this.hasAttackTarget() && MagmaGulperEntity.this.field_70146_Z.nextInt(280) == 1 && this.magmaGulper.phase == MagmaGulperPhase.ACTIVE && MagmaGulperEntity.this.attackPhase != AttackPhase.ATTACK) {
                MagmaGulperEntity.this.playMainAnimation(THAT_THING);
            }
            if (this.magmaGulper.func_70638_az() == null) {
                MagmaGulperEntity.this.addSimpleMotion(vec.field_72450_a * 0.15 * (double)MagmaGulperEntity.this.glidingVelocityMult, 0.0, vec.field_72449_c * 0.15 * (double)MagmaGulperEntity.this.glidingVelocityMult);
                MagmaGulperEntity.this.glidingVelocityMult = MathHelper.func_76131_a((float)(MagmaGulperEntity.this.glidingVelocityMult + 0.07f), (float)0.0f, (float)3.0f);
                if (MagmaGulperEntity.this.avoidCollisionTimer.hasEnded() && !tracedBlock.isAir(MagmaGulperEntity.this.field_70170_p.func_180495_p(MagmaGulperEntity.this.rayTraceResult.func_216350_a()), (IBlockReader)MagmaGulperEntity.this.field_70170_p, MagmaGulperEntity.this.rayTraceResult.func_216350_a())) {
                    float newRot = MathUtil.getTargetYaw((Entity)this.magmaGulper, MagmaGulperEntity.this.rayTraceResult.func_216350_a().func_177958_n(), MagmaGulperEntity.this.rayTraceResult.func_216350_a().func_177952_p()) + 180.0f;
                    ((MGLookController)MagmaGulperEntity.this.func_70671_ap()).setTargetYaw(newRot, 10.0f);
                    MagmaGulperEntity.this.sendClientManagerMsg(4, newRot);
                    MagmaGulperEntity.this.glidingVelocityMult = 0.75f;
                    MagmaGulperEntity.this.avoidCollisionTimer.reset();
                    if (MagmaGulperEntity.this.timeCollidedHorizontally > 60) {
                        MagmaGulperEntity.this.avoidCollisionTimer.setNextBound(50);
                    }
                }
                if (MagmaGulperEntity.this.timeCollidedHorizontally > 30 && MagmaGulperEntity.this.phase == MagmaGulperPhase.ACTIVE && MagmaGulperEntity.this.isAnimationPlaying(Animation.NO_ANIMATION)) {
                    MagmaGulperEntity.this.playMainAnimation(THAT_THING);
                    ++MagmaGulperEntity.this.extraFlaps;
                }
            }
        }
    }

    class AttackGoal
    extends Goal {
        Timer attackTimer = new Timer(220);
        Timer waitTimer = new Timer(80, b -> 20 + MagmaGulperEntity.this.field_70146_Z.nextInt(10));
        Timer momentumTimer = new Timer(30, b -> 20 + MagmaGulperEntity.this.field_70146_Z.nextInt(20));
        Timer collidedTimer = new Timer(70);

        public void func_75246_d() {
            MagmaGulperEntity.this.func_189654_d(true);
            super.func_75246_d();
            Vector3d head = MathUtil.fromPitchYaw(MagmaGulperEntity.this.field_70125_A, MagmaGulperEntity.this.field_70759_as);
            Vector3d headH = MathUtil.fromPitchYaw(0.0f, MagmaGulperEntity.this.field_70759_as);
            Vector3d headClamp = MathUtil.fromPitchYaw(MathHelper.func_76131_a((float)MagmaGulperEntity.this.field_70125_A, (float)-40.0f, (float)40.0f), MagmaGulperEntity.this.field_70759_as);
            MagmaGulperEntity.this.func_70671_ap().func_75651_a((Entity)MagmaGulperEntity.this.func_70638_az(), 20.0f, 90.0f);
            if (MagmaGulperEntity.this.attackPhase == AttackPhase.WAIT) {
                float hDist;
                if (MagmaGulperEntity.this.func_233580_cy_().func_177956_o() < MagmaGulperEntity.this.func_70638_az().func_233580_cy_().func_177956_o() + 2 && MagmaGulperEntity.this.isAnimationPlaying(Animation.NO_ANIMATION)) {
                    MagmaGulperEntity.this.playMainAnimation(THAT_THING);
                }
                if ((hDist = MathUtil.getHorizontalDistance((Entity)MagmaGulperEntity.this, (Entity)MagmaGulperEntity.this.func_70638_az())) < 6.0f) {
                    if (hDist >= 3.0f) {
                        float mult = -MathUtil.getLerp(6.0, 3.0, hDist);
                        MagmaGulperEntity.this.retrayMotion.setMotion(headH.func_216372_d((double)mult, (double)mult, (double)mult));
                    } else {
                        MagmaGulperEntity.this.retrayMotion.setMotion(headH.func_216372_d(-1.0, -1.0, -1.0));
                    }
                }
                if (this.waitTimer.hasEnded()) {
                    this.waitTimer.reset();
                    MagmaGulperEntity.this.attackPhase = AttackPhase.ATTACK;
                    MagmaGulperEntity.this.wakeAmbientAnimation(0);
                }
                this.waitTimer.tryUp();
            } else if (MagmaGulperEntity.this.attackPhase == AttackPhase.ATTACK) {
                float extraDeg = MathHelper.func_203302_c((float)MagmaGulperEntity.this.field_70759_as, (float)MathUtil.getTargetYaw((Entity)MagmaGulperEntity.this, (Entity)MagmaGulperEntity.this.func_70638_az())) > 0.0f ? -20.0f : 20.0f;
                Block tracedBlock = MagmaGulperEntity.this.field_70170_p.func_180495_p(MagmaGulperEntity.this.rayTraceResult.func_216350_a()).func_177230_c();
                MagmaGulperEntity.this.addSimpleMotion(head.func_216372_d(0.57, 0.57, 0.57));
                if (MagmaGulperEntity.this.func_174813_aQ().func_186662_g(0.6).func_72326_a(MagmaGulperEntity.this.func_70638_az().func_174813_aQ()) && MagmaGulperEntity.this.func_70652_k((Entity)MagmaGulperEntity.this.func_70638_az())) {
                    this.attackTimer.reset();
                    this.collidedTimer.reset();
                    MagmaGulperEntity.this.attackPhase = AttackPhase.MOMENTUM;
                    if (MagmaGulperEntity.this.getAmbientAnimation(0).isWoke()) {
                        ((AmbCuttedAnimation)MagmaGulperEntity.this.getAmbientAnimation(0)).setPass(true);
                        MagmaGulperEntity.this.sendClientManagerMsg(1);
                    }
                }
                if (MagmaGulperEntity.this.func_233580_cy_().func_177956_o() < MagmaGulperEntity.this.func_70638_az().func_233580_cy_().func_177956_o() - 1 && MagmaGulperEntity.this.isAnimationPlaying(Animation.NO_ANIMATION)) {
                    MagmaGulperEntity.this.playMainAnimation(THAT_THING);
                }
                if (tracedBlock.func_230335_e_(MagmaGulperEntity.this.field_70170_p.func_180495_p(MagmaGulperEntity.this.rayTraceResult.func_216350_a()), (IBlockReader)MagmaGulperEntity.this.field_70170_p, MagmaGulperEntity.this.rayTraceResult.func_216350_a()) != VoxelShapes.func_197880_a()) {
                    this.collidedTimer.tryUp();
                    ((MGLookController)MagmaGulperEntity.this.func_70671_ap()).setTargetYaw(MagmaGulperEntity.this.field_70759_as + extraDeg, 5.0f);
                    MagmaGulperEntity.this.sendClientManagerMsg(0, MagmaGulperEntity.this.field_70759_as + 20.0f);
                }
                if (MagmaGulperEntity.this.timeCollidedHorizontally > 10) {
                    ((MGLookController)MagmaGulperEntity.this.func_70671_ap()).setTargetYaw(MagmaGulperEntity.this.field_70759_as + extraDeg, 5.0f);
                    MagmaGulperEntity.this.sendClientManagerMsg(0, MagmaGulperEntity.this.field_70759_as + 20.0f);
                }
                if (MagmaGulperEntity.this.field_70124_G && MathHelper.func_76135_e((float)MagmaGulperEntity.this.field_70125_A) > 70.0f) {
                    ((MGLookController)MagmaGulperEntity.this.func_70671_ap()).setTargetPitch(MagmaGulperEntity.this.field_70125_A - (float)(MathHelper.func_219802_k((double)MagmaGulperEntity.this.field_70125_A) * 20), 7.0f);
                    MagmaGulperEntity.this.sendClientManagerMsg(0, MagmaGulperEntity.this.field_70125_A - (float)(MathHelper.func_219802_k((double)MagmaGulperEntity.this.field_70125_A) * 20));
                }
                if (this.collidedTimer.hasEnded() || MagmaGulperEntity.this.field_70737_aN > 0 || tracedBlock.func_203417_a(DannysExpansion.MAGMA_GULPER_DANGER_BLOCKS)) {
                    this.attackTimer.end();
                }
                if (this.attackTimer.hasEnded()) {
                    this.attackTimer.reset();
                    this.collidedTimer.reset();
                    MagmaGulperEntity.this.attackPhase = AttackPhase.MOMENTUM;
                    if (MagmaGulperEntity.this.getAmbientAnimation(0).isWoke()) {
                        ((AmbCuttedAnimation)MagmaGulperEntity.this.getAmbientAnimation(0)).setPass(true);
                        MagmaGulperEntity.this.sendClientManagerMsg(1);
                    }
                }
                this.attackTimer.tryUp();
            } else if (MagmaGulperEntity.this.attackPhase == AttackPhase.MOMENTUM) {
                if (MagmaGulperEntity.this.func_70068_e((Entity)MagmaGulperEntity.this.func_70638_az()) < 16.0) {
                    MagmaGulperEntity.this.addSimpleMotion(headClamp.func_216372_d(-0.3, -0.3, -0.3));
                } else {
                    MagmaGulperEntity.this.addSimpleMotion(headClamp.func_216372_d(-0.05, -0.05, -0.05));
                }
                if (this.momentumTimer.hasEnded()) {
                    this.momentumTimer.reset();
                    MagmaGulperEntity.this.attackPhase = AttackPhase.WAIT;
                }
                this.momentumTimer.tryUp();
            }
        }

        public boolean func_75250_a() {
            return MagmaGulperEntity.this.func_70638_az() != null;
        }

        public boolean func_75253_b() {
            return MagmaGulperEntity.this.func_70638_az() != null;
        }
    }
}

