/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.common.Entities.living.klifour;

import com.bottomtextdanny.dannys_expansion.client.animation.types.Animation;
import com.bottomtextdanny.dannys_expansion.common.Entities.living.DannyEntity;
import com.bottomtextdanny.dannys_expansion.common.Entities.spell.KlifourSpitEntity;
import com.bottomtextdanny.dannys_expansion.common.Items.accessory.KlifourTalismanAccessory;
import com.bottomtextdanny.dannys_expansion.core.Registries.DannyEntities;
import com.bottomtextdanny.dannys_expansion.core.Registries.DannySounds;
import com.bottomtextdanny.dannys_expansion.core.Util.EntityUtil;
import com.bottomtextdanny.dannys_expansion.core.Util.MathUtil;
import com.bottomtextdanny.dannys_expansion.core.Util.Timer;
import java.util.EnumSet;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class AbstractKlifourEntity
extends DannyEntity {
    private static final DataParameter<Optional<BlockPos>> ATTACHING_LOCATION = EntityDataManager.func_187226_a(AbstractKlifourEntity.class, (IDataSerializer)DataSerializers.field_187201_k);
    private static final DataParameter<Direction> ATTACHING_DIRECTION = EntityDataManager.func_187226_a(AbstractKlifourEntity.class, (IDataSerializer)DataSerializers.field_187202_l);
    private static final DataParameter<Boolean> IS_HIDDEN = EntityDataManager.func_187226_a(AbstractKlifourEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final Animation BLOCK_DESTROYED_DEATH = new Animation(20);
    public static final Animation DEFAULT_DEATH = new Animation(20);
    public static final Animation NAUSEA = new Animation(54);
    public static final Animation SHOW_UP = new Animation(20);
    public static final Animation HIDE = new Animation(15);
    public static final Animation SPIT = new Animation(20);
    public static final Animation SCRUB = new Animation(20);
    public Timer hiddenTimer = new Timer(200, baseBound -> MathUtil.getRandomOffset(baseBound, 0.4f));
    public Timer unhiddenTimer = new Timer(250, baseBound -> MathUtil.getRandomOffset(baseBound, 0.7f));
    public boolean isBadEffectAware;
    public int attackCount;
    public int blockUpdate;

    public AbstractKlifourEntity(EntityType<? extends AbstractKlifourEntity> type, World worldIn) {
        super(type, worldIn);
        this.rangedTimer = new Timer(60, baseBound -> baseBound + (int)((double)baseBound * this.field_70146_Z.nextGaussian() * (double)0.2f));
        this.meleeTimer = new Timer(70);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new NauseaGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new ScrubGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new SpitGoal());
        this.field_70714_bg.func_75776_a(7, (Goal)new KlifourLookRandomGoal());
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f){

            public boolean func_75250_a() {
                return AbstractKlifourEntity.this.func_70638_az() == null && super.func_75250_a();
            }
        });
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, true, e -> !EntityUtil.hasAccessory((PlayerEntity)e, KlifourTalismanAccessory.class)));
    }

    public static AttributeModifierMap.MutableAttribute Attributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 25.0).func_233815_a_(Attributes.field_233819_b_, 30.0).func_233815_a_(Attributes.field_233821_d_, 0.0).func_233815_a_(Attributes.field_233820_c_, 0.0).func_233815_a_(Attributes.field_233823_f_, 5.0);
    }

    @Override
    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(ATTACHING_LOCATION, Optional.empty());
        this.func_184212_Q().func_187214_a(ATTACHING_DIRECTION, (Object)Direction.DOWN);
        this.func_184212_Q().func_187214_a(IS_HIDDEN, (Object)true);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setAttachingDirection(Direction.func_82600_a((int)compound.func_74771_c("Direction")));
        this.setHidden(compound.func_74767_n("IsHidden"));
        this.getAttachingLocation().ifPresent(blockPos -> this.setLocation(compound.func_74762_e("LocationX"), compound.func_74762_e("LocationY"), compound.func_74762_e("LocationZ")));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a("Direction", (byte)this.getAttachingDirection().func_176745_a());
        compound.func_74757_a("IsHidden", this.isHidden());
        this.getAttachingLocation().ifPresent(blockPos -> {
            compound.func_74768_a("LocationX", this.getXLocation());
            compound.func_74768_a("LocationY", this.getYLocation());
            compound.func_74768_a("LocationZ", this.getZLocation());
        });
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.isHidden()) {
            this.hiddenTimer.tryUp();
            if (this.isBadEffectAware) {
                this.func_70651_bq().removeIf(effectInstance -> effectInstance.func_188419_a().func_220303_e() == EffectType.HARMFUL);
                this.isBadEffectAware = false;
                this.func_175136_bO();
            }
            if (this.func_70613_aW() && this.hiddenTimer.hasEnded()) {
                this.playMainAnimation(SHOW_UP);
                this.setHidden(false);
                this.unhiddenTimer.reset();
            }
        } else {
            this.unhiddenTimer.tryUp();
            if (this.func_70638_az() != null) {
                this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
            }
            if (this.func_70613_aW() && this.unhiddenTimer.hasEnded() && this.isAnimationPlaying(Animation.NO_ANIMATION)) {
                if (this.func_70638_az() == null) {
                    this.playMainAnimation(HIDE);
                    this.hiddenTimer.reset();
                } else if (this.attackCount > 8) {
                    this.playMainAnimation(HIDE);
                    this.hiddenTimer.setNextBound(MathUtil.getRandomOffset(80, 0.3f));
                    this.hiddenTimer.setTimer(0);
                }
            }
            if (this.isAnimationPlaying(SPIT)) {
                if (this.func_70613_aW()) {
                    if (this.getMainAnimationTick() == 4) {
                        this.func_184185_a((SoundEvent)DannySounds.ENTITY_KLIFOUR_SPIT.get(), 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
                    }
                    if (this.hasAttackTarget()) {
                        this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
                        if (this.getMainAnimationTick() == 6) {
                            KlifourSpitEntity spit = (KlifourSpitEntity)((EntityType)DannyEntities.KLIFOUR_SPIT.get()).func_200721_a(this.field_70170_p);
                            spit.func_70107_b(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
                            spit.setRotations(MathUtil.getTargetYaw((Entity)this, (Entity)this.func_70638_az()), MathUtil.getTargetPitch((Entity)this, (Entity)this.func_70638_az()));
                            spit.setCaster((LivingEntity)this);
                            this.field_70170_p.func_217376_c((Entity)spit);
                        }
                    }
                }
            } else if (this.isAnimationPlaying(SCRUB)) {
                if (this.getMainAnimationTick() == 1) {
                    this.func_184185_a((SoundEvent)DannySounds.ENTITY_KLIFOUR_SCRUB.get(), 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
                } else if (this.func_70638_az() != null && this.getMainAnimationTick() == 5 && this.func_174813_aQ().func_72326_a(this.func_70638_az().func_174813_aQ().func_186662_g(0.2))) {
                    this.func_70638_az().func_195064_c(new EffectInstance(Effects.field_76436_u, 200, this.field_70170_p.func_175659_aa().func_151525_a() - 1));
                }
            } else if (this.isAnimationPlaying(HIDE)) {
                if (this.getMainAnimationTick() == 1) {
                    this.func_184185_a((SoundEvent)DannySounds.ENTITY_KLIFOUR_HIDE.get(), 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
                }
                if (this.getMainAnimationTick() == 15) {
                    this.setHidden(true);
                }
            } else if (this.isAnimationPlaying(SHOW_UP)) {
                if (this.getMainAnimationTick() == 1) {
                    this.func_184185_a((SoundEvent)DannySounds.ENTITY_KLIFOUR_SHOW_UP.get(), 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
                }
            } else if (this.isAnimationPlaying(NAUSEA) && this.getMainAnimationTick() == 54) {
                this.isBadEffectAware = true;
                this.playMainAnimation(HIDE);
            }
        }
        this.func_189654_d(true);
        if (!this.getAttachingLocation().isPresent()) {
            this.setLocation(this.func_233580_cy_());
        }
        if (this.getAttachingDirection().func_176745_a() == 0) {
            this.func_70107_b((float)this.getXLocation() + 0.5f, (double)this.getYLocation() + 0.0, (float)this.getZLocation() + 0.5f);
        } else if (this.getAttachingDirection().func_176745_a() == 1) {
            this.func_70107_b((float)this.getXLocation() + 0.5f, (double)this.getYLocation() + 0.5, (float)this.getZLocation() + 0.5f);
        } else {
            this.func_70107_b((float)this.getXLocation() + 0.5f, (double)this.getYLocation() + 0.25, (float)this.getZLocation() + 0.5f);
        }
        if (!this.field_70170_p.func_201670_d()) {
            if (this.blockUpdate > 0) {
                --this.blockUpdate;
            } else {
                if (!this.field_70170_p.func_180495_p(this.getAttachingBlock()).func_196952_d((IBlockReader)this.field_70170_p, this.getAttachingBlock()).equals(VoxelShapes.func_197868_b()) && !this.isAnimationPlaying(BLOCK_DESTROYED_DEATH)) {
                    this.playMainAnimation(BLOCK_DESTROYED_DEATH);
                }
                this.blockUpdate = 20;
            }
        }
    }

    @Override
    public Animation onAnimationEnd(Animation animation) {
        if (animation == BLOCK_DESTROYED_DEATH || animation == DEFAULT_DEATH) {
            this.onDeathEnd();
            this.func_70106_y();
        } else if (animation == HIDE) {
            this.setHidden(true);
        }
        return super.onAnimationEnd(animation);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.setLocation(MathHelper.func_76128_c((double)this.func_226277_ct_()), MathHelper.func_76128_c((double)this.func_226278_cu_()), MathHelper.func_76128_c((double)this.func_226281_cx_()));
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 0.25f;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return !this.isHidden() && super.func_70097_a(source, amount);
    }

    public void func_233627_a_(float strength, double ratioX, double ratioZ) {
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_70685_l(Entity entityIn) {
        return !this.isHidden() && super.func_70685_l(entityIn);
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_184603_cC() {
        return !this.isHidden();
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    public boolean func_241849_j(Entity entity) {
        return false;
    }

    protected void func_82167_n(Entity entityIn) {
    }

    public boolean func_70067_L() {
        return !this.isHidden();
    }

    public boolean func_70648_aU() {
        return true;
    }

    @Override
    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)DannySounds.ENTITY_KLIFOUR_HURT.get();
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{BLOCK_DESTROYED_DEATH, DEFAULT_DEATH, SHOW_UP, HIDE, SPIT, SCRUB, NAUSEA};
    }

    public void setAttachingDirection(Direction value) {
        this.func_184212_Q().func_187227_b(ATTACHING_DIRECTION, (Object)value);
    }

    public void setHidden(boolean value) {
        this.func_184212_Q().func_187227_b(IS_HIDDEN, (Object)value);
    }

    public void setLocation(int x, int y, int z) {
        this.func_184212_Q().func_187227_b(ATTACHING_LOCATION, Optional.of(new BlockPos(x, y, z)));
    }

    public void setLocation(BlockPos value) {
        this.func_184212_Q().func_187227_b(ATTACHING_LOCATION, Optional.of(value));
    }

    public BlockPos getAttachingBlock() {
        return this.func_233580_cy_().func_177972_a(this.getAttachingDirection());
    }

    public Direction getAttachingDirection() {
        return (Direction)this.func_184212_Q().func_187225_a(ATTACHING_DIRECTION);
    }

    public boolean isHidden() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_HIDDEN);
    }

    public Optional<BlockPos> getAttachingLocation() {
        return (Optional)this.func_184212_Q().func_187225_a(ATTACHING_LOCATION);
    }

    public int getXLocation() {
        return ((BlockPos)((Optional)this.func_184212_Q().func_187225_a(ATTACHING_LOCATION)).get()).func_177958_n();
    }

    public int getYLocation() {
        return ((BlockPos)((Optional)this.func_184212_Q().func_187225_a(ATTACHING_LOCATION)).get()).func_177956_o();
    }

    public int getZLocation() {
        return ((BlockPos)((Optional)this.func_184212_Q().func_187225_a(ATTACHING_LOCATION)).get()).func_177952_p();
    }

    class NauseaGoal
    extends Goal {
        NauseaGoal() {
        }

        public void func_75249_e() {
            super.func_75249_e();
            AbstractKlifourEntity.this.playMainAnimation(NAUSEA);
        }

        public boolean func_75253_b() {
            return false;
        }

        public boolean func_75250_a() {
            return !AbstractKlifourEntity.this.isHidden() && AbstractKlifourEntity.this.isAnimationPlaying(Animation.NO_ANIMATION) && AbstractKlifourEntity.this.func_70651_bq().stream().anyMatch(effectInstance -> effectInstance.func_188419_a().func_220303_e() == EffectType.HARMFUL);
        }
    }

    class ScrubGoal
    extends Goal {
        ScrubGoal() {
        }

        public void func_75249_e() {
            super.func_75249_e();
            AbstractKlifourEntity.this.playMainAnimation(SCRUB);
            AbstractKlifourEntity.this.meleeTimer.reset();
            ++AbstractKlifourEntity.this.attackCount;
            LivingEntity target = AbstractKlifourEntity.this.func_70638_az();
            if ((double)AbstractKlifourEntity.this.func_70032_d((Entity)target) > AbstractKlifourEntity.this.func_233637_b_(Attributes.field_233819_b_) && target.func_175149_v() || target instanceof PlayerEntity && ((PlayerEntity)target).func_184812_l_()) {
                AbstractKlifourEntity.this.func_70624_b(null);
            }
        }

        public boolean func_75253_b() {
            return false;
        }

        public boolean func_75250_a() {
            return !AbstractKlifourEntity.this.isHidden() && AbstractKlifourEntity.this.isAnimationPlaying(Animation.NO_ANIMATION) && AbstractKlifourEntity.this.func_70638_az() != null && AbstractKlifourEntity.this.meleeTimer.hasEnded() && AbstractKlifourEntity.this.func_174813_aQ().func_72326_a(AbstractKlifourEntity.this.func_70638_az().func_174813_aQ());
        }
    }

    class SpitGoal
    extends Goal {
        SpitGoal() {
        }

        public void func_75249_e() {
            super.func_75249_e();
            AbstractKlifourEntity.this.playMainAnimation(SPIT);
            AbstractKlifourEntity.this.rangedTimer.reset();
            ++AbstractKlifourEntity.this.attackCount;
            LivingEntity target = AbstractKlifourEntity.this.func_70638_az();
            if ((double)AbstractKlifourEntity.this.func_70032_d((Entity)target) > AbstractKlifourEntity.this.func_233637_b_(Attributes.field_233819_b_) && target.func_175149_v() || target instanceof PlayerEntity && ((PlayerEntity)target).func_184812_l_()) {
                AbstractKlifourEntity.this.func_70624_b(null);
            }
        }

        public boolean func_75253_b() {
            return false;
        }

        public boolean func_75250_a() {
            return !AbstractKlifourEntity.this.isHidden() && AbstractKlifourEntity.this.isAnimationPlaying(Animation.NO_ANIMATION) && AbstractKlifourEntity.this.func_70638_az() != null && AbstractKlifourEntity.this.rangedTimer.hasEnded() && AbstractKlifourEntity.this.func_70685_l((Entity)AbstractKlifourEntity.this.func_70638_az());
        }
    }

    class KlifourLookRandomGoal
    extends Goal {
        private double lookX;
        private double lookY;
        private double lookZ;
        private int idleTime;

        public KlifourLookRandomGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public void func_75249_e() {
            double d0 = Math.PI * 2 * AbstractKlifourEntity.this.func_70681_au().nextDouble();
            this.lookX = Math.cos(d0);
            this.lookY = 0.1 * AbstractKlifourEntity.this.func_70681_au().nextGaussian();
            this.lookZ = Math.sin(d0);
            this.idleTime = 20 + AbstractKlifourEntity.this.func_70681_au().nextInt(20);
        }

        public boolean func_75253_b() {
            return this.idleTime >= 0;
        }

        public boolean func_75250_a() {
            return !AbstractKlifourEntity.this.isHidden() && AbstractKlifourEntity.this.func_70638_az() == null && AbstractKlifourEntity.this.func_70681_au().nextFloat() < 0.02f;
        }

        public void func_75246_d() {
            --this.idleTime;
            AbstractKlifourEntity.this.func_70671_ap().func_220679_a(AbstractKlifourEntity.this.func_226277_ct_() + this.lookX, AbstractKlifourEntity.this.func_226280_cw_() + this.lookY, AbstractKlifourEntity.this.func_226281_cx_() + this.lookZ);
        }
    }
}

