/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.common.Entities.living.slime;

import com.bottomtextdanny.dannys_expansion.client.animation.types.Animation;
import com.bottomtextdanny.dannys_expansion.common.Entities.living.DannyEntity;
import com.bottomtextdanny.dannys_expansion.core.Registries.DannyItems;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public abstract class AbstractSlimeEntity
extends DannyEntity
implements IMob {
    public int timeCollidedHorizontally = 0;
    public static final Animation JUMP = new Animation(17);
    public static final Animation DEATH = new Animation(10);
    public int hopDelayTime;
    public int hopDelay = this.hopDelayTime;
    public float horizontalHopSpeed = 0.1f;
    public float hopHeight = 0.7f;
    public boolean wasJumping;

    public AbstractSlimeEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_213323_x_();
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.func_213323_x_();
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new RotateToTargetGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new RotateRandomlyGoal());
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    @Override
    public boolean func_213397_c(double distanceToClosestPlayer) {
        return true;
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        this.func_213323_x_();
    }

    @Override
    public void func_70071_h_() {
        if (this.field_70123_F) {
            ++this.timeCollidedHorizontally;
        }
        super.func_70071_h_();
        this.field_70143_R = 0.0f;
        if (this.isAnimationPlaying(JUMP) && this.getMainAnimationTick() >= 3 && this.getMainAnimationTick() < 8) {
            float d0 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
            float d1 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
            this.func_70024_g(this.horizontalHopSpeed * -d0, 0.0, this.horizontalHopSpeed * d1);
            if (this.getMainAnimationTick() == 3) {
                this.func_70024_g(0.0, this.hopHeight, 0.0);
                this.func_184185_a(SoundEvents.field_226135_eP_, 0.3f + this.field_70146_Z.nextFloat() * 0.4f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
            }
            if (this.getMainAnimationTick() == 5) {
                this.wasJumping = true;
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            if (--this.hopDelay <= 0 && (this.onGround() || this.InFluid())) {
                this.hopDelay = this.hopDelayTime;
                this.playMainAnimation(JUMP);
            }
            if (this.wasJumping && this.onGround()) {
                this.func_184185_a(SoundEvents.field_226135_eP_, 0.3f + this.field_70146_Z.nextFloat() * 0.4f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
                this.wasJumping = false;
            }
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.InFluid()) {
            this.func_70024_g(0.0, 0.05, 0.0);
        }
    }

    @Override
    protected void onDeathEnd() {
        super.onDeathEnd();
        if (!this.field_70170_p.field_72995_K) {
            float f = this.gelAmount();
            int i = (int)this.gelAmount();
            f -= (float)i;
            float f1 = this.field_70146_Z.nextFloat();
            if (f1 < f) {
                ++i;
            }
            if (i != 0) {
                ItemStack gel = new ItemStack((IItemProvider)DannyItems.GEL.get());
                gel.func_190920_e(i);
                ItemEntity itemEntity = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), gel);
                itemEntity.func_213293_j(0.0, 0.5, 0.0);
                this.field_70170_p.func_217376_c((Entity)itemEntity);
            }
        }
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{JUMP, DEATH};
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_226136_eQ_;
    }

    public float gelAmount() {
        return 1.0f;
    }

    class RotateToTargetGoal
    extends Goal {
        RotateToTargetGoal() {
        }

        public void func_75249_e() {
            super.func_75249_e();
            if (AbstractSlimeEntity.this.func_70638_az() != null) {
                AbstractSlimeEntity.this.func_70671_ap().func_75651_a((Entity)AbstractSlimeEntity.this.func_70638_az(), 30.0f, 30.0f);
            }
        }

        public void func_75246_d() {
            super.func_75246_d();
            if (AbstractSlimeEntity.this.func_70638_az() != null) {
                LivingEntity livingEntity = AbstractSlimeEntity.this.func_70638_az();
                double d0 = livingEntity.func_226277_ct_() - AbstractSlimeEntity.this.func_226277_ct_();
                double d1 = livingEntity.func_226281_cx_() - AbstractSlimeEntity.this.func_226281_cx_();
                if (livingEntity.func_174813_aQ().func_72326_a(AbstractSlimeEntity.this.func_174813_aQ().func_186662_g(0.1))) {
                    AbstractSlimeEntity.this.func_70652_k((Entity)livingEntity);
                }
                AbstractSlimeEntity.this.field_70177_z = (float)(MathHelper.func_181159_b((double)d1, (double)d0) * 57.2957763671875) - 90.0f;
            }
        }

        public boolean func_75253_b() {
            return AbstractSlimeEntity.this.func_70638_az() != null;
        }

        public boolean func_75250_a() {
            return AbstractSlimeEntity.this.func_70638_az() != null;
        }
    }

    class RotateRandomlyGoal
    extends Goal {
        RotateRandomlyGoal() {
        }

        public void func_75249_e() {
            super.func_75249_e();
            if (AbstractSlimeEntity.this.timeCollidedHorizontally > 40) {
                AbstractSlimeEntity.this.field_70177_z = (float)((double)(MathHelper.func_76142_g((float)AbstractSlimeEntity.this.field_70177_z) + 180.0f) + new Random().nextGaussian() * 10.0);
                AbstractSlimeEntity.this.timeCollidedHorizontally = 0;
            } else {
                AbstractSlimeEntity.this.field_70177_z = new Random().nextFloat() * 360.0f;
            }
        }

        public boolean func_75253_b() {
            return false;
        }

        public boolean func_75250_a() {
            return new Random().nextInt(200) == 5 || AbstractSlimeEntity.this.timeCollidedHorizontally > 40;
        }
    }
}

