/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.common.Entities.living.slime;

import com.bottomtextdanny.dannys_expansion.client.animation.Easing;
import com.bottomtextdanny.dannys_expansion.client.animation.types.Animation;
import com.bottomtextdanny.dannys_expansion.client.entity.render.entity.MountEntity;
import com.bottomtextdanny.dannys_expansion.core.Registries.DannyItems;
import com.bottomtextdanny.dannys_expansion.core.Registries.DannySounds;
import com.bottomtextdanny.dannys_expansion.core.Util.MathUtil;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class BlueSlimeEntity
extends MountEntity {
    protected static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(BlueSlimeEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    protected static final DataParameter<Integer> PROTECTIVE_TICKS = EntityDataManager.func_187226_a(BlueSlimeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final Animation BACK_TO_ITEM = new Animation(20);
    public static final Animation FROM_ITEM = new Animation(20);
    public static final Animation JUMP = new Animation(13);
    public boolean wasJumping;

    public BlueSlimeEntity(EntityType<? extends BlueSlimeEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.2f;
    }

    public static AttributeModifierMap.MutableAttribute Attributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 50.0).func_233815_a_(Attributes.field_233820_c_, 0.8).func_233815_a_(Attributes.field_233823_f_, 6.0).func_233815_a_(Attributes.field_233821_d_, 0.24);
    }

    @Override
    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, Optional.empty());
        this.field_70180_af.func_187214_a(PROTECTIVE_TICKS, (Object)-1);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        UUID uuid;
        super.func_70037_a(compound);
        if (compound.func_186855_b("Owner")) {
            uuid = compound.func_186857_a("Owner");
        } else {
            String s = compound.func_74779_i("Owner");
            uuid = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s);
        }
        if (uuid != null) {
            this.setOwnerId(uuid);
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.getOwnerId() != null) {
            compound.func_186854_a("Owner", this.getOwnerId());
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        AttributeModifier attributemodifier = new AttributeModifier(UUID.fromString("ECfA401C-4A16-11EB-B378-0242AC130002"), "BlueSlimeProtection", 120.0, AttributeModifier.Operation.ADDITION);
        this.field_70143_R = 0.0f;
        if (!this.isAnimationPlaying(Animation.NO_ANIMATION) && this.isAnimationPlaying(BACK_TO_ITEM) && this.getMainAnimationTick() == 20) {
            ItemStack stack = new ItemStack((IItemProvider)DannyItems.BLUE_SLIME.get());
            stack.func_190925_c("BlueSlimeTags");
            CompoundNBT compoundNBT = stack.func_179543_a("BlueSlimeTags");
            if (this.func_145818_k_()) {
                compoundNBT.func_74778_a("name", this.func_200200_C_().getString());
            } else {
                compoundNBT.func_74778_a("name", new TranslationTextComponent("entity.dannys_expansion.blue_slime").getString());
            }
            compoundNBT.func_74776_a("health", this.func_110143_aJ());
            if (((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).isPresent()) {
                compoundNBT.func_186854_a("owner", (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).get());
            }
            ItemEntity itemEntity = new ItemEntity(this.field_70170_p, this.func_213303_ch().field_72450_a, this.func_213303_ch().field_72448_b, this.func_213303_ch().field_72449_c, stack);
            itemEntity.func_213293_j(0.0, 0.5, 0.0);
            this.field_70170_p.func_217376_c((Entity)itemEntity);
            this.func_70106_y();
        }
        if (this.getProtectiveTicks() > -1) {
            this.setProtectiveTicks(this.getProtectiveTicks() + 1);
            this.func_70024_g(0.0, -0.05, 0.0);
            if (!this.func_110148_a(Attributes.field_233826_i_).func_180374_a(attributemodifier)) {
                this.func_110148_a(Attributes.field_233826_i_).func_233769_c_(attributemodifier);
            }
            if (this.getProtectiveTicks() == 285) {
                this.func_184185_a((SoundEvent)DannySounds.BLUE_SLIME_EXIT.get(), 1.0f, 1.0f);
            } else if (this.getProtectiveTicks() > 300) {
                this.setProtectiveTicks(-1);
            }
            if (!this.func_213305_a(this.func_213283_Z()).equals(new EntitySize(1.9125f, 1.4875f, super.func_213305_a((Pose)this.func_213283_Z()).field_220317_c))) {
                this.func_213323_x_();
            }
        } else {
            if (!this.func_213305_a(this.func_213283_Z()).equals(new EntitySize(1.125f, 0.875f, super.func_213305_a((Pose)this.func_213283_Z()).field_220317_c))) {
                this.func_213323_x_();
            }
            if (this.func_110148_a(Attributes.field_233826_i_).func_180374_a(attributemodifier)) {
                this.func_110148_a(Attributes.field_233826_i_).func_111124_b(attributemodifier);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.wasJumping && this.onGround()) {
            this.func_184185_a(SoundEvents.field_226135_eP_, 1.4f, 0.6f + this.field_70146_Z.nextFloat() * 0.2f);
            this.wasJumping = false;
        }
    }

    public boolean func_174833_aM() {
        return false;
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vec, Hand hand) {
        if (this.getOwner() == null) {
            this.setOwnerId(player.func_110124_au());
        }
        if (this.isOwner((LivingEntity)player) && this.isAnimationPlaying(Animation.NO_ANIMATION) && this.func_184179_bs() != player) {
            if (player.func_225608_bj_() && this.getProtectiveTicks() < 0) {
                this.playMainAnimation(BACK_TO_ITEM);
            } else {
                this.setRiddenBy(player);
            }
        }
        return super.func_184199_a(player, vec, hand);
    }

    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public void func_213352_e(Vector3d travelVector) {
        if (this.func_70089_S() && this.func_184179_bs() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)this.func_184179_bs();
            if (this.func_184207_aI() && livingentity != null) {
                this.field_70126_B = this.field_70177_z = livingentity.field_70177_z;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70759_as = this.field_70761_aq = this.field_70177_z;
                float f = livingentity.field_70702_br * 0.025f;
                float f1 = livingentity.field_191988_bg * 0.05f;
                if (f1 < 0.0f) {
                    f1 /= 2.0f;
                }
                if (this.onGround()) {
                    if (this.getProgress() > 0.0f && this.getProgressDifference() >= 0 && this.getProtectiveTicks() < 0) {
                        f = (float)((double)livingentity.field_70702_br * 0.005);
                        f1 = (float)((double)livingentity.field_191988_bg * 0.01);
                    }
                } else {
                    f = (float)((double)f * 1.65);
                    f1 = (float)((double)f1 * 1.65);
                }
                if (!this.onGround() || this.onGround() && this.func_70090_H()) {
                    f = (float)((double)f * 0.5);
                    f1 = (float)((double)f1 * 0.5);
                }
                if (this.getProtectiveTicks() > -1) {
                    f = (float)((double)f * 3.75);
                    f1 = (float)((double)f1 * 3.75);
                }
                float f2 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                float f3 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                float f4 = MathHelper.func_76126_a((float)(this.func_184229_a(Rotation.COUNTERCLOCKWISE_90) * ((float)Math.PI / 180)));
                float f5 = MathHelper.func_76134_b((float)(this.func_184229_a(Rotation.COUNTERCLOCKWISE_90) * ((float)Math.PI / 180)));
                this.func_213317_d(this.func_213322_ci().func_72441_c((double)(f2 * -f1 + f4 * -f), 0.0, (double)(f3 * f1 + f5 * f)));
            }
        }
        super.func_213352_e(travelVector);
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        passenger.func_70107_b(passenger.func_226277_ct_(), this.func_226278_cu_() + this.func_174813_aQ().func_216360_c() - 0.625, passenger.func_226281_cx_());
        float f1 = 0.0f;
        if (this.getProgress() > 0.0f) {
            f1 += MathUtil.freeAnimator(-0.6f, 0.0f, 0.0f, 2.0f, Easing.LINEAR, this.getProgress());
        }
        if (this.isAnimationPlaying(JUMP)) {
            f1 += MathUtil.freeAnimator(0.4f, 0.0f, 0.0f, 3.0f, Easing.LINEAR, this.getMainAnimationTick());
            f1 += MathUtil.freeAnimator(-0.4f, 0.4f, 3.0f, 12.0f, Easing.LINEAR, this.getMainAnimationTick());
        }
        if (this.getProtectiveTicks() > -1) {
            float f = -0.7f;
            f1 += MathUtil.freeAnimator(f, 0.0f, 0.0f, 10.0f, Easing.LINEAR, this.getProtectiveTicks());
            f1 += MathUtil.freeAnimator(-f, f, 290.0f, 300.0f, Easing.LINEAR, this.getProtectiveTicks());
            if (this.getProtectiveTicks() >= 10 && this.getProtectiveTicks() < 290) {
                f1 += f;
            }
            f1 = (float)((double)f1 + -0.6125);
        }
        passenger.func_70107_b(this.func_226277_ct_(), passenger.func_226278_cu_() + (double)f1, this.func_226281_cx_());
    }

    public boolean func_70075_an() {
        return super.func_70075_an() && this.getProtectiveTicks() < 0;
    }

    @Override
    public void doAct() {
        if (this.onGround() || this.field_70171_ac) {
            this.playMainAnimation(JUMP);
            this.func_184185_a(SoundEvents.field_226135_eP_, 1.2f, 0.6f + this.field_70146_Z.nextFloat() * 0.2f);
            this.func_213293_j(this.func_213322_ci().field_72450_a * 3.5 * (double)this.getProgress(), 2.0f * this.getProgress() + 0.5f, this.func_213322_ci().field_72449_c * 3.5 * (double)this.getProgress());
            this.wasJumping = true;
        }
    }

    @Override
    public void doAbility() {
        super.doAbility();
        this.func_184185_a((SoundEvent)DannySounds.BLUE_SLIME_ENTER.get(), 1.0f, 1.0f);
        this.setProtectiveTicks(0);
    }

    @Override
    public boolean progressIncreasingParams() {
        return super.progressIncreasingParams() && this.isAnimationPlaying(Animation.NO_ANIMATION) && this.getProtectiveTicks() < 0;
    }

    @Override
    public int abilityTimerAddition() {
        return 10;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        if (this.getProtectiveTicks() > -1) {
            return new EntitySize(1.9125f, 1.4875f, super.func_213305_a((Pose)poseIn).field_220317_c);
        }
        return super.func_213305_a(poseIn);
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    public int getProtectiveTicks() {
        return (Integer)this.func_184212_Q().func_187225_a(PROTECTIVE_TICKS);
    }

    public void setProtectiveTicks(int i) {
        this.func_184212_Q().func_187227_b(PROTECTIVE_TICKS, (Object)i);
    }

    @Nullable
    public LivingEntity getOwner() {
        try {
            UUID uuid = this.getOwnerId();
            return uuid == null ? null : this.field_70170_p.func_217371_b(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public boolean isOwner(LivingEntity entityIn) {
        return entityIn == this.getOwner();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.field_226139_eT_;
    }

    @Override
    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(this.getStepSound(), 0.15f, 1.0f);
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_226136_eQ_;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{FROM_ITEM, BACK_TO_ITEM, JUMP};
    }
}

