/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.common.Entities.spell;

import com.bottomtextdanny.dannys_expansion.client.animation.AmbientAnimation;
import com.bottomtextdanny.dannys_expansion.core.Packets.DENetwork;
import com.bottomtextdanny.dannys_expansion.core.Util.SimpleMotion;
import com.bottomtextdanny.dannys_expansion.core.Util.Timer;
import com.bottomtextdanny.dannys_expansion.core.interfaces.IAmbientAnimation;
import com.bottomtextdanny.dannys_expansion.core.interfaces.IAttachEntities;
import com.bottomtextdanny.dannys_expansion.core.interfaces.IClientManager;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class AbstractSpellEntity
extends Entity
implements IAmbientAnimation,
IAttachEntities,
IClientManager {
    protected static final DataParameter<Optional<UUID>> CASTER_UUID = EntityDataManager.func_187226_a(AbstractSpellEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    List<Entity> attachedEntities = Arrays.asList(new Entity[1]);
    List<AmbientAnimation> ambientAnimations = Arrays.asList(new AmbientAnimation[10]);
    public Vector3d forward = Vector3d.field_186680_a;
    public SimpleMotion simpleMotion = new SimpleMotion(0.0f);
    public float spellYaw;
    public float prevSpellYaw;
    public float spellPitch;
    public float prevSpellPitch;
    public Timer lifeTimer;

    public AbstractSpellEntity(EntityType<? extends AbstractSpellEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(CASTER_UUID, Optional.empty());
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_186855_b("Caster")) {
            this.setCasterUUID(compound.func_186857_a("Caster"));
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        if (this.getCasterUUID().isPresent()) {
            compound.func_186854_a("Caster", this.getCasterUUID().get());
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        if (key == CASTER_UUID) {
            this.getCasterUUID().ifPresent(uuid -> DENetwork.attachEntity(0, this, this.getCasterUUID().get()));
        }
        super.func_184206_a(key);
    }

    public void setCaster(LivingEntity livingEntity) {
        this.func_184212_Q().func_187227_b(CASTER_UUID, Optional.of(livingEntity.func_110124_au()));
    }

    @Nullable
    public LivingEntity getCaster() {
        if (this.getAttachedEntity(0) instanceof LivingEntity) {
            return (LivingEntity)this.getAttachedEntity(0);
        }
        return null;
    }

    public void setDeath() {
        this.onLifeEnd();
        this.func_70106_y();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.forward = Vector3d.func_189986_a((float)this.field_70125_A, (float)this.field_70177_z);
        if (this.lifeTimer.getTimer() == 0) {
            this.onLifeStart();
        }
        this.lifeTimer.tryUp();
        if (this.lifeTimer.hasEnded()) {
            this.setDeath();
        }
        if (this.movable()) {
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        }
        this.ambientAnimations.forEach(ambientAnimation -> {
            if (ambientAnimation != null && ambientAnimation.isWoke()) {
                if (ambientAnimation.getTick() <= ambientAnimation.getDuration()) {
                    ambientAnimation.setTick(ambientAnimation.getTick() + ambientAnimation.progress(ambientAnimation.getTick()));
                } else {
                    ambientAnimation.sleep();
                }
            }
        });
    }

    public void func_70030_z() {
        this.func_213317_d(this.func_213322_ci().func_216372_d(0.85, 0.85, 0.85));
        this.simpleMotion.tick();
        super.func_70030_z();
        this.setupRaytrace();
        this.func_213315_a(MoverType.SELF, this.simpleMotion.getAcceleratedMotion());
    }

    protected void setupRaytrace() {
        RayTraceResult raytraceresult = this.rayTraceResultType();
        this.onImpact(raytraceresult);
    }

    public void onLifeStart() {
    }

    public boolean casterHasAttackTarget() {
        if (this.getCaster() != null && this.getCaster() instanceof MobEntity) {
            return ((MobEntity)this.getCaster()).func_70638_az() != null;
        }
        return false;
    }

    public LivingEntity getCasterTarget() {
        if (this.getCaster() != null && this.getCaster() instanceof MobEntity) {
            return ((MobEntity)this.getCaster()).func_70638_az();
        }
        return null;
    }

    public void onLifeEnd() {
    }

    protected void onImpact(RayTraceResult result) {
        RayTraceResult.Type type = result.func_216346_c();
        if (type == RayTraceResult.Type.ENTITY && ((EntityRayTraceResult)result).func_216348_a() != this.getCaster()) {
            this.onEntityHit((EntityRayTraceResult)result);
        } else if (type == RayTraceResult.Type.BLOCK) {
            this.onBlockHit((BlockRayTraceResult)result);
        }
    }

    public Timer getLifeTimer() {
        return this.lifeTimer;
    }

    public int getLifeTick() {
        return this.lifeTimer.getTimer();
    }

    public void setLifeTime(int life) {
        if (this.getLifeTimer() == null) {
            this.lifeTimer = new Timer(life);
        } else {
            this.lifeTimer.setBoundBase(life);
        }
    }

    public void setCasterUUID(UUID casterUUID) {
        this.func_184212_Q().func_187227_b(CASTER_UUID, Optional.of(casterUUID));
    }

    public Optional<UUID> getCasterUUID() {
        return (Optional)this.func_184212_Q().func_187225_a(CASTER_UUID);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void dannyClientManager(int flag, float abstractVal) {
    }

    public void sendClientManagerMsg(int flag, float abstractVal) {
        DENetwork.triggerEntityClientAction(this, flag, abstractVal);
    }

    public void sendClientManagerMsg(int flag) {
        DENetwork.triggerEntityClientAction(this, flag);
    }

    public List<AmbientAnimation> getAmbientAnimations() {
        return this.ambientAnimations;
    }

    @Override
    public AmbientAnimation getAmbientAnimation(int index) {
        return this.ambientAnimations.get(index);
    }

    public int getAmbientAnimationTick(int index) {
        return this.ambientAnimations.get(index).getTick();
    }

    public void wakeAmbientAnimation(int index) {
        DENetwork.setAmbientAnimation(this, index);
        this.ambientAnimations.get(index).wake();
    }

    public void setAmbientAnimation(AmbientAnimation ambientAnimation, int index) {
        this.ambientAnimations.set(index, ambientAnimation);
    }

    public RayTraceResult rayTraceResultType() {
        return ProjectileHelper.func_234618_a_((Entity)this, this::collisionParameters);
    }

    public boolean collisionParameters(Entity entityIn) {
        return !entityIn.func_175149_v() && entityIn.func_70089_S() && entityIn.func_70067_L() && !entityIn.equals((Object)this.getCaster());
    }

    protected void onEntityHit(EntityRayTraceResult result) {
    }

    protected void onBlockHit(BlockRayTraceResult result) {
    }

    public void setRotations(float yaw, float pitch) {
        this.spellYaw = yaw;
        this.spellPitch = pitch;
        this.field_70177_z = yaw;
        this.field_70125_A = pitch;
        DENetwork.setCustomRotation(this, yaw, pitch, false);
    }

    public void func_70080_a(double x, double y, double z, float yaw, float pitch) {
        this.func_242281_f(x, y, z);
        this.field_70177_z = yaw % 360.0f;
        this.field_70125_A = MathHelper.func_76131_a((float)pitch, (float)-90.0f, (float)90.0f) % 360.0f;
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        this.spellYaw = yaw % 360.0f;
        this.spellPitch = MathHelper.func_76131_a((float)pitch, (float)-90.0f, (float)90.0f) % 360.0f;
        this.prevSpellYaw = this.spellYaw;
        this.prevSpellPitch = this.spellPitch;
    }

    public boolean castersDamage(LivingEntity livingEntity, float amount) {
        if (this.getCaster() != null) {
            return livingEntity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.getCaster()), amount);
        }
        return livingEntity.func_70097_a(DamageSource.field_76376_m, amount);
    }

    public boolean movable() {
        return true;
    }

    public void setSimpleMotion(double x, double y, double z) {
        this.simpleMotion.setMotion(x, y, z);
    }

    public Vector3d getSimpleMotion() {
        return this.simpleMotion.getAcceleratedMotion();
    }

    @Override
    public Entity getAttachedEntity(int index) {
        return this.attachedEntities.get(index);
    }

    @Override
    public void setAttachedEntity(Entity entity, int index) {
        this.attachedEntities.set(index, entity);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

