/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.common.Entities.spell;

import com.bottomtextdanny.dannys_expansion.common.Entities.living.SummonEntity;
import com.bottomtextdanny.dannys_expansion.common.Entities.spell.AbstractSpellEntity;
import com.bottomtextdanny.dannys_expansion.core.Registries.DannyParticles;
import com.bottomtextdanny.dannys_expansion.core.Registries.DannySounds;
import com.bottomtextdanny.dannys_expansion.core.Util.DannyRayTraceHelper;
import com.bottomtextdanny.dannys_expansion.core.Util.MathUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BarrenOrbEntity
extends AbstractSpellEntity {
    @OnlyIn(value=Dist.CLIENT)
    public float spillYaw;

    public BarrenOrbEntity(EntityType<? extends BarrenOrbEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.setLifeTime(35);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.func_184185_a((SoundEvent)DannySounds.ENTITY_BARREN_ORB_GENERATE.get(), 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.1f);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getLifeTick() >= 14) {
            this.func_213293_j(1.6 * this.forward.field_72450_a, 1.6 * this.forward.field_72448_b, 1.6 * this.forward.field_72449_c);
        } else {
            if (this.casterHasAttackTarget()) {
                float yaw = MathUtil.getTargetYaw(this, (Entity)this.getCasterTarget());
                float pitch = MathUtil.getTargetPitch(this, (Entity)this.getCasterTarget());
                this.setRotations(yaw, pitch);
            }
            if (this.field_70170_p.func_201670_d() && this.getLifeTick() % 2 == 1) {
                Vector3d vec0 = MathUtil.fromPitchYaw(0.0f, this.spellYaw + this.spillYaw).func_216372_d(0.7, 0.7, 0.7);
                this.field_70170_p.func_195594_a((IParticleData)DannyParticles.SAND_SMOKE.get(), this.func_213303_ch().field_72450_a, this.func_213303_ch().field_72448_b + 0.25, this.func_213303_ch().field_72449_c, vec0.field_72450_a, 0.0, vec0.field_72449_c);
            }
        }
    }

    @Override
    public void onLifeEnd() {
        super.onLifeEnd();
        if (!this.field_70170_p.field_72995_K) {
            this.func_184185_a((SoundEvent)DannySounds.ENTITY_BARREN_ORB_IMPACT.get(), 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.1f);
            this.sendClientManagerMsg(0);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void dannyClientManager(int flag, float abstractVal) {
        super.dannyClientManager(flag, abstractVal);
        if (flag == 0) {
            for (int i = 0; i < 10; ++i) {
                Vector3d vec0 = MathUtil.fromPitchYaw(10.0f, this.field_70146_Z.nextFloat() * 360.0f);
                this.field_70170_p.func_195594_a((IParticleData)DannyParticles.SAND_CLOUD.get(), this.func_226282_d_(0.6), this.func_226279_cv_() + 0.5, this.func_226287_g_(0.6), vec0.field_72450_a, vec0.field_72448_b, vec0.field_72449_c);
                this.field_70170_p.func_195594_a((IParticleData)DannyParticles.SAND_SMOKE.get(), this.func_226282_d_(0.6), this.func_226279_cv_() + 0.5, this.func_226287_g_(0.6), vec0.field_72450_a, vec0.field_72448_b, vec0.field_72449_c);
            }
        }
    }

    @Override
    public RayTraceResult rayTraceResultType() {
        return DannyRayTraceHelper.orbRaytrace(this, this::collisionParameters, this.func_213322_ci().func_178787_e(this.getSimpleMotion()), RayTraceContext.FluidMode.ANY);
    }

    @Override
    protected void onBlockHit(BlockRayTraceResult p_230299_1_) {
        super.onBlockHit(p_230299_1_);
        this.setDeath();
    }

    @Override
    protected void onEntityHit(EntityRayTraceResult p_213868_1_) {
        super.onEntityHit(p_213868_1_);
        if (!this.field_70170_p.func_201670_d() && p_213868_1_.func_216348_a() instanceof LivingEntity) {
            if (p_213868_1_.func_216348_a() instanceof SummonEntity) {
                if (((SummonEntity)p_213868_1_.func_216348_a()).getSummoner() != this.getCaster()) {
                    this.castersDamage((LivingEntity)p_213868_1_.func_216348_a(), 5.0f);
                    this.setDeath();
                }
            } else {
                this.castersDamage((LivingEntity)p_213868_1_.func_216348_a(), 5.0f);
                this.setDeath();
            }
        }
    }
}

