/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.common.Entities.spell;

import com.bottomtextdanny.dannys_expansion.client.animation.AmbientAnimation;
import com.bottomtextdanny.dannys_expansion.client.sound.GolemDroneLoopSound;
import com.bottomtextdanny.dannys_expansion.common.Entities.living.DannyEntity;
import com.bottomtextdanny.dannys_expansion.common.Entities.spell.AbstractSpellEntity;
import com.bottomtextdanny.dannys_expansion.core.Registries.DannyParticles;
import com.bottomtextdanny.dannys_expansion.core.Registries.DannySounds;
import com.bottomtextdanny.dannys_expansion.core.Util.EntityUtil;
import com.bottomtextdanny.dannys_expansion.core.Util.MathUtil;
import com.bottomtextdanny.dannys_expansion.core.Util.SimpleMotion;
import com.bottomtextdanny.dannys_expansion.core.Util.Timer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GolemDroneEntity
extends AbstractSpellEntity {
    @OnlyIn(value=Dist.CLIENT)
    GolemDroneLoopSound tchktchk;
    public byte hitCounter = 0;
    public Timer invTimer = new Timer(10);

    public GolemDroneEntity(EntityType<? extends GolemDroneEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.simpleMotion = new SimpleMotion(0.8f);
        this.setAmbientAnimation(new AmbientAnimation(8), 0);
        this.setLifeTime(200);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.invTimer.tryUp();
        if (!this.field_70170_p.func_201670_d()) {
            this.sendClientManagerMsg(0);
            if (this.hitCounter > 4) {
                this.setDeath();
            }
        }
        if (this.casterHasAttackTarget()) {
            float yaw = MathUtil.getTargetYaw(this, (Entity)this.getCasterTarget());
            float pitch = MathUtil.getTargetPitch(this, (Entity)this.getCasterTarget());
            this.setRotations(yaw, pitch);
            this.func_213293_j(0.35 * this.forward.field_72450_a, 0.35 * this.forward.field_72448_b, 0.35 * this.forward.field_72449_c);
            List entities = this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ());
            List entities1 = this.field_70170_p.func_217357_a(ProjectileEntity.class, this.func_174813_aQ());
            entities.removeIf(livingEntity -> livingEntity == this.getCaster());
            if (!entities.isEmpty() || !entities1.isEmpty()) {
                this.setDeath();
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void dannyClientManager(int flag, float abstractVal) {
        super.dannyClientManager(flag, abstractVal);
        if (flag == 0) {
            if (this.tchktchk == null) {
                this.tchktchk = new GolemDroneLoopSound(this);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.tchktchk);
            }
            if (this.tchktchk.func_147667_k() && Minecraft.func_71410_x().field_71439_g.func_70032_d((Entity)this) < 20.0f) {
                this.tchktchk = new GolemDroneLoopSound(this);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.tchktchk);
            }
            if ((double)this.field_70146_Z.nextFloat() < 0.3) {
                Vector3d vec0 = MathUtil.fromPitchYaw(this.field_70125_A, this.field_70177_z).func_216372_d(0.1, 0.1, 0.1);
                float xRandom = (float)this.field_70146_Z.nextGaussian() * 0.25f;
                float yRandom = (float)this.field_70146_Z.nextGaussian() * 0.25f;
                float zRandom = (float)this.field_70146_Z.nextGaussian() * 0.25f;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_() + (double)xRandom, this.func_226278_cu_() + (double)yRandom, this.func_226281_cx_() + (double)zRandom, -vec0.field_72450_a * 0.6, -vec0.field_72448_b * 0.6, -vec0.field_72449_c * 0.6);
            }
        }
    }

    public boolean func_85031_j(Entity entityIn) {
        if (this.invTimer.hasEnded()) {
            this.func_184185_a((SoundEvent)DannySounds.ENTITY_GOLEM_DRONE_HIT.get(), 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.05f);
            this.hitCounter = (byte)(this.hitCounter + 1);
            this.wakeAmbientAnimation(0);
            this.invTimer.reset();
            if (entityIn instanceof PlayerEntity) {
                Vector3d vec0 = MathUtil.fromPitchYaw(0.0f, MathUtil.getTargetYaw(entityIn, this));
                this.simpleMotion.setMotion(vec0.field_72450_a, 0.0, vec0.field_72449_c);
            }
            for (int i = 0; i < 5; ++i) {
                float xRandom = (float)this.field_70146_Z.nextGaussian() * 0.25f;
                float yRandom = (float)this.field_70146_Z.nextGaussian() * 0.25f;
                float zRandom = (float)this.field_70146_Z.nextGaussian() * 0.25f;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_() + (double)xRandom, this.func_226278_cu_() + (double)yRandom, this.func_226281_cx_() + (double)zRandom, 0.0, 0.0, 0.0);
            }
        }
        return super.func_85031_j(entityIn);
    }

    public boolean func_70067_L() {
        return true;
    }

    @Override
    public void onLifeEnd() {
        EntityUtil.particleAt(this.field_70170_p, (IParticleData)DannyParticles.EXPLOSION.get(), 1, this.func_213303_ch().field_72450_a, this.func_213303_ch().field_72448_b + 0.25, this.func_213303_ch().field_72449_c, 0.0, 0.0, 0.0, 0.0);
        this.func_184185_a((SoundEvent)DannySounds.ENTITY_GOLEM_DRONE_EXPLODE.get(), 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
        List entities = this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_186662_g(2.0));
        entities.removeIf(livingEntity -> livingEntity == this.getCaster());
        for (LivingEntity livingEntity2 : entities) {
            this.castersDamage(livingEntity2, 8.0f);
            DannyEntity.disableShield((Entity)livingEntity2, 50);
        }
    }
}

