/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.common.Inventory;

import com.bottomtextdanny.dannys_expansion.client.gui.screen.WorkbenchScreen;
import com.bottomtextdanny.dannys_expansion.core.Registries.DannyContainerTypes;
import com.bottomtextdanny.dannys_expansion.core.Util.Pair;
import com.bottomtextdanny.dannys_expansion.core.events.ResourceReloadHandler;
import com.bottomtextdanny.dannys_expansion.core.misc.WorkbenchCraft;
import com.bottomtextdanny.dannys_expansion.core.misc.WorkbenchIngredient;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IWorldPosCallable;

public class WorkbenchContainer
extends Container {
    private final PlayerInventory playerInventory;
    public WorkbenchCraft result;
    public List<Pair<WorkbenchCraft, WorkbenchScreen.CraftState>> semiCraftableRecipes = Lists.newArrayList();
    public List<Pair<WorkbenchCraft, WorkbenchScreen.CraftState>> craftableRecipes = Lists.newArrayList();
    public List<Pair<WorkbenchCraft, WorkbenchScreen.CraftState>> uncraftableRecipes = Lists.newArrayList();
    Slot resultInventorySlot;
    final IInventory resultInventory = new Inventory(1);

    public WorkbenchContainer(int id, PlayerInventory playerInventory, PacketBuffer data) {
        this(id, playerInventory, IWorldPosCallable.field_221489_a);
    }

    public WorkbenchContainer(int id, PlayerInventory playerInventoryIn, IWorldPosCallable iWorldPosCallable) {
        super((ContainerType)DannyContainerTypes.WORKBENCH.get(), id);
        this.playerInventory = playerInventoryIn;
        this.resultInventorySlot = this.func_75146_a(new Slot(this.resultInventory, 0, -2, -7){

            public boolean func_111238_b() {
                return this.func_75216_d();
            }

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }

            public ItemStack func_190901_a(PlayerEntity thePlayer, ItemStack stack) {
                List<WorkbenchIngredient> ingredients = WorkbenchContainer.this.result.copy().getIngredients();
                for (ItemStack invStack : ((WorkbenchContainer)WorkbenchContainer.this).playerInventory.field_70462_a) {
                    for (WorkbenchIngredient ingredient : ingredients) {
                        if (ingredient.getCount() <= 0 || invStack.func_77973_b() != ingredient.getItem()) continue;
                        if (invStack.func_190916_E() < ingredient.getCount()) {
                            WorkbenchContainer.this.playerInventory.func_184437_d(invStack);
                            ingredient.setCount(ingredient.getCount() - invStack.func_190916_E());
                            continue;
                        }
                        invStack.func_190920_e(invStack.func_190916_E() - ingredient.getCount());
                        ingredient.setCount(0);
                    }
                }
                WorkbenchContainer.this.func_75142_b();
                return super.func_190901_a(thePlayer, stack);
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)this.playerInventory, j + i * 9 + 9, 8 + j * 18, 120 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)this.playerInventory, k, 8 + k * 18, 178));
        }
    }

    public ItemStack getItemStackResult() {
        return this.resultInventorySlot.func_75211_c().func_77946_l();
    }

    public void onResultUpdate() {
        ItemStack stack = this.result.getResult().func_77946_l();
        this.resultInventorySlot.func_75215_d(stack);
        this.func_75142_b();
    }

    public void onPlayerInventoryUpdate() {
        this.craftableRecipes.clear();
        this.semiCraftableRecipes.clear();
        this.uncraftableRecipes.clear();
        for (WorkbenchCraft recipe : ResourceReloadHandler.recipeManager.getWorkbenchRecipes()) {
            boolean validated = true;
            boolean semi = false;
            for (WorkbenchIngredient ingredient : recipe.getIngredients()) {
                int countInInventory = 0;
                for (ItemStack stack : this.playerInventory.field_70462_a) {
                    if (stack.func_77951_h() || stack.func_77973_b() != ingredient.getItem()) continue;
                    countInInventory += stack.func_190916_E();
                    semi = true;
                }
                if (!validated || countInInventory >= ingredient.getCount()) continue;
                validated = false;
            }
            if (validated) {
                this.craftableRecipes.add(Pair.of(recipe, WorkbenchScreen.CraftState.CRAFTABLE));
                continue;
            }
            if (semi) {
                this.semiCraftableRecipes.add(Pair.of(recipe, WorkbenchScreen.CraftState.SEMI));
                continue;
            }
            this.uncraftableRecipes.add(Pair.of(recipe, WorkbenchScreen.CraftState.UNCRAFTABLE));
        }
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index == 0) {
                if (!this.func_75135_a(itemstack1, 1, 37, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            ItemStack itemstack2 = slot.func_190901_a(playerIn, itemstack1);
            if (index == 0) {
                playerIn.func_71019_a(itemstack2, false);
            }
        }
        return itemstack;
    }

    public ContainerType<?> func_216957_a() {
        return (ContainerType)DannyContainerTypes.WORKBENCH.get();
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }
}

