/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.common.Items.gun;

import com.bottomtextdanny.dannys_expansion.client.models.item.GolemHandgunModel;
import com.bottomtextdanny.dannys_expansion.common.Entities.bullet.AbstractBulletEntity;
import com.bottomtextdanny.dannys_expansion.common.Items.bullet._abstract.AbstractBulletItem;
import com.bottomtextdanny.dannys_expansion.common.Items.bullet._abstract.AbstractLargeBulletItem;
import com.bottomtextdanny.dannys_expansion.common.Items.gun.GunItem;
import com.bottomtextdanny.dannys_expansion.core.Registries.DannyItems;
import com.bottomtextdanny.dannys_expansion.core.Registries.DannySounds;
import com.bottomtextdanny.dannys_expansion.core.Util.MathUtil;
import com.bottomtextdanny.dannys_expansion.core.capabilities.player.DannyEntityCap;
import java.util.Random;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GolemHandgunItem
extends GunItem {
    public GolemHandgunItem(Item.Properties properties) {
        super(properties);
        this.recoilSup = (p, i) -> {
            float mult = 1.0f;
            if (p.func_225608_bj_() && p.func_233570_aj_()) {
                mult = 0.8f;
            }
            if (p.func_213314_bj()) {
                mult = 1.666f;
            }
            return MathHelper.func_151237_a((double)(i * 0.75), (double)0.0, (double)80.0) * (double)mult * 0.35;
        };
        this.movementSup = (p, i) -> {
            float mult = 1.0f;
            if (p.func_225608_bj_() && p.func_233570_aj_()) {
                mult = 0.1666f;
            }
            if (p.func_213314_bj()) {
                mult = 1.666f;
            }
            return MathHelper.func_151237_a((double)(i * 16.0), (double)0.0, (double)60.0) * (double)mult;
        };
        this.tooltipDamage = 6.0f;
    }

    @Override
    public void shoot(PlayerEntity player, ItemStack stack) {
        super.shoot(player, stack);
        float mult = 1.0f;
        AbstractBulletItem bulletItem = this.tryToGetBullet(AbstractLargeBulletItem.class, player);
        if (bulletItem != null) {
            DannyEntityCap capability = (DannyEntityCap)player.getCapability(DannyEntityCap.GUN_STABILITY).orElse(null);
            float xDispersion = (float)((this.recoilSup.get(player, capability.getRecoil()) + this.movementSup.get(player, MathUtil.getMovement((Entity)player))) * (double)((float)field_77697_d.nextGaussian()));
            float yDispersion = (float)((this.recoilSup.get(player, capability.getRecoil()) + this.movementSup.get(player, MathUtil.getMovement((Entity)player))) * (double)((float)field_77697_d.nextGaussian()));
            if (player.func_225608_bj_() && player.func_233570_aj_()) {
                mult = 0.75f;
            }
            if (player.func_213314_bj()) {
                mult = 1.333f;
            }
            bulletItem.onShot(player, player.field_70170_p);
            if (!player.field_70170_p.field_72995_K) {
                AbstractBulletEntity bullet = bulletItem.setupBullet(player.field_70170_p, player, this, 60);
                bullet.addBulletDamage(6.0f);
                bullet.func_70080_a(player.func_226277_ct_(), player.func_226280_cw_(), player.func_226281_cx_(), player.field_70759_as + xDispersion, player.field_70125_A - capability.getRecoil() + yDispersion / 2.0f);
                bullet.setOrigin((LivingEntity)player);
                player.field_70170_p.func_217376_c((Entity)bullet);
                player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226280_cw_(), player.func_226281_cx_(), (SoundEvent)DannySounds.ITEM_HEAVY_PISTOL_SHOT.get(), SoundCategory.NEUTRAL, 1.0f, 1.0f + new Random().nextFloat() * 0.2f);
            } else {
                this.setCameraRecoil(player, 35.0f, 0.7f * mult, 0.89f);
            }
            player.field_70125_A -= 10.0f;
            player.field_70177_z += (float)field_77697_d.nextGaussian() * 3.0f;
            this.setRecoil(player, 88.0f * mult, 120.0f, 1.0f, 0.87f);
        }
    }

    @Override
    public AbstractBulletItem getCorrectBullet() {
        return (AbstractBulletItem)DannyItems.LARGE_BULLET.get();
    }

    @Override
    public int cooldownAddition() {
        return 10;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Model model() {
        return new GolemHandgunModel();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation modelTexture() {
        return new ResourceLocation("dannys_expansion:textures/models/item/golem_handgun.png");
    }
}

