/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.common.Items.gun;

import com.bottomtextdanny.dannys_expansion.client.ClientInstance;
import com.bottomtextdanny.dannys_expansion.common.Items.bullet._abstract.AbstractBulletItem;
import com.bottomtextdanny.dannys_expansion.core.Registries.DannyItems;
import com.bottomtextdanny.dannys_expansion.core.capabilities.player.DannyEntityCap;
import com.bottomtextdanny.dannys_expansion.core.events.ClientEventHandler;
import com.bottomtextdanny.dannys_expansion.core.interfaces.ISpecialModel;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Formatter;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class GunItem
extends Item
implements ISpecialModel {
    public LivingEntity livingEntity;
    public int cooldown;
    public float tooltipDamage;
    public GunValueSupplier recoilSup = (p, i) -> 0.0;
    public GunValueSupplier movementSup = (p, i) -> 0.0;
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;

    public GunItem(Item.Properties properties) {
        super(properties.func_200917_a(1));
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", 9999999.0, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return false;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof LivingEntity) {
            this.livingEntity = (LivingEntity)entityIn;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public void shoot(PlayerEntity player, ItemStack stack) {
        if (player.field_70170_p.field_72995_K && player == ClientInstance.player()) {
            ClientEventHandler.C_ROLL_DIRECTION = field_77697_d.nextInt(2) == 1 ? 1 : -1;
        }
        this.cooldown += this.cooldownAddition();
        player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)stack.func_77973_b()));
    }

    public int cooldownAddition() {
        return 5;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType equipmentSlot) {
        return equipmentSlot == EquipmentSlotType.MAINHAND ? this.attributeModifiers : super.func_111205_h(equipmentSlot);
    }

    public <E extends AbstractBulletItem> AbstractBulletItem tryToGetBullet(Class<E> clazz, PlayerEntity player) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!clazz.isAssignableFrom(itemstack.func_77973_b().getClass())) continue;
            ItemStack itemstack1 = itemstack.func_77946_l();
            if (!player.field_70170_p.func_201670_d() && !player.func_184812_l_()) {
                itemstack.func_190918_g(1);
            }
            return (AbstractBulletItem)itemstack1.func_77973_b();
        }
        if (player.func_184812_l_()) {
            return this.getCorrectBullet();
        }
        return null;
    }

    public void setRecoil(PlayerEntity player, float recoil, float recoilMax, float recoilSub, float recoilMult) {
        DannyEntityCap capability = (DannyEntityCap)player.getCapability(DannyEntityCap.GUN_STABILITY).orElse(null);
        capability.setRecoilSub(recoilSub);
        capability.setRecoilMult(recoilMult);
        capability.setRecoil(Math.min(capability.getRecoil() + recoil, recoilMax));
        if (player.field_70170_p.field_72995_K) {
            this.setClientRecoil(player, recoil, recoilMax, recoilSub, recoilMult);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setClientRecoil(PlayerEntity player, float recoil, float recoilMax, float recoilSub, float recoilMult) {
        if (player == ClientInstance.player()) {
            ClientEventHandler.C_RECOIL = recoil;
            ClientEventHandler.C_RECOIL_SUBTRACT = recoilSub;
            ClientEventHandler.C_RECOIL_MULT = recoilMult;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateSuppliers(PlayerEntity player, double recoilParam, double movementParam) {
        ClientEventHandler.C_DISPERSION = this.recoilSup.get(player, recoilParam) + this.movementSup.get(player, movementParam) + (double)this.getExtraCrosshairDegrees(player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setCameraRecoil(PlayerEntity player, float recoil, float recoilSubstraction, float recoilMult) {
        if (player.equals((Object)ClientInstance.player())) {
            ClientEventHandler.C_PITCH_RECOIL = recoil;
            ClientEventHandler.C_PITCH_RECOIL_SUBTRACT = recoilSubstraction;
            ClientEventHandler.C_PITCH_RECOIL_MULT = recoilMult;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getExtraCrosshairDegrees(PlayerEntity player) {
        return 0;
    }

    public AbstractBulletItem getCorrectBullet() {
        return (AbstractBulletItem)DannyItems.SHORT_BULLET.get();
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new TranslationTextComponent("description.dannys_expansion.gun_damage").func_240702_b_(": ").func_240699_a_(TextFormatting.GREEN).func_240702_b_(new Formatter().format("%.2f", Float.valueOf(this.tooltipDamage)).toString()));
        tooltip.add((ITextComponent)new TranslationTextComponent("description.dannys_expansion.gun_cooldown").func_240702_b_(": ").func_240699_a_(TextFormatting.GREEN).func_240702_b_(new Formatter().format("%.2f", Float.valueOf((float)this.cooldownAddition() / 20.0f)).toString()).func_240702_b_("s"));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Model model() {
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation modelTexture() {
        return null;
    }

    @FunctionalInterface
    public static interface GunValueSupplier {
        public double get(PlayerEntity var1, double var2);
    }
}

