/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.common.Items.gun;

import com.bottomtextdanny.dannys_expansion.client.models.item.HandgunModel;
import com.bottomtextdanny.dannys_expansion.common.Entities.bullet.AbstractBulletEntity;
import com.bottomtextdanny.dannys_expansion.common.Items.bullet._abstract.AbstractBulletItem;
import com.bottomtextdanny.dannys_expansion.common.Items.bullet._abstract.AbstractShortBulletItem;
import com.bottomtextdanny.dannys_expansion.common.Items.gun.GunItem;
import com.bottomtextdanny.dannys_expansion.core.Registries.DannySounds;
import com.bottomtextdanny.dannys_expansion.core.Util.MathUtil;
import com.bottomtextdanny.dannys_expansion.core.capabilities.player.DannyEntityCap;
import java.util.Random;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class HandgunItem
extends GunItem {
    public HandgunItem(Item.Properties properties) {
        super(properties);
        this.recoilSup = (p, i) -> {
            float mult = 1.0f;
            if (p.func_225608_bj_() && p.func_233570_aj_()) {
                mult = 0.75f;
            }
            if (p.func_213314_bj()) {
                mult = 2.666f;
            }
            return MathHelper.func_151237_a((double)((i - 10.0) * 0.25), (double)0.0, (double)25.0) * (double)mult;
        };
        this.movementSup = (p, i) -> {
            float mult = 1.0f;
            if (p.func_225608_bj_() && p.func_233570_aj_()) {
                mult = 0.1666f;
            }
            if (p.func_213314_bj()) {
                mult = 2.666f;
            }
            return MathHelper.func_151237_a((double)(i * 7.0), (double)0.0, (double)60.0) * (double)mult;
        };
        this.tooltipDamage = 2.0f;
    }

    @Override
    public void shoot(PlayerEntity player, ItemStack stack) {
        super.shoot(player, stack);
        float mult = 1.0f;
        AbstractBulletItem bulletItem = this.tryToGetBullet(AbstractShortBulletItem.class, player);
        if (bulletItem != null) {
            DannyEntityCap capability = (DannyEntityCap)player.getCapability(DannyEntityCap.GUN_STABILITY).orElse(null);
            float xDispersion = (float)((this.recoilSup.get(player, capability.getRecoil()) + this.movementSup.get(player, MathUtil.getMovement((Entity)player))) * (double)((float)field_77697_d.nextGaussian()));
            float yDispersion = (float)((this.recoilSup.get(player, capability.getRecoil()) + this.movementSup.get(player, MathUtil.getMovement((Entity)player))) * (double)((float)field_77697_d.nextGaussian()));
            if (player.func_225608_bj_() && player.func_233570_aj_()) {
                mult = 0.75f;
            }
            if (player.func_213314_bj()) {
                mult = 1.333f;
            }
            bulletItem.onShot(player, player.field_70170_p);
            if (!player.field_70170_p.field_72995_K) {
                AbstractBulletEntity bullet = bulletItem.setupBullet(player.field_70170_p, player, this, 60);
                bullet.addBulletDamage(2.0f);
                bullet.func_70080_a(player.func_226277_ct_(), player.func_226280_cw_(), player.func_226281_cx_(), player.field_70759_as + xDispersion, player.field_70125_A - capability.getRecoil() + yDispersion / 2.0f);
                bullet.setOrigin((LivingEntity)player);
                player.field_70170_p.func_217376_c((Entity)bullet);
                player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226280_cw_(), player.func_226281_cx_(), (SoundEvent)DannySounds.ITEM_PISTOL_SHOT.get(), SoundCategory.NEUTRAL, 1.0f, 1.0f + new Random().nextFloat() * 0.2f);
            } else {
                this.setCameraRecoil(player, 12.0f * mult, 0.6f * mult, 0.9f);
            }
            this.setRecoil(player, 45.0f * mult, 70.0f, 4.0f, 0.9f);
        }
    }

    @Override
    public int cooldownAddition() {
        return 4;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Model model() {
        return new HandgunModel();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation modelTexture() {
        return new ResourceLocation("dannys_expansion:textures/models/item/handgun.png");
    }
}

