/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.common.Items.gun;

import com.bottomtextdanny.dannys_expansion.client.models.item.ShotgunModel;
import com.bottomtextdanny.dannys_expansion.common.Entities.bullet.AbstractBulletEntity;
import com.bottomtextdanny.dannys_expansion.common.Items.bullet._abstract.AbstractBulletItem;
import com.bottomtextdanny.dannys_expansion.common.Items.bullet._abstract.AbstractShotgunShellItem;
import com.bottomtextdanny.dannys_expansion.common.Items.gun.GunItem;
import com.bottomtextdanny.dannys_expansion.core.Registries.DannyItems;
import com.bottomtextdanny.dannys_expansion.core.Registries.DannySounds;
import com.bottomtextdanny.dannys_expansion.core.Util.MathUtil;
import com.bottomtextdanny.dannys_expansion.core.capabilities.player.DannyEntityCap;
import java.util.Random;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ShotgunItem
extends GunItem {
    public ShotgunItem(Item.Properties properties) {
        super(properties);
        this.recoilSup = (p, i) -> {
            float mult = 1.0f;
            if (p.func_225608_bj_() && p.func_233570_aj_()) {
                mult = 0.2f;
            }
            if (p.func_213314_bj()) {
                mult = 2.0f;
            }
            return MathHelper.func_151237_a((double)(i * (double)0.55f), (double)0.0, (double)10.0) * (double)mult;
        };
        this.movementSup = (p, i) -> {
            float mult = 1.0f;
            if (p.func_225608_bj_() && p.func_233570_aj_()) {
                mult = 0.1666f;
            }
            if (p.func_213314_bj()) {
                mult = 2.0f;
            }
            return MathHelper.func_151237_a((double)(i * 20.0), (double)0.0, (double)40.0) * (double)mult;
        };
        this.tooltipDamage = 18.0f;
    }

    @Override
    public void shoot(PlayerEntity player, ItemStack stack) {
        super.shoot(player, stack);
        AbstractBulletItem bulletItem = this.tryToGetBullet(AbstractShotgunShellItem.class, player);
        if (bulletItem != null) {
            DannyEntityCap capability = (DannyEntityCap)player.getCapability(DannyEntityCap.GUN_STABILITY).orElse(null);
            bulletItem.onShot(player, player.field_70170_p);
            if (!player.field_70170_p.field_72995_K) {
                player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226280_cw_(), player.func_226281_cx_(), (SoundEvent)DannySounds.ITEM_SHOTGUN_SHOT.get(), SoundCategory.NEUTRAL, 2.0f, 1.0f + new Random().nextFloat() * 0.2f);
                float xDispersion = (float)((this.recoilSup.get(player, capability.getRecoil()) + this.movementSup.get(player, MathUtil.getMovement((Entity)player))) * (double)((float)field_77697_d.nextGaussian()));
                float yDispersion = (float)((this.recoilSup.get(player, capability.getRecoil()) + this.movementSup.get(player, MathUtil.getMovement((Entity)player))) * (double)((float)field_77697_d.nextGaussian()));
                for (int i = 0; i < 6; ++i) {
                    AbstractBulletEntity bullet = bulletItem.setupBullet(player.field_70170_p, player, this, 40);
                    bullet.addBulletDamage(3.0f);
                    bullet.func_70080_a(player.func_226277_ct_(), player.func_226280_cw_(), player.func_226281_cx_(), player.field_70759_as + (float)field_77697_d.nextGaussian() * 8.0f + xDispersion, player.field_70125_A - capability.getRecoil() + (float)field_77697_d.nextGaussian() * 8.0f + yDispersion);
                    bullet.setOrigin((LivingEntity)player);
                    player.field_70170_p.func_217376_c((Entity)bullet);
                }
            } else {
                this.setCameraRecoil(player, 24.0f, 1.8f, 0.91f);
            }
            this.setRecoil(player, 50.0f, 70.0f, 4.0f, 1.0f);
        }
    }

    @Override
    public AbstractBulletItem getCorrectBullet() {
        return (AbstractBulletItem)DannyItems.SHOTGUN_SHELL.get();
    }

    @Override
    public int getExtraCrosshairDegrees(PlayerEntity player) {
        return 8;
    }

    @Override
    public int cooldownAddition() {
        return 20;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Model model() {
        return new ShotgunModel();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation modelTexture() {
        return new ResourceLocation("dannys_expansion:textures/models/item/shotgun.png");
    }
}

