/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.common.World.structures.anglerstreasure;

import com.bottomtextdanny.dannys_expansion.common.World.structures.anglerstreasure.ATGroundCoralDecorator;
import com.bottomtextdanny.dannys_expansion.common.World.structures.anglerstreasure.ATSlabStripesDecorator;
import com.bottomtextdanny.dannys_expansion.common.World.structures.anglerstreasure.ATStackedBlocksDecorator;
import com.bottomtextdanny.dannys_expansion.common.World.structures.util.PieceUtil;
import com.bottomtextdanny.dannys_expansion.core.Registries.DannyBlocks;
import com.bottomtextdanny.dannys_expansion.core.Registries.DannyStructures;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SixWayBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.ScatteredStructurePiece;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class AnglersTreasurePiece
extends ScatteredStructurePiece {
    public AnglersTreasurePiece(Random random, int x, int z) {
        super(DannyStructures.ANGLERS_TREASURE_PIECE, random, x, 64, z, 7, 7, 9);
    }

    public AnglersTreasurePiece(TemplateManager templateManager, CompoundNBT compoundNBT) {
        super(DannyStructures.ANGLERS_TREASURE_PIECE, compoundNBT);
    }

    protected void func_143011_b(CompoundNBT tagCompound) {
        super.func_143011_b(tagCompound);
    }

    public boolean func_230383_a_(ISeedReader world, StructureManager manager, ChunkGenerator chunkGen, Random rand, MutableBoundingBox boundingBox, ChunkPos chunkPos, BlockPos pos) {
        if (!this.func_202580_a((IWorld)world, boundingBox, 0)) {
            return false;
        }
        if ((pos = new BlockPos(pos.func_177958_n(), chunkGen.func_222529_a(pos.func_177958_n(), pos.func_177952_p(), Heightmap.Type.OCEAN_FLOOR) + 3 + rand.nextInt(5), pos.func_177952_p())).func_177956_o() + 6 > chunkGen.func_230356_f_()) {
            return false;
        }
        MainPlatformPiece flatFrame = new MainPlatformPiece(world, pos, MathHelper.func_76136_a((Random)rand, (int)8, (int)12), MathHelper.func_76136_a((Random)rand, (int)11, (int)17));
        return true;
    }

    class MainPlatformPiece {
        public BlockPos platformCenterPos;
        public Leg[] legs = new Leg[4];

        public MainPlatformPiece(ISeedReader world, BlockPos pos, int xWidth, int zWidth) {
            BlockPos bp2;
            int i;
            PieceUtil.FlatFrame flatFrame0 = new PieceUtil.FlatFrame(pos.func_177958_n() - xWidth / 2 + 1, pos.func_177952_p() - zWidth / 2 + 1, pos.func_177958_n() + xWidth / 2 - 1, pos.func_177952_p() + zWidth / 2 - 1, pos.func_177956_o() - 1);
            PieceUtil.FlatFrame flatFrame1 = new PieceUtil.FlatFrame(pos.func_177958_n() - xWidth / 2, pos.func_177952_p() - zWidth / 2, pos.func_177958_n() + xWidth / 2, pos.func_177952_p() + zWidth / 2, pos.func_177956_o() + 1);
            Random random = new Random();
            int longLegIndex = 0;
            int extraSpaces = 0;
            this.platformCenterPos = pos;
            this.legs[0] = new Leg(world, new BlockPos(pos.func_177958_n() - xWidth / 2 + 1, pos.func_177956_o() - 1, pos.func_177952_p() - zWidth / 2 + 1), bs -> bs.func_177230_c() == Blocks.field_150355_j || bs.func_177230_c() == Blocks.field_150350_a);
            this.legs[1] = new Leg(world, new BlockPos(pos.func_177958_n() - xWidth / 2 + 1, pos.func_177956_o() - 1, pos.func_177952_p() + zWidth / 2 - 1), bs -> bs.func_177230_c() == Blocks.field_150355_j || bs.func_177230_c() == Blocks.field_150350_a);
            this.legs[2] = new Leg(world, new BlockPos(pos.func_177958_n() + xWidth / 2 - 1, pos.func_177956_o() - 1, pos.func_177952_p() - zWidth / 2 + 1), bs -> bs.func_177230_c() == Blocks.field_150355_j || bs.func_177230_c() == Blocks.field_150350_a);
            this.legs[3] = new Leg(world, new BlockPos(pos.func_177958_n() + xWidth / 2 - 1, pos.func_177956_o() - 1, pos.func_177952_p() + zWidth / 2 - 1), bs -> bs.func_177230_c() == Blocks.field_150355_j || bs.func_177230_c() == Blocks.field_150350_a);
            PieceUtil.PositionStack posStack0 = PieceUtil.fillRegion(world, pos, -xWidth / 2, 0, -zWidth / 2, xWidth / 2, 0, zWidth / 2, Blocks.field_196664_o.func_176223_P());
            List<BlockPos> randomBorderBlocks1 = posStack0.expand(-2, 0, -2).move(0, 1, 0).randomPickedBlocks(random, MathHelper.func_76136_a((Random)random, (int)2, (int)4));
            List<BlockPos> randomBorderBlocks2 = posStack0.expand(-2, 0, -2).move(0, 1, 0).randomPickedBlocks(random, MathHelper.func_76136_a((Random)random, (int)0, (int)5));
            HashSet<BlockPos> platformIterator = new HashSet<BlockPos>(posStack0.positions);
            TreasurePlatform platformPiece1 = new TreasurePlatform(world, random, new BlockPos(pos.func_177958_n() - xWidth / 2 + MathHelper.func_76136_a((Random)random, (int)0, (int)(xWidth / 2)), pos.func_177956_o() + MathHelper.func_76136_a((Random)random, (int)0, (int)5) + 5, pos.func_177952_p() - zWidth / 2 + MathHelper.func_76136_a((Random)random, (int)0, (int)(zWidth / 2))), MathHelper.func_76136_a((Random)random, (int)5, (int)7), MathHelper.func_76136_a((Random)random, (int)6, (int)8));
            PieceUtil.decorateBPs(new ATStackedBlocksDecorator(world, pos, random, Blocks.field_150407_cf.func_176223_P(), Blocks.field_203216_jz.func_176223_P(), Blocks.field_150435_aG.func_176223_P()), randomBorderBlocks1);
            PieceUtil.decorateBPs(new ATGroundCoralDecorator(world, random), randomBorderBlocks2);
            PieceUtil.placeFencesInFrameAT(world, flatFrame1, Blocks.field_180407_aO.func_176223_P(), Blocks.field_209389_ab.func_176223_P());
            for (i = 0; i < flatFrame1.blocks.getKey().length; ++i) {
                int j;
                bp2 = flatFrame1.blocks.getKey()[i];
                Direction outDirection = flatFrame1.blocks.getValue()[i];
                if (bp2 == null || outDirection == null || extraSpaces >= 6 || !((double)random.nextFloat() < 0.05)) continue;
                int halfXWidth = MathHelper.func_76136_a((Random)random, (int)1, (int)4);
                int halfZWidth = MathHelper.func_76136_a((Random)random, (int)1, (int)4);
                PieceUtil.PositionStack extraPositions = PieceUtil.fillRegion(world, bp2, -halfXWidth, -1, -halfZWidth, halfXWidth, -1, halfZWidth, Blocks.field_196664_o.func_176223_P());
                platformIterator.addAll(extraPositions.positions);
                Leg extraLeg = new Leg(world, bp2.func_177967_a(outDirection, outDirection.func_176740_k() == Direction.Axis.X ? halfXWidth - 1 : halfZWidth - 1).func_177979_c(2), bs -> bs.func_177230_c() == Blocks.field_150355_j || bs.func_177230_c() == Blocks.field_150350_a);
                extraLeg.getPillarStream().forEach(legPos -> PieceUtil.placeUpdateFence(world, legPos, Blocks.field_196617_K.func_176223_P()));
                if (flatFrame1.blocks.getValue()[i].func_176740_k() == Direction.Axis.X) {
                    PieceUtil.setAirOrWater(world, bp2);
                    for (j = 0; j < halfZWidth; ++j) {
                        PieceUtil.delete1AxisFenceAT(world, bp2.func_177967_a(Direction.NORTH, j), outDirection, Blocks.field_180407_aO);
                        PieceUtil.delete1AxisFenceAT(world, bp2.func_177967_a(Direction.SOUTH, j), outDirection, Blocks.field_180407_aO);
                    }
                } else {
                    for (j = 0; j < halfXWidth; ++j) {
                        PieceUtil.delete1AxisFenceAT(world, bp2.func_177967_a(Direction.WEST, j), outDirection, Blocks.field_180407_aO);
                        PieceUtil.delete1AxisFenceAT(world, bp2.func_177967_a(Direction.EAST, j), outDirection, Blocks.field_180407_aO);
                    }
                }
                ++extraSpaces;
            }
            for (i = 0; i < flatFrame0.blocks.getKey().length; ++i) {
                bp2 = flatFrame0.blocks.getKey()[i];
                Direction dir0 = flatFrame0.blocks.getValue()[i];
                if (bp2 == null || dir0 == null || world.func_180495_p(bp2).func_177230_c() == Blocks.field_150355_j && world.func_180495_p(bp2).func_200132_m()) continue;
                Direction dir1 = dir0.func_176746_e();
                PieceUtil.setWLBlock(world, bp2, (BlockState)((BlockState)Blocks.field_180408_aP.func_176223_P().func_206870_a((Property)SixWayBlock.field_196491_B.getOrDefault(dir1, SixWayBlock.field_196488_a), (Comparable)Boolean.valueOf(true))).func_206870_a((Property)SixWayBlock.field_196491_B.getOrDefault(dir1.func_176734_d(), SixWayBlock.field_196488_a), (Comparable)Boolean.valueOf(true)));
                PieceUtil.setWLBlock(world, bp2.func_177979_c(2), (BlockState)((BlockState)Blocks.field_180408_aP.func_176223_P().func_206870_a((Property)SixWayBlock.field_196491_B.getOrDefault(dir1, SixWayBlock.field_196488_a), (Comparable)Boolean.valueOf(true))).func_206870_a((Property)SixWayBlock.field_196491_B.getOrDefault(dir1.func_176734_d(), SixWayBlock.field_196488_a), (Comparable)Boolean.valueOf(true)));
            }
            for (i = 0; i < 4; ++i) {
                if ((double)random.nextFloat() < 0.8) {
                    PieceUtil.cornerFencesAT(world, random, flatFrame0, i, MathHelper.func_76136_a((Random)random, (int)2, (int)6));
                }
                this.legs[i].getPillarStream().forEach(bp -> {
                    float f0 = random.nextFloat();
                    if ((double)f0 < 0.1) {
                        PieceUtil.placeUpdateFence(world, bp, Blocks.field_203205_S.func_176223_P());
                    } else if ((double)f0 < 0.2) {
                        PieceUtil.placeUpdateFence(world, bp, Blocks.field_203209_W.func_176223_P());
                    } else {
                        PieceUtil.placeUpdateFence(world, bp, Blocks.field_196617_K.func_176223_P());
                    }
                });
                if (this.legs[i].heightDown <= longLegIndex) continue;
                longLegIndex = i;
            }
            if (this.legs[longLegIndex].heightDown > 5) {
                PlatformPiece i2 = new PlatformPiece(world, random, this.legs[longLegIndex].supportPos.func_177979_c(MathHelper.func_76136_a((Random)random, (int)4, (int)7)), MathHelper.func_76136_a((Random)random, (int)7, (int)10), MathHelper.func_76136_a((Random)random, (int)11, (int)15));
            } else if (this.legs[longLegIndex].heightDown > 3 && (double)random.nextFloat() < 0.6) {
                PlatformPiece i2 = new PlatformPiece(world, random, this.legs[longLegIndex].supportPos.func_177979_c(MathHelper.func_76136_a((Random)random, (int)4, (int)5)), MathHelper.func_76136_a((Random)random, (int)9, (int)12), MathHelper.func_76136_a((Random)random, (int)13, (int)17));
            }
            List<BlockPos> randomBorderBlocks0 = PieceUtil.randomPickedBlocks(random, Lists.newArrayList(platformIterator), 26);
            PieceUtil.decorateBPs(new ATSlabStripesDecorator(world, random, Blocks.field_196624_br.func_176223_P(), Blocks.field_196664_o), randomBorderBlocks0);
        }
    }

    static class Leg {
        public BlockPos supportPos;
        public Predicate<BlockState> predicate;
        public int heightDown = 0;

        public Leg(ISeedReader world, BlockPos pos, Predicate<BlockState> predicate) {
            this.supportPos = pos;
            this.predicate = predicate;
            do {
                ++this.heightDown;
            } while (predicate.test(world.func_180495_p(pos.func_177979_c(this.heightDown))));
        }

        public Stream<BlockPos> getPillarStream() {
            BlockPos[] pillarPositions = new BlockPos[this.heightDown];
            for (int i = 0; i < this.heightDown; ++i) {
                pillarPositions[i] = new BlockPos(this.supportPos.func_177958_n(), this.supportPos.func_177956_o() - i, this.supportPos.func_177952_p());
            }
            return Arrays.stream(pillarPositions);
        }
    }

    class TreasurePlatform
    extends PlatformPiece {
        public TreasurePlatform(ISeedReader world, Random random, BlockPos pos, int xWidth, int zWidth) {
            int i;
            super(pos);
            PieceUtil.fillRegion(world, pos, -xWidth / 2, 0, -zWidth / 2, xWidth / 2, 0, zWidth / 2, Blocks.field_196664_o.func_176223_P());
            PieceUtil.fillRegion(world, pos.func_177981_b(3), -xWidth / 2 - 1, 0, -zWidth / 2 - 1, xWidth / 2 + 1, 0, zWidth / 2 + 1, Blocks.field_209390_ac.func_176223_P());
            PieceUtil.fillRegion(world, pos.func_177981_b(3), -xWidth / 2 + 1, 1, -zWidth / 2 + 1, xWidth / 2 - 1, 1, zWidth / 2 - 1, Blocks.field_209390_ac.func_176223_P());
            PieceUtil.FlatFrame flatFrame0 = new PieceUtil.FlatFrame(pos.func_177958_n() - xWidth / 2 + 1, pos.func_177952_p() - zWidth / 2 + 1, pos.func_177958_n() + xWidth / 2 - 1, pos.func_177952_p() + zWidth / 2 - 1, pos.func_177956_o() - 1);
            PieceUtil.FlatFrame flatFrame1 = new PieceUtil.FlatFrame(pos.func_177958_n() - xWidth / 2, pos.func_177952_p() - zWidth / 2, pos.func_177958_n() + xWidth / 2, pos.func_177952_p() + zWidth / 2, pos.func_177956_o() + 1);
            for (i = 0; i < flatFrame0.blocks.getKey().length; ++i) {
                BlockPos bp2 = flatFrame0.blocks.getKey()[i];
                Direction dir0 = flatFrame0.blocks.getValue()[i];
                if (bp2 == null || dir0 == null || world.func_180495_p(bp2).func_177230_c() == Blocks.field_150355_j && world.func_180495_p(bp2).func_200132_m()) continue;
                Direction dir1 = dir0.func_176746_e();
                PieceUtil.setWLBlock(world, bp2, (BlockState)((BlockState)Blocks.field_180408_aP.func_176223_P().func_206870_a((Property)SixWayBlock.field_196491_B.getOrDefault(dir1, SixWayBlock.field_196488_a), (Comparable)Boolean.valueOf(true))).func_206870_a((Property)SixWayBlock.field_196491_B.getOrDefault(dir1.func_176734_d(), SixWayBlock.field_196488_a), (Comparable)Boolean.valueOf(true)));
                PieceUtil.setWLBlock(world, bp2.func_177979_c(2), (BlockState)((BlockState)Blocks.field_180408_aP.func_176223_P().func_206870_a((Property)SixWayBlock.field_196491_B.getOrDefault(dir1, SixWayBlock.field_196488_a), (Comparable)Boolean.valueOf(true))).func_206870_a((Property)SixWayBlock.field_196491_B.getOrDefault(dir1.func_176734_d(), SixWayBlock.field_196488_a), (Comparable)Boolean.valueOf(true)));
            }
            this.legs[0] = new Leg(world, new BlockPos(pos.func_177958_n() - xWidth / 2 + 1, pos.func_177956_o() - 1, pos.func_177952_p() - zWidth / 2 + 1), bs -> bs.func_177230_c() == Blocks.field_150355_j || bs.func_177230_c() == Blocks.field_150350_a || bs.func_177230_c() == Blocks.field_180408_aP);
            this.legs[1] = new Leg(world, new BlockPos(pos.func_177958_n() - xWidth / 2 + 1, pos.func_177956_o() - 1, pos.func_177952_p() + zWidth / 2 - 1), bs -> bs.func_177230_c() == Blocks.field_150355_j || bs.func_177230_c() == Blocks.field_150350_a || bs.func_177230_c() == Blocks.field_180408_aP);
            this.legs[2] = new Leg(world, new BlockPos(pos.func_177958_n() + xWidth / 2 - 1, pos.func_177956_o() - 1, pos.func_177952_p() - zWidth / 2 + 1), bs -> bs.func_177230_c() == Blocks.field_150355_j || bs.func_177230_c() == Blocks.field_150350_a || bs.func_177230_c() == Blocks.field_180408_aP);
            this.legs[3] = new Leg(world, new BlockPos(pos.func_177958_n() + xWidth / 2 - 1, pos.func_177956_o() - 1, pos.func_177952_p() + zWidth / 2 - 1), bs -> bs.func_177230_c() == Blocks.field_150355_j || bs.func_177230_c() == Blocks.field_150350_a || bs.func_177230_c() == Blocks.field_180408_aP);
            for (i = 0; i < 4; ++i) {
                BlockPos originPos = this.legs[i].supportPos.func_177981_b(2);
                for (int j = 0; j < 3; ++j) {
                    PieceUtil.setWLBlock(world, originPos.func_177981_b(j), Blocks.field_180408_aP.func_176223_P());
                }
                PieceUtil.placeUpdateFence(world, flatFrame1.corners.getKey()[i], Blocks.field_209390_ac.func_176223_P());
                this.legs[i].getPillarStream().forEach(bp -> {
                    float f0 = random.nextFloat();
                    if ((double)f0 < 0.6) {
                        PieceUtil.placeUpdateFence(world, bp, Blocks.field_203205_S.func_176223_P());
                    } else if ((double)f0 < 0.7) {
                        PieceUtil.placeUpdateFence(world, bp, Blocks.field_203209_W.func_176223_P());
                    } else {
                        PieceUtil.placeUpdateFence(world, bp, Blocks.field_196617_K.func_176223_P());
                    }
                });
            }
            BlockPos chestPos = PieceUtil.randomlyPlaceBlockAT(world, random, pos.func_177984_a(), -xWidth / 2 + 2, 0, -zWidth / 2 + 2, xWidth / 2 - 2, 0, zWidth / 2 - 2, ((Block)DannyBlocks.SEA_CHEST.get()).func_176223_P().rotate((IWorld)world, this.platformCenterPos.func_177984_a(), Rotation.func_222466_a((Random)random)));
            TileEntity tileentity = world.func_175625_s(chestPos);
            if (tileentity instanceof ChestTileEntity) {
                ((ChestTileEntity)tileentity).func_189404_a(new ResourceLocation("dannys_expansion", "chests/anglers_treasure"), random.nextLong());
            }
            for (int i2 = 0; i2 < flatFrame1.blocks.getKey().length; ++i2) {
                BlockPos bp3 = flatFrame1.blocks.getKey()[i2];
                Direction dir0 = flatFrame1.blocks.getValue()[i2];
                if (bp3 == null || dir0 == null || world.func_180495_p(bp3).func_177230_c() == Blocks.field_150355_j && world.func_180495_p(bp3).func_200132_m()) continue;
                Direction dir1 = dir0.func_176746_e();
                PieceUtil.setWLBlock(world, bp3, (BlockState)((BlockState)Blocks.field_180408_aP.func_176223_P().func_206870_a((Property)SixWayBlock.field_196491_B.getOrDefault(dir1, SixWayBlock.field_196488_a), (Comparable)Boolean.valueOf(true))).func_206870_a((Property)SixWayBlock.field_196491_B.getOrDefault(dir1.func_176734_d(), SixWayBlock.field_196488_a), (Comparable)Boolean.valueOf(true)));
            }
        }
    }

    class PlatformPiece {
        public BlockPos platformCenterPos;
        public Leg[] legs = new Leg[4];

        public PlatformPiece(BlockPos pos) {
            this.platformCenterPos = pos;
        }

        public PlatformPiece(ISeedReader world, Random random, BlockPos pos, int xWidth, int zWidth) {
            int i;
            this.platformCenterPos = pos;
            PieceUtil.PositionStack posStack0 = PieceUtil.fillRegion(world, pos, -xWidth / 2, 0, -zWidth / 2, xWidth / 2, 0, zWidth / 2, Blocks.field_196664_o.func_176223_P());
            PieceUtil.PositionStack posStack1 = posStack0.expand(-2, 0, -2).move(0, 1, 0);
            List<BlockPos> randomBorderBlocks0 = posStack0.randomPickedBlocks(random, MathHelper.func_76136_a((Random)random, (int)12, (int)16));
            List<BlockPos> randomBorderBlocks1 = posStack1.randomPickedBlocks(random, MathHelper.func_76136_a((Random)random, (int)2, (int)4));
            PieceUtil.FlatFrame flatFrame0 = new PieceUtil.FlatFrame(pos.func_177958_n() - xWidth / 2 + 1, pos.func_177952_p() - zWidth / 2 + 1, pos.func_177958_n() + xWidth / 2 - 1, pos.func_177952_p() + zWidth / 2 - 1, pos.func_177956_o() - 1);
            PieceUtil.FlatFrame flatFrame1 = new PieceUtil.FlatFrame(pos.func_177958_n() - xWidth / 2, pos.func_177952_p() - zWidth / 2, pos.func_177958_n() + xWidth / 2, pos.func_177952_p() + zWidth / 2, pos.func_177956_o() + 1);
            this.legs[0] = new Leg(world, new BlockPos(pos.func_177958_n() - xWidth / 2 + 1, pos.func_177956_o() - 1, pos.func_177952_p() - zWidth / 2 + 1), bs -> bs.func_177230_c() == Blocks.field_150355_j || bs.func_177230_c() == Blocks.field_150350_a);
            this.legs[1] = new Leg(world, new BlockPos(pos.func_177958_n() - xWidth / 2 + 1, pos.func_177956_o() - 1, pos.func_177952_p() + zWidth / 2 - 1), bs -> bs.func_177230_c() == Blocks.field_150355_j || bs.func_177230_c() == Blocks.field_150350_a);
            this.legs[2] = new Leg(world, new BlockPos(pos.func_177958_n() + xWidth / 2 - 1, pos.func_177956_o() - 1, pos.func_177952_p() - zWidth / 2 + 1), bs -> bs.func_177230_c() == Blocks.field_150355_j || bs.func_177230_c() == Blocks.field_150350_a);
            this.legs[3] = new Leg(world, new BlockPos(pos.func_177958_n() + xWidth / 2 - 1, pos.func_177956_o() - 1, pos.func_177952_p() + zWidth / 2 - 1), bs -> bs.func_177230_c() == Blocks.field_150355_j || bs.func_177230_c() == Blocks.field_150350_a);
            for (i = 0; i < 4; ++i) {
                PieceUtil.cornerFencesAT(world, random, flatFrame0, i, MathHelper.func_76136_a((Random)random, (int)2, (int)3));
                this.legs[i].getPillarStream().forEach(bp -> {
                    float f0 = random.nextFloat();
                    if ((double)f0 < 0.3) {
                        PieceUtil.placeUpdateFence(world, bp, Blocks.field_203205_S.func_176223_P());
                    } else if ((double)f0 < 0.65) {
                        PieceUtil.placeUpdateFence(world, bp, Blocks.field_203209_W.func_176223_P());
                    } else {
                        PieceUtil.placeUpdateFence(world, bp, Blocks.field_196617_K.func_176223_P());
                    }
                });
            }
            for (i = 0; i < flatFrame0.blocks.getKey().length; ++i) {
                BlockPos bp2 = flatFrame0.blocks.getKey()[i];
                Direction dir0 = flatFrame0.blocks.getValue()[i];
                if (bp2 == null || dir0 == null || world.func_180495_p(bp2).func_177230_c() == Blocks.field_150355_j && world.func_180495_p(bp2).func_200132_m()) continue;
                Direction dir1 = dir0.func_176746_e();
                PieceUtil.setWLBlock(world, bp2, (BlockState)((BlockState)Blocks.field_180408_aP.func_176223_P().func_206870_a((Property)SixWayBlock.field_196491_B.getOrDefault(dir1, SixWayBlock.field_196488_a), (Comparable)Boolean.valueOf(true))).func_206870_a((Property)SixWayBlock.field_196491_B.getOrDefault(dir1.func_176734_d(), SixWayBlock.field_196488_a), (Comparable)Boolean.valueOf(true)));
                PieceUtil.setWLBlock(world, bp2.func_177979_c(2), (BlockState)((BlockState)Blocks.field_180408_aP.func_176223_P().func_206870_a((Property)SixWayBlock.field_196491_B.getOrDefault(dir1, SixWayBlock.field_196488_a), (Comparable)Boolean.valueOf(true))).func_206870_a((Property)SixWayBlock.field_196491_B.getOrDefault(dir1.func_176734_d(), SixWayBlock.field_196488_a), (Comparable)Boolean.valueOf(true)));
            }
            PieceUtil.placeFencesInFrameDesintegratedAT(world, random, flatFrame1, Blocks.field_180407_aO.func_176223_P(), Blocks.field_209389_ab.func_176223_P(), 0.6f);
            PieceUtil.decorateBPs(new ATSlabStripesDecorator(world, random, Blocks.field_196624_br.func_176223_P(), Blocks.field_196664_o), randomBorderBlocks0);
            PieceUtil.decorateBPs(new ATGroundCoralDecorator(world, random), randomBorderBlocks1);
        }
    }
}

