/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.common.World.structures.desert_dungeon;

import com.bottomtextdanny.dannys_expansion.core.Registries.DannyStructures;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class DesertDungeonPieces {
    static ChunkGenerator chunkGenerator;
    static Biome biome;

    public static void getInfo(ChunkGenerator chunkGenerator, Biome biome) {
        DesertDungeonPieces.chunkGenerator = chunkGenerator;
        DesertDungeonPieces.biome = biome;
    }

    public static void addStructure(TemplateManager tempManager, BlockPos structurePos, Rotation rotation, List<StructurePiece> pieces) {
        BlockPos offset = new BlockPos(0, 0, 0);
        offset = offset.func_177982_a(0, -21, -3);
        pieces.add((StructurePiece)new Piece(tempManager, "entrance", structurePos, rotation, DesertDungeonPieces.posRotator(rotation, offset)));
        offset = offset.func_177982_a(23, 1, -12);
        pieces.add((StructurePiece)new Piece(tempManager, "principal_hall", structurePos, rotation, DesertDungeonPieces.posRotator(rotation, offset)));
        int cap = MathHelper.func_76136_a((Random)new Random(), (int)5, (int)7);
        DesertDungeonPieces.generateControlledCorridor(tempManager, structurePos, rotation, pieces, offset.func_177982_a(20, 0, 10), Rotation.NONE, Rotation.NONE, cap, MathHelper.func_76136_a((Random)new Random(), (int)1, (int)1));
        cap = MathHelper.func_76136_a((Random)new Random(), (int)7, (int)10);
        DesertDungeonPieces.generateCorridor(tempManager, structurePos, rotation, pieces, offset.func_177982_a(10, 0, 0), Rotation.COUNTERCLOCKWISE_90, Rotation.COUNTERCLOCKWISE_90, cap);
        cap = MathHelper.func_76136_a((Random)new Random(), (int)7, (int)10);
        DesertDungeonPieces.generateCorridor(tempManager, structurePos, rotation, pieces, offset.func_177982_a(10, 0, 30), Rotation.CLOCKWISE_90, Rotation.CLOCKWISE_90, cap);
    }

    public static void generateControlledCorridor(TemplateManager tempManager, BlockPos structurePos, Rotation rotation, List<StructurePiece> pieces, BlockPos defaultOffset, Rotation sourceRotation, Rotation segmentRotation, int cap, int tileCount) {
        --cap;
        BlockPos offset = defaultOffset;
        offset = offset.func_177971_a((Vector3i)DesertDungeonPieces.rotateFromMiddleFront(segmentRotation, 0, 0, 0, tempManager, "corridor"));
        for (int i = 0; i < tileCount; ++i) {
            pieces.add((StructurePiece)new Piece(tempManager, "corridor", structurePos, rotation.func_185830_a(segmentRotation), DesertDungeonPieces.posRotator(rotation, offset)));
            offset = offset.func_177971_a((Vector3i)DesertDungeonPieces.posRotator(segmentRotation, 1, 0, 1));
            pieces.add((StructurePiece)new Piece(tempManager, "corridor_floor_" + new Random().nextInt(3), structurePos, rotation.func_185830_a(segmentRotation), DesertDungeonPieces.posRotator(rotation, offset)));
            offset = offset.func_177971_a((Vector3i)DesertDungeonPieces.posRotator(segmentRotation, 4, 0, -1));
        }
        if (cap > 0) {
            float genRandom = new Random().nextFloat();
            if ((double)genRandom <= 0.6) {
                DesertDungeonPieces.generateConnector(tempManager, structurePos, rotation, pieces, offset, sourceRotation, segmentRotation, cap);
            } else if ((double)genRandom <= 0.8 && chunkGenerator.func_230356_f_() - 25 > structurePos.func_177971_a((Vector3i)offset).func_177956_o()) {
                DesertDungeonPieces.generatePrison(tempManager, structurePos, rotation, pieces, offset, sourceRotation, segmentRotation, cap);
            } else if (structurePos.func_177971_a((Vector3i)offset).func_177956_o() > 10) {
                DesertDungeonPieces.generateCorridorDown(tempManager, structurePos, rotation, pieces, offset, sourceRotation, segmentRotation, cap);
            } else {
                DesertDungeonPieces.generateConnector(tempManager, structurePos, rotation, pieces, offset, sourceRotation, segmentRotation, cap);
            }
        }
    }

    public static void generateCorridor(TemplateManager tempManager, BlockPos structurePos, Rotation rotation, List<StructurePiece> pieces, BlockPos defaultOffset, Rotation sourceRotation, Rotation segmentRotation, int cap) {
        --cap;
        BlockPos offset = defaultOffset;
        int rand = MathHelper.func_76136_a((Random)new Random(), (int)1, (int)2);
        offset = offset.func_177971_a((Vector3i)DesertDungeonPieces.rotateFromMiddleFront(segmentRotation, 0, 0, 0, tempManager, "corridor"));
        for (int i = 0; i < rand; ++i) {
            pieces.add((StructurePiece)new Piece(tempManager, "corridor", structurePos, rotation.func_185830_a(segmentRotation), DesertDungeonPieces.posRotator(rotation, offset)));
            offset = offset.func_177971_a((Vector3i)DesertDungeonPieces.posRotator(segmentRotation, 0, 0, 1));
            pieces.add((StructurePiece)new Piece(tempManager, "corridor_floor_" + new Random().nextInt(3), structurePos, rotation.func_185830_a(segmentRotation), DesertDungeonPieces.posRotator(rotation, offset)));
            offset = offset.func_177971_a((Vector3i)DesertDungeonPieces.posRotator(segmentRotation, 4, 0, -1));
        }
        if (cap > 0) {
            float genRandom = new Random().nextFloat();
            if ((double)genRandom <= 0.1) {
                DesertDungeonPieces.generateConnector(tempManager, structurePos, rotation, pieces, offset, sourceRotation, segmentRotation, cap);
            } else if ((double)genRandom <= 0.2 && structurePos.func_177971_a((Vector3i)offset).func_177956_o() > 20) {
                DesertDungeonPieces.generateSuspendedPlate(tempManager, structurePos, rotation, pieces, offset, sourceRotation, segmentRotation, cap);
            } else if ((double)genRandom <= 0.3 && chunkGenerator.func_230356_f_() - 25 > structurePos.func_177971_a((Vector3i)offset).func_177956_o()) {
                DesertDungeonPieces.generatePrison(tempManager, structurePos, rotation, pieces, offset, sourceRotation, segmentRotation, cap);
            } else if ((double)genRandom <= 0.4) {
                DesertDungeonPieces.generateBlacksmith(tempManager, structurePos, rotation, pieces, offset, sourceRotation, segmentRotation, cap);
            } else if ((double)genRandom <= 0.5) {
                DesertDungeonPieces.generateLibrary(tempManager, structurePos, rotation, pieces, offset, sourceRotation, segmentRotation, cap);
            } else if ((double)genRandom <= 0.6) {
                DesertDungeonPieces.generateEnchantingRoom(tempManager, structurePos, rotation, pieces, offset, sourceRotation, segmentRotation, cap);
            } else if ((double)genRandom <= 0.7) {
                DesertDungeonPieces.generateStorageRoom(tempManager, structurePos, rotation, pieces, offset, sourceRotation, segmentRotation, cap);
            } else if ((double)genRandom <= 0.8) {
                DesertDungeonPieces.generateDiningRoom(tempManager, structurePos, rotation, pieces, offset, sourceRotation, segmentRotation, cap);
            } else if (structurePos.func_177971_a((Vector3i)offset).func_177956_o() > 10) {
                DesertDungeonPieces.generateCorridorDown(tempManager, structurePos, rotation, pieces, offset, sourceRotation, segmentRotation, cap);
            } else {
                DesertDungeonPieces.generateConnector(tempManager, structurePos, rotation, pieces, offset, sourceRotation, segmentRotation, cap);
            }
        }
    }

    public static void generateConnector(TemplateManager tempManager, BlockPos structurePos, Rotation rotation, List<StructurePiece> pieces, BlockPos defaultOffset, Rotation sourceRotation, Rotation segmentRotation, int cap) {
        BlockPos offset = defaultOffset;
        offset = offset.func_177971_a((Vector3i)DesertDungeonPieces.rotateFromMiddleFront(segmentRotation, 0, 0, 0, tempManager, "connector")).func_177971_a((Vector3i)DesertDungeonPieces.posRotator(segmentRotation, 0, 0, 3));
        pieces.add((StructurePiece)new Piece(tempManager, "connector", structurePos, rotation.func_185830_a(segmentRotation), DesertDungeonPieces.posRotator(rotation, offset)));
        offset = offset.func_177971_a((Vector3i)DesertDungeonPieces.posRotator(segmentRotation, 5, 0, 5));
        segmentRotation = DesertDungeonPieces.changeSegmentRotation(segmentRotation, sourceRotation);
        offset = offset.func_177971_a((Vector3i)DesertDungeonPieces.rotateFromMiddleFront(segmentRotation, 0, 0, 0, tempManager, "corridor")).func_177971_a((Vector3i)DesertDungeonPieces.posRotator(segmentRotation, 5, 0, 3));
        DesertDungeonPieces.generateCorridor(tempManager, structurePos, rotation, pieces, offset, sourceRotation, segmentRotation, cap);
    }

    public static void generateCorridorDown(TemplateManager tempManager, BlockPos structurePos, Rotation rotation, List<StructurePiece> pieces, BlockPos defaultOffset, Rotation sourceRotation, Rotation segmentRotation, int cap) {
        BlockPos offset = defaultOffset;
        offset = offset.func_177971_a((Vector3i)DesertDungeonPieces.rotateFromMiddleFront(segmentRotation, 0, 0, 0, tempManager, "corridor_down")).func_177971_a((Vector3i)DesertDungeonPieces.posRotator(segmentRotation, 0, -7, 3));
        pieces.add((StructurePiece)new Piece(tempManager, "corridor_down", structurePos, rotation.func_185830_a(segmentRotation), DesertDungeonPieces.posRotator(rotation, offset)));
        offset = offset.func_177971_a((Vector3i)DesertDungeonPieces.posRotator(segmentRotation, 8, 0, 3));
        DesertDungeonPieces.generateCorridor(tempManager, structurePos, rotation, pieces, offset, sourceRotation, segmentRotation, cap);
    }

    public static void generatePrison(TemplateManager tempManager, BlockPos structurePos, Rotation rotation, List<StructurePiece> pieces, BlockPos defaultOffset, Rotation sourceRotation, Rotation segmentRotation, int cap) {
        BlockPos offset = defaultOffset;
        offset = offset.func_177971_a((Vector3i)DesertDungeonPieces.rotateFromMiddleFront(segmentRotation, 0, 0, 0, tempManager, "prison")).func_177971_a((Vector3i)DesertDungeonPieces.posRotator(segmentRotation, 0, 0, 3));
        pieces.add((StructurePiece)new Piece(tempManager, "prison", structurePos, rotation.func_185830_a(segmentRotation), DesertDungeonPieces.posRotator(rotation, offset)));
        offset = offset.func_177971_a((Vector3i)DesertDungeonPieces.posRotator(segmentRotation, 7, 0, 0));
        for (int i = 1; i <= 7; ++i) {
            BlockPos ceilOffset = offset.func_177971_a((Vector3i)DesertDungeonPieces.posRotator(segmentRotation, 0, 0, 12));
            Rotation ceilRotation = segmentRotation;
            if (i == 1 || i == 4) {
                ceilRotation = ceilRotation.func_185830_a(Rotation.CLOCKWISE_90);
            } else if (i == 2 || i == 5) {
                ceilRotation = ceilRotation.func_185830_a(Rotation.COUNTERCLOCKWISE_90);
            } else if (i == 3 || i == 6) {
                ceilRotation = ceilRotation.func_185830_a(Rotation.CLOCKWISE_180);
            }
            if (i > 3) {
                ceilOffset = ceilOffset.func_177982_a(0, 6, 0);
            }
            ceilOffset = ceilOffset.func_177971_a((Vector3i)DesertDungeonPieces.posRotator(ceilRotation, 7, 5, -6));
            pieces.add((StructurePiece)new Piece(tempManager, "ceils", structurePos, rotation.func_185830_a(ceilRotation), DesertDungeonPieces.posRotator(rotation, ceilOffset)));
        }
        offset = offset.func_177971_a((Vector3i)DesertDungeonPieces.posRotator(segmentRotation, 7, 5, 12));
        DesertDungeonPieces.generateCorridor(tempManager, structurePos, rotation, pieces, offset, sourceRotation, segmentRotation, cap);
    }

    public static void generateBlacksmith(TemplateManager tempManager, BlockPos structurePos, Rotation rotation, List<StructurePiece> pieces, BlockPos defaultOffset, Rotation sourceRotation, Rotation segmentRotation, int cap) {
        BlockPos offset = defaultOffset;
        offset = offset.func_177971_a((Vector3i)DesertDungeonPieces.rotateFromMiddleFront(segmentRotation, 0, 0, 0, tempManager, "blacksmith")).func_177971_a((Vector3i)DesertDungeonPieces.posRotator(segmentRotation, 0, 0, 3));
        pieces.add((StructurePiece)new Piece(tempManager, "blacksmith", structurePos, rotation.func_185830_a(segmentRotation), DesertDungeonPieces.posRotator(rotation, offset)));
        offset = offset.func_177971_a((Vector3i)DesertDungeonPieces.posRotator(segmentRotation, 9, 0, 8));
        if (new Random().nextInt(4) < 3 && segmentRotation.func_185830_a(Rotation.CLOCKWISE_90) != sourceRotation.func_185830_a(Rotation.CLOCKWISE_180)) {
            segmentRotation = segmentRotation.func_185830_a(Rotation.CLOCKWISE_90);
        }
        offset = offset.func_177971_a((Vector3i)DesertDungeonPieces.rotateFromMiddleFront(segmentRotation, 0, 0, 0, tempManager, "corridor")).func_177971_a((Vector3i)DesertDungeonPieces.posRotator(segmentRotation, 4, 0, 3));
        DesertDungeonPieces.generateCorridor(tempManager, structurePos, rotation, pieces, offset, sourceRotation, segmentRotation, cap);
    }

    public static void generateLibrary(TemplateManager tempManager, BlockPos structurePos, Rotation rotation, List<StructurePiece> pieces, BlockPos defaultOffset, Rotation sourceRotation, Rotation segmentRotation, int cap) {
        BlockPos offset = defaultOffset;
        offset = offset.func_177971_a((Vector3i)DesertDungeonPieces.rotateFromMiddleFront(segmentRotation, 0, 0, 0, tempManager, "library")).func_177971_a((Vector3i)DesertDungeonPieces.posRotator(segmentRotation, 0, 0, 3));
        pieces.add((StructurePiece)new Piece(tempManager, "library", structurePos, rotation.func_185830_a(segmentRotation), DesertDungeonPieces.posRotator(rotation, offset)));
        offset = offset.func_177971_a((Vector3i)DesertDungeonPieces.posRotator(segmentRotation, 7, 0, 7));
        int i = new Random().nextInt(2);
        if (i == 0) {
            segmentRotation = segmentRotation.func_185830_a(Rotation.CLOCKWISE_90) != sourceRotation.func_185830_a(Rotation.CLOCKWISE_180) ? segmentRotation.func_185830_a(Rotation.CLOCKWISE_90) : segmentRotation.func_185830_a(Rotation.COUNTERCLOCKWISE_90);
        }
        offset = offset.func_177971_a((Vector3i)DesertDungeonPieces.rotateFromMiddleFront(segmentRotation, 0, 0, 0, tempManager, "corridor")).func_177971_a((Vector3i)DesertDungeonPieces.posRotator(segmentRotation, 7, 0, 3));
        DesertDungeonPieces.generateCorridor(tempManager, structurePos, rotation, pieces, offset, sourceRotation, segmentRotation, cap);
    }

    public static void generateDiningRoom(TemplateManager tempManager, BlockPos structurePos, Rotation rotation, List<StructurePiece> pieces, BlockPos defaultOffset, Rotation sourceRotation, Rotation segmentRotation, int cap) {
        BlockPos offset = defaultOffset;
        offset = offset.func_177971_a((Vector3i)DesertDungeonPieces.rotateFromMiddleFront(segmentRotation, 0, 0, 0, tempManager, "dining_room")).func_177971_a((Vector3i)DesertDungeonPieces.posRotator(segmentRotation, 0, 0, 3));
        pieces.add((StructurePiece)new Piece(tempManager, "dining_room", structurePos, rotation.func_185830_a(segmentRotation), DesertDungeonPieces.posRotator(rotation, offset)));
        offset = offset.func_177971_a((Vector3i)DesertDungeonPieces.posRotator(segmentRotation, 7, 0, 7));
        segmentRotation = DesertDungeonPieces.changeSegmentRotation(segmentRotation, sourceRotation);
        offset = offset.func_177971_a((Vector3i)DesertDungeonPieces.rotateFromMiddleFront(segmentRotation, 0, 0, 0, tempManager, "corridor")).func_177971_a((Vector3i)DesertDungeonPieces.posRotator(segmentRotation, 7, 0, 3));
        DesertDungeonPieces.generateCorridor(tempManager, structurePos, rotation, pieces, offset, sourceRotation, segmentRotation, cap);
    }

    public static void generateEnchantingRoom(TemplateManager tempManager, BlockPos structurePos, Rotation rotation, List<StructurePiece> pieces, BlockPos defaultOffset, Rotation sourceRotation, Rotation segmentRotation, int cap) {
        BlockPos offset = defaultOffset;
        offset = offset.func_177971_a((Vector3i)DesertDungeonPieces.rotateFromMiddleFront(segmentRotation, 0, 0, 0, tempManager, "enchanting_room")).func_177971_a((Vector3i)DesertDungeonPieces.posRotator(segmentRotation, 0, 0, 3));
        pieces.add((StructurePiece)new Piece(tempManager, "enchanting_room", structurePos, rotation.func_185830_a(segmentRotation), DesertDungeonPieces.posRotator(rotation, offset)));
        offset = offset.func_177971_a((Vector3i)DesertDungeonPieces.posRotator(segmentRotation, 8, 2, 7));
        int rand = new Random().nextInt(2);
        if (rand == 0) {
            segmentRotation = segmentRotation.func_185830_a(Rotation.CLOCKWISE_90) != sourceRotation.func_185830_a(Rotation.CLOCKWISE_180) ? segmentRotation.func_185830_a(Rotation.CLOCKWISE_90) : segmentRotation.func_185830_a(Rotation.COUNTERCLOCKWISE_90);
        }
        offset = offset.func_177971_a((Vector3i)DesertDungeonPieces.rotateFromMiddleFront(segmentRotation, 0, 0, 0, tempManager, "corridor")).func_177971_a((Vector3i)DesertDungeonPieces.posRotator(segmentRotation, 7, 0, 3));
        DesertDungeonPieces.generateCorridor(tempManager, structurePos, rotation, pieces, offset, sourceRotation, segmentRotation, cap);
    }

    public static void generateStorageRoom(TemplateManager tempManager, BlockPos structurePos, Rotation rotation, List<StructurePiece> pieces, BlockPos defaultOffset, Rotation sourceRotation, Rotation segmentRotation, int cap) {
        BlockPos offset = defaultOffset;
        offset = offset.func_177971_a((Vector3i)DesertDungeonPieces.rotateFromMiddleFront(segmentRotation, 0, 0, 0, tempManager, "storage_room")).func_177971_a((Vector3i)DesertDungeonPieces.posRotator(segmentRotation, 0, 0, 3));
        pieces.add((StructurePiece)new Piece(tempManager, "storage_room", structurePos, rotation.func_185830_a(segmentRotation), DesertDungeonPieces.posRotator(rotation, offset)));
        offset = offset.func_177971_a((Vector3i)DesertDungeonPieces.posRotator(segmentRotation, 7, 0, 7));
        segmentRotation = DesertDungeonPieces.changeSegmentRotation(segmentRotation, sourceRotation);
        offset = offset.func_177971_a((Vector3i)DesertDungeonPieces.rotateFromMiddleFront(segmentRotation, 0, 0, 0, tempManager, "corridor")).func_177971_a((Vector3i)DesertDungeonPieces.posRotator(segmentRotation, 7, 0, 3));
        DesertDungeonPieces.generateCorridor(tempManager, structurePos, rotation, pieces, offset, sourceRotation, segmentRotation, cap);
    }

    public static void generateSuspendedPlate(TemplateManager tempManager, BlockPos structurePos, Rotation rotation, List<StructurePiece> pieces, BlockPos defaultOffset, Rotation sourceRotation, Rotation segmentRotation, int cap) {
        BlockPos offset = defaultOffset;
        offset = offset.func_177971_a((Vector3i)DesertDungeonPieces.rotateFromMiddleFront(segmentRotation, 0, 0, 0, tempManager, "suspended_plate")).func_177971_a((Vector3i)DesertDungeonPieces.posRotator(segmentRotation, 0, -13, 3));
        pieces.add((StructurePiece)new Piece(tempManager, "suspended_plate", structurePos, rotation.func_185830_a(segmentRotation), DesertDungeonPieces.posRotator(rotation, offset)));
        offset = offset.func_177971_a((Vector3i)DesertDungeonPieces.posRotator(segmentRotation, 5, 0, 5));
        int rand1 = new Random().nextInt(3);
        segmentRotation = DesertDungeonPieces.changeSegmentRotation(segmentRotation, sourceRotation);
        offset = offset.func_177971_a((Vector3i)DesertDungeonPieces.rotateFromMiddleFront(segmentRotation, 0, 0, 0, tempManager, "corridor")).func_177971_a((Vector3i)DesertDungeonPieces.posRotator(segmentRotation, 5, rand1 * 6 + 1, 3));
        DesertDungeonPieces.generateCorridor(tempManager, structurePos, rotation, pieces, offset, sourceRotation, segmentRotation, cap);
    }

    public static Rotation changeSegmentRotation(Rotation rot, Rotation rot1) {
        int i = new Random().nextInt(3);
        if (i < 2) {
            if (i == 0) {
                if (rot.func_185830_a(Rotation.CLOCKWISE_90) != rot1.func_185830_a(Rotation.CLOCKWISE_180)) {
                    return rot.func_185830_a(Rotation.CLOCKWISE_90);
                }
                return rot.func_185830_a(Rotation.COUNTERCLOCKWISE_90);
            }
            if (rot.func_185830_a(Rotation.COUNTERCLOCKWISE_90) != rot1.func_185830_a(Rotation.CLOCKWISE_180)) {
                return rot.func_185830_a(Rotation.COUNTERCLOCKWISE_90);
            }
            return rot.func_185830_a(Rotation.CLOCKWISE_90);
        }
        return rot;
    }

    public static BlockPos posRotator(Rotation rot, BlockPos pos) {
        switch (rot) {
            case CLOCKWISE_90: {
                return new BlockPos(-pos.func_177952_p(), pos.func_177956_o(), pos.func_177958_n());
            }
            case CLOCKWISE_180: {
                return new BlockPos(-pos.func_177958_n(), pos.func_177956_o(), -pos.func_177952_p());
            }
            case COUNTERCLOCKWISE_90: {
                return new BlockPos(pos.func_177952_p(), pos.func_177956_o(), -pos.func_177958_n());
            }
        }
        return pos;
    }

    public static BlockPos posRotator(Rotation rot, int x, int y, int z) {
        switch (rot) {
            case CLOCKWISE_90: {
                return new BlockPos(-z, y, x);
            }
            case CLOCKWISE_180: {
                return new BlockPos(-x, y, -z);
            }
            case COUNTERCLOCKWISE_90: {
                return new BlockPos(z, y, -x);
            }
        }
        return new BlockPos(x, y, z);
    }

    public static BlockPos rotateFromMiddleFront(Rotation rot, int x, int y, int z, TemplateManager templateManager, String pieceName) {
        switch (rot) {
            case CLOCKWISE_90: {
                return new BlockPos(-z + templateManager.func_200219_b(new ResourceLocation("dannys_expansion", "desert_dungeon/" + pieceName)).func_186259_a().func_177952_p() / 2, y, x);
            }
            case CLOCKWISE_180: {
                return new BlockPos(-x, y, -z + templateManager.func_200219_b(new ResourceLocation("dannys_expansion", "desert_dungeon/" + pieceName)).func_186259_a().func_177952_p() / 2);
            }
            case COUNTERCLOCKWISE_90: {
                return new BlockPos(z - templateManager.func_200219_b(new ResourceLocation("dannys_expansion", "desert_dungeon/" + pieceName)).func_186259_a().func_177952_p() / 2, y, -x);
            }
        }
        return new BlockPos(x, y, z - templateManager.func_200219_b(new ResourceLocation("dannys_expansion", "desert_dungeon/" + pieceName)).func_186259_a().func_177952_p() / 2);
    }

    public static class Piece
    extends TemplateStructurePiece {
        private final String pieceName;
        private Rotation rotations;

        public Piece(TemplateManager p_i49313_1_, String name, BlockPos p_i49313_3_, Rotation p_i49313_4_, BlockPos p_i49313_5_) {
            super(DannyStructures.DESERT_DUNGEON_PIECE, 0);
            this.pieceName = name;
            this.rotations = p_i49313_4_;
            this.field_186178_c = p_i49313_3_.func_177971_a((Vector3i)p_i49313_5_);
            this.func_207614_a(p_i49313_1_);
        }

        public Piece(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(DannyStructures.DESERT_DUNGEON_PIECE, compoundNBT);
            this.pieceName = compoundNBT.func_74779_i("Template");
            this.rotations = Rotation.valueOf((String)compoundNBT.func_74779_i("Rot"));
            this.func_207614_a(templateManager);
        }

        private void func_207614_a(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(new ResourceLocation("dannys_expansion", "desert_dungeon/" + this.pieceName));
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotations).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT compoundNBT) {
            super.func_143011_b(compoundNBT);
            compoundNBT.func_74778_a("Template", this.pieceName);
            compoundNBT.func_74778_a("Rot", this.rotations.name());
        }

        public boolean func_230383_a_(ISeedReader worldIn, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random p_230383_4_, MutableBoundingBox p_230383_5_, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
            BlockPos blockpos2 = this.field_186178_c;
            this.field_186178_c = new BlockPos(this.field_186178_c.func_177958_n(), this.field_186178_c.func_177956_o(), this.field_186178_c.func_177952_p());
            boolean flag = super.func_230383_a_(worldIn, p_230383_2_, p_230383_3_, p_230383_4_, p_230383_5_, p_230383_6_, p_230383_7_);
            this.field_186178_c = blockpos2;
            return flag;
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
        }
    }
}

