/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.common.World.structures.util;

import com.bottomtextdanny.dannys_expansion.common.World.structures.util.IPosMatrix;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;

public class Matrix
implements IPosMatrix {
    protected BlockPos focalPoint;
    public byte flag = 0;
    protected List<BlockPos> matrix = new ArrayList<BlockPos>();
    public boolean rotative;
    private final Random random;

    public Matrix(BlockPos position, Random rand, boolean rotative, Supplier<List<BlockPos>> sup) {
        this.focalPoint = position;
        this.rotative = rotative;
        this.matrix = sup.get();
        this.random = rand;
    }

    public Matrix(BlockPos position, Random rand, boolean rotative) {
        this.focalPoint = position;
        this.rotative = rotative;
        this.random = rand;
    }

    public Matrix(BlockPos position, Random rand) {
        this.focalPoint = position;
        this.random = rand;
    }

    public Matrix(BlockPos position, Random rand, Supplier<List<BlockPos>> sup) {
        this.focalPoint = position;
        this.matrix = sup.get();
        this.random = rand;
    }

    public Matrix rotative() {
        this.rotative = true;
        return this;
    }

    public List<BlockPos> rotateMatrix(Rotation rotation) {
        List<BlockPos> list = Arrays.asList(new BlockPos[this.matrix.size()]);
        switch (rotation) {
            case CLOCKWISE_90: {
                for (int i = 0; i < this.matrix.size(); ++i) {
                    BlockPos bpOffset = this.matrix.get(i).func_177982_a(-this.focalPoint.func_177958_n(), -this.focalPoint.func_177956_o(), -this.focalPoint.func_177952_p());
                    list.set(i, new BlockPos(this.focalPoint.func_177958_n() + bpOffset.func_177952_p(), this.focalPoint.func_177956_o() + bpOffset.func_177956_o(), this.focalPoint.func_177952_p() + -bpOffset.func_177958_n()));
                }
                break;
            }
            case COUNTERCLOCKWISE_90: {
                for (int i = 0; i < this.matrix.size(); ++i) {
                    BlockPos bpOffset = this.matrix.get(i).func_177982_a(-this.focalPoint.func_177958_n(), -this.focalPoint.func_177956_o(), -this.focalPoint.func_177952_p());
                    list.set(i, new BlockPos(this.focalPoint.func_177958_n() + -bpOffset.func_177952_p(), this.focalPoint.func_177956_o() + bpOffset.func_177956_o(), this.focalPoint.func_177952_p() + bpOffset.func_177958_n()));
                }
                break;
            }
            case CLOCKWISE_180: {
                for (int i = 0; i < this.matrix.size(); ++i) {
                    BlockPos bpOffset = this.matrix.get(i).func_177982_a(-this.focalPoint.func_177958_n(), -this.focalPoint.func_177956_o(), -this.focalPoint.func_177952_p());
                    list.set(i, new BlockPos(this.focalPoint.func_177958_n() + -bpOffset.func_177952_p(), this.focalPoint.func_177956_o() + bpOffset.func_177956_o(), this.focalPoint.func_177952_p() + -bpOffset.func_177958_n()));
                }
                break;
            }
            default: {
                return this.matrix;
            }
        }
        return list;
    }

    public void setMatrix(List<BlockPos> matrix) {
        this.matrix = matrix;
    }

    public void addPosition(BlockPos pos) {
        this.matrix.add(pos);
    }

    public boolean mayAddPosition(BlockPos pos, float probability) {
        if (this.random.nextFloat() < probability) {
            this.matrix.add(pos);
            return true;
        }
        return false;
    }

    public void addRegionWithIntegrity(BlockPos posStart, BlockPos posEnd, float integrity) {
        for (int i = 0; i <= posEnd.func_177958_n() - posStart.func_177958_n(); ++i) {
            for (int j = 0; j <= posEnd.func_177956_o() - posStart.func_177956_o(); ++j) {
                for (int k = 0; k <= posEnd.func_177952_p() - posStart.func_177952_p(); ++k) {
                    if (!(this.random.nextFloat() < integrity)) continue;
                    this.matrix.add(new BlockPos(posStart.func_177958_n() + i, posStart.func_177956_o() + j, posStart.func_177952_p() + k));
                }
            }
        }
    }

    public void addRegion(BlockPos posStart, BlockPos posEnd) {
        for (int i = 0; i <= posEnd.func_177958_n() - posStart.func_177958_n(); ++i) {
            for (int j = 0; j <= posEnd.func_177956_o() - posStart.func_177956_o(); ++j) {
                for (int k = 0; k <= posEnd.func_177952_p() - posStart.func_177952_p(); ++k) {
                    this.matrix.add(new BlockPos(posStart.func_177958_n() + i, posStart.func_177956_o() + j, posStart.func_177952_p() + k));
                }
            }
        }
    }

    public boolean mayAddRegion(BlockPos posStart, BlockPos posEnd, float probability) {
        if (this.random.nextFloat() < probability) {
            this.addRegion(posStart, posEnd);
            return true;
        }
        return false;
    }

    @Override
    public List<BlockPos> getMatrixList() {
        return this.rotative ? this.rotateMatrix(Rotation.func_222466_a((Random)this.random)) : this.matrix;
    }

    public BlockPos getFocalPoint() {
        return this.focalPoint;
    }
}

