/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.common.World.structures.util;

import com.bottomtextdanny.dannys_expansion.common.World.structures.util.Director;
import com.bottomtextdanny.dannys_expansion.common.World.structures.util.PosArrayDecorator;
import com.bottomtextdanny.dannys_expansion.common.World.structures.util.PosDecorator;
import com.bottomtextdanny.dannys_expansion.core.Util.Pair;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.SixWayBlock;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;

public class PieceUtil {
    public static boolean isSpace(ISeedReader world, BlockPos pos) {
        return !world.func_180495_p(pos).func_204520_s().func_206888_e() || world.func_180495_p(pos).func_177230_c().isAir(world.func_180495_p(pos), (IBlockReader)world, pos);
    }

    public static void setBlockOnSpace(ISeedReader world, BlockPos pos, BlockState newState) {
        if (!world.func_180495_p(pos).func_204520_s().func_206888_e() || world.func_180495_p(pos).func_177230_c().isAir(world.func_180495_p(pos), (IBlockReader)world, pos)) {
            world.func_180501_a(pos, newState, 0);
        }
    }

    public static void setWLBlock(ISeedReader world, BlockPos pos, BlockState newState) {
        if (!world.func_180495_p(pos).func_204520_s().func_206888_e()) {
            world.func_180501_a(pos, (BlockState)newState.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)), 0);
        } else if (world.func_180495_p(pos).func_177230_c().isAir(world.func_180495_p(pos), (IBlockReader)world, pos)) {
            world.func_180501_a(pos, newState, 0);
        }
    }

    public static void setWLBlockSolid(ISeedReader world, BlockPos pos, BlockState newState) {
        if (!(world.func_180495_p(pos).func_204520_s().func_206888_e() && world.func_180495_p(pos.func_177972_a(Direction.UP)).func_204520_s().func_206888_e() && world.func_180495_p(pos.func_177972_a(Direction.DOWN)).func_204520_s().func_206888_e() && world.func_180495_p(pos.func_177972_a(Direction.NORTH)).func_204520_s().func_206888_e() && world.func_180495_p(pos.func_177972_a(Direction.SOUTH)).func_204520_s().func_206888_e() && world.func_180495_p(pos.func_177972_a(Direction.EAST)).func_204520_s().func_206888_e() && world.func_180495_p(pos.func_177972_a(Direction.WEST)).func_204520_s().func_206888_e())) {
            world.func_180501_a(pos, (BlockState)newState.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)), 0);
        } else {
            world.func_180501_a(pos, newState, 0);
        }
    }

    public static void setAirOrWater(ISeedReader world, BlockPos pos) {
        if (!world.func_180495_p(pos).func_204520_s().func_206888_e()) {
            world.func_180501_a(pos, Blocks.field_150355_j.func_176223_P(), 0);
        } else if (world.func_180495_p(pos).func_177230_c().isAir(world.func_180495_p(pos), (IBlockReader)world, pos)) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 0);
        }
    }

    public static PositionStack fillRegion(ISeedReader world, BlockPos pos, int xStart, int yStart, int zStart, int xEnd, int yEnd, int zEnd, BlockState newState) {
        BlockPos blockPos = pos.func_177982_a(xStart, yStart, zStart);
        for (int i = 0; i <= xEnd - xStart; ++i) {
            for (int j = 0; j <= yEnd - yStart; ++j) {
                for (int k = 0; k <= zEnd - zStart; ++k) {
                    world.func_180501_a(blockPos.func_177982_a(i, j, k), newState, 0);
                }
            }
        }
        return new PositionStack(pos.func_177958_n() + xStart, pos.func_177956_o() + yStart, pos.func_177952_p() + zStart, pos.func_177958_n() + xEnd, pos.func_177956_o() + yEnd, pos.func_177952_p() + zEnd);
    }

    public static void fillRegion(ISeedReader world, PositionStack posStack, BlockState newState) {
        posStack.positions.forEach(bp -> {
            if (bp != null) {
                world.func_180501_a(bp, newState, 0);
            }
        });
    }

    public static void placeFencesInFrameAT(ISeedReader world, FlatFrame flatFrame, BlockState fence, BlockState corner) {
        int i;
        for (i = 0; i < flatFrame.blocks.getKey().length; ++i) {
            BlockPos iterationPos = flatFrame.blocks.getKey()[i];
            Direction iterationDirection = flatFrame.blocks.getValue()[i];
            if (iterationPos == null || iterationDirection == null || world.func_180495_p(iterationPos).func_177230_c() == Blocks.field_150355_j && world.func_180495_p(iterationPos).func_200132_m()) continue;
            PieceUtil.placeFence(world, fence, iterationPos);
        }
        for (i = 0; i < 4; ++i) {
            world.func_180501_a(flatFrame.corners.getKey()[i], corner, 0);
        }
    }

    public static void placeFence(ISeedReader world, BlockState fence, BlockPos pos) {
        PieceUtil.setWLBlock(world, pos, fence);
        for (Direction direction : Direction.values()) {
            if (direction.func_176736_b() < 0) continue;
            BlockPos offPos = pos.func_177972_a(direction);
            BlockState offState = world.func_180495_p(offPos);
            if (!(world.func_180495_p(pos).func_177230_c() instanceof FenceBlock) || !((FenceBlock)fence.func_177230_c()).func_220111_a(offState, fence.func_224755_d((IBlockReader)world, offPos, direction), direction)) continue;
            world.func_180501_a(pos, (BlockState)world.func_180495_p(pos).func_206870_a((Property)SixWayBlock.field_196491_B.getOrDefault(direction, SixWayBlock.field_196488_a), (Comparable)Boolean.valueOf(true)), 0);
            if (!(offState.func_177230_c() instanceof FenceBlock)) continue;
            world.func_180501_a(offPos, (BlockState)world.func_180495_p(offPos).func_206870_a((Property)SixWayBlock.field_196491_B.getOrDefault(direction.func_176734_d(), SixWayBlock.field_196488_a), (Comparable)Boolean.valueOf(true)), 0);
        }
    }

    public static void placeUpdateFence(ISeedReader world, BlockPos pos, BlockState fence) {
        world.func_180501_a(pos, fence, 0);
        for (Direction direction : Direction.values()) {
            if (direction.func_176736_b() < 0) continue;
            BlockPos offPos = pos.func_177972_a(direction);
            BlockState offState = world.func_180495_p(offPos);
            if (!fence.func_200132_m() || !(offState.func_177230_c() instanceof FenceBlock)) continue;
            world.func_180501_a(offPos, (BlockState)world.func_180495_p(offPos).func_206870_a((Property)SixWayBlock.field_196491_B.getOrDefault(direction.func_176734_d(), SixWayBlock.field_196488_a), (Comparable)Boolean.valueOf(true)), 0);
        }
    }

    public static void delete1AxisFenceAT(ISeedReader world, BlockPos pos, Direction middleDirection, Block fence) {
        Direction dirY = middleDirection.func_176746_e();
        Direction dirYCCW = middleDirection.func_176735_f();
        BlockState stateYOff = world.func_180495_p(pos.func_177972_a(dirY));
        BlockState stateYCCWOff = world.func_180495_p(pos.func_177972_a(dirYCCW));
        PieceUtil.setAirOrWater(world, pos);
        if (stateYOff.func_177230_c() == fence) {
            world.func_180501_a(pos.func_177972_a(dirY), (BlockState)stateYOff.func_206870_a((Property)PieceUtil.dirToProp(dirYCCW), (Comparable)Boolean.valueOf(false)), 0);
        }
        if (stateYCCWOff.func_177230_c() == fence) {
            world.func_180501_a(pos.func_177972_a(dirYCCW), (BlockState)stateYCCWOff.func_206870_a((Property)PieceUtil.dirToProp(dirY), (Comparable)Boolean.valueOf(false)), 0);
        }
    }

    public static void placeFencesInFrameDesintegratedAT(ISeedReader world, Random random, FlatFrame flatFrame, BlockState fence, BlockState corner, float integration) {
        int i;
        for (i = 0; i < flatFrame.blocks.getKey().length; ++i) {
            BlockPos iterationPos = flatFrame.blocks.getKey()[i];
            Direction iterationDirection = flatFrame.blocks.getValue()[i];
            if (iterationPos == null || iterationDirection == null) continue;
            PieceUtil.placeFence(world, fence, iterationPos);
        }
        for (i = 0; i < flatFrame.blocks.getKey().length; ++i) {
            BlockPos bp = flatFrame.blocks.getKey()[i];
            Direction dir0 = flatFrame.blocks.getValue()[i];
            if (bp == null || dir0 == null) continue;
            Direction dirY = dir0.func_176746_e();
            Direction dirYCCW = dir0.func_176735_f();
            if (!(random.nextFloat() > integration)) continue;
            PieceUtil.setAirOrWater(world, bp);
            BlockState stateYOff = world.func_180495_p(bp.func_177972_a(dirY));
            BlockState stateYCCWOff = world.func_180495_p(bp.func_177972_a(dirYCCW));
            if (stateYOff.func_177230_c() == fence.func_177230_c()) {
                world.func_180501_a(bp.func_177972_a(dirY), (BlockState)stateYOff.func_206870_a((Property)PieceUtil.dirToProp(dirYCCW), (Comparable)Boolean.valueOf(false)), 0);
            }
            if (stateYCCWOff.func_177230_c() != fence.func_177230_c()) continue;
            world.func_180501_a(bp.func_177972_a(dirYCCW), (BlockState)stateYCCWOff.func_206870_a((Property)PieceUtil.dirToProp(dirY), (Comparable)Boolean.valueOf(false)), 0);
        }
        for (i = 0; i < 4; ++i) {
            world.func_180501_a(flatFrame.corners.getKey()[i], corner, 0);
        }
    }

    public static BlockPos randomlyPlaceBlockAT(ISeedReader world, Random random, BlockPos pos, int xStart, int yStart, int zStart, int xEnd, int yEnd, int zEnd, BlockState newState) {
        BlockPos blockPos = new BlockPos(pos.func_177958_n() + xStart + random.nextInt(++xEnd - xStart), pos.func_177956_o() + yStart + random.nextInt(++yEnd - yStart), pos.func_177952_p() + zStart + random.nextInt(++zEnd - zStart));
        PieceUtil.setWLBlock(world, blockPos, newState);
        return blockPos;
    }

    public static void cornerFencesAT(ISeedReader world, Random random, FlatFrame frame, int corner, int range) {
        if (frame.corners.getKey()[corner] != null) {
            frame.corners.getKey()[corner] = frame.corners.getKey()[corner].func_177981_b(2);
            PieceUtil.makePillarUpAT(world, frame.corners.getKey()[corner], Blocks.field_180408_aP.func_176223_P(), range);
            frame.corners.getValue()[corner].getDirections().forEach(cornerDirection -> {
                for (int i = 1; i < 3; ++i) {
                    PieceUtil.makePillarUpUpdateNeigbourAT(world, frame.corners.getKey()[corner].func_177967_a(cornerDirection, -i), cornerDirection, Blocks.field_180408_aP.func_176223_P(), MathHelper.func_76136_a((Random)random, (int)(range / (i + 1)), (int)(range / i)));
                }
            });
        }
    }

    public static BooleanProperty dirToProp(Direction dir) {
        return (BooleanProperty)SixWayBlock.field_196491_B.get(dir);
    }

    public static void makePillarUpAT(ISeedReader world, BlockPos pos, BlockState newState, int height) {
        for (int i = 0; i <= height; ++i) {
            PieceUtil.placeFence(world, newState, pos.func_177981_b(i));
        }
    }

    public static void makePillarUpUpdateNeigbourAT(ISeedReader world, BlockPos pos, Direction nbDir, BlockState newState, int height) {
        for (int i = 0; i <= height; ++i) {
            PieceUtil.placeFence(world, newState, pos.func_177981_b(i));
        }
    }

    public static void decorateBPs(PosDecorator decorator, List<BlockPos> positions) {
        positions.forEach(bp -> {
            if (bp != null) {
                decorator.generate((BlockPos)bp);
            }
        });
    }

    public static void decorateBPA(PosArrayDecorator decorator, BlockPos ... positions) {
        decorator.generate(positions);
    }

    public static void decorateStackRandomlyBPs(PosDecorator decorator, Random random, int tries, PositionStack positions) {
        positions.randomPickedBlocks(random, tries).forEach(bp -> {
            if (bp != null) {
                decorator.generate((BlockPos)bp);
            }
        });
    }

    public static List<BlockPos> randomPickedBlocks(Random random, List<BlockPos> positions, int blockAmount) {
        List<BlockPos> randomPositions = Arrays.asList(new BlockPos[blockAmount]);
        for (int i = 0; i < blockAmount; ++i) {
            randomPositions.set(i, positions.get(random.nextInt(positions.size())));
        }
        return randomPositions;
    }

    public static Direction.Axis getOppositeAxis(Direction.Axis axis) {
        return axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
    }

    public static class PositionStack {
        public Vector3i dimensions;
        public BlockPos pivot;
        public BlockPos startPos;
        public BlockPos endPos;
        public List<BlockPos> positions;

        public PositionStack() {
        }

        public PositionStack(BlockPos pivot, int xStartOffset, int yStartOffset, int zStartOffset, int xEndOffset, int yEndOffset, int zEndOffset) {
            this.dimensions = new Vector3i(xEndOffset - xStartOffset, yEndOffset - yStartOffset, zEndOffset - zStartOffset);
            this.pivot = pivot;
            this.startPos = pivot.func_177982_a(xStartOffset, yStartOffset, zStartOffset);
            this.endPos = pivot.func_177982_a(xEndOffset, yEndOffset, zEndOffset);
            this.positions = Arrays.asList(new BlockPos[(this.endPos.func_177958_n() - this.startPos.func_177958_n() + 1) * (this.endPos.func_177956_o() - this.startPos.func_177956_o() + 1) * (this.endPos.func_177952_p() - this.startPos.func_177952_p() + 1) + 1]);
            int blockCounter = 0;
            for (int i = 0; i <= xEndOffset - xStartOffset; ++i) {
                for (int j = 0; j <= yEndOffset - yStartOffset; ++j) {
                    for (int k = 0; k <= zEndOffset - zStartOffset; ++k) {
                        this.positions.set(blockCounter, pivot.func_177982_a(i + xStartOffset, j + yStartOffset, k + zStartOffset));
                        ++blockCounter;
                    }
                }
            }
        }

        public PositionStack(int xStart, int yStart, int zStart, int xEnd, int yEnd, int zEnd) {
            this.dimensions = new Vector3i(xEnd - xStart, yEnd - yStart, zEnd - zStart);
            this.startPos = new BlockPos(xStart, yStart, zStart);
            this.endPos = new BlockPos(xEnd, yEnd, zEnd);
            this.pivot = new BlockPos((xEnd - xStart) / 2 + xStart, (yEnd - yStart) / 2 + yStart, (zEnd - zStart) / 2 + zStart);
            this.positions = Arrays.asList(new BlockPos[(this.endPos.func_177958_n() - this.startPos.func_177958_n() + 1) * (this.endPos.func_177956_o() - this.startPos.func_177956_o() + 1) * (this.endPos.func_177952_p() - this.startPos.func_177952_p() + 1) + 1]);
            int blockCounter = 0;
            for (int i = 0; i <= xEnd - xStart; ++i) {
                for (int j = 0; j <= yEnd - yStart; ++j) {
                    for (int k = 0; k <= zEnd - zStart; ++k) {
                        this.positions.set(blockCounter, this.startPos.func_177982_a(i, j, k));
                        ++blockCounter;
                    }
                }
            }
        }

        public PositionStack expand(int x, int y, int z) {
            return new PositionStack(this.startPos.func_177958_n() - x, this.startPos.func_177956_o() - y, this.startPos.func_177952_p() - z, this.endPos.func_177958_n() + x, this.endPos.func_177956_o() + y, this.endPos.func_177952_p() + z);
        }

        public PositionStack expand(int x, int yBottom, int z, int yTop) {
            return new PositionStack(this.startPos.func_177958_n() - x, this.startPos.func_177956_o() - yBottom, this.startPos.func_177952_p() - z, this.endPos.func_177958_n() + x, this.endPos.func_177956_o() + yTop, this.endPos.func_177952_p() + z);
        }

        public PositionStack move(int x, int y, int z) {
            return new PositionStack(this.startPos.func_177958_n() + x, this.startPos.func_177956_o() + y, this.startPos.func_177952_p() + z, this.endPos.func_177958_n() + x, this.endPos.func_177956_o() + y, this.endPos.func_177952_p() + z);
        }

        public PositionStack move(Vector3i vector) {
            return new PositionStack(this.startPos.func_177958_n() + vector.func_177958_n(), this.startPos.func_177956_o() + vector.func_177956_o(), this.startPos.func_177952_p() + vector.func_177952_p(), this.endPos.func_177958_n() + vector.func_177958_n(), this.endPos.func_177956_o() + vector.func_177956_o(), this.endPos.func_177952_p() + vector.func_177952_p());
        }

        public static PositionStack frameToStack(FlatFrame frame) {
            BlockPos[] bps = new BlockPos[500];
            for (int i = 0; i < frame.blocks.getKey().length; ++i) {
                if (frame.blocks.getKey()[i] == null) continue;
                bps[i] = frame.blocks.getKey()[i];
            }
            PositionStack posStack = new PositionStack(frame.startPos.func_177958_n(), frame.startPos.func_177956_o(), frame.startPos.func_177952_p(), frame.startPos.func_177958_n() + frame.dimensions.func_177958_n(), frame.startPos.func_177956_o() + frame.dimensions.func_177956_o(), frame.startPos.func_177952_p() + frame.dimensions.func_177952_p());
            posStack.positions = Arrays.asList(bps);
            return posStack;
        }

        public List<BlockPos> randomPickedBlocks(Random random, int blockAmount) {
            List<BlockPos> randomPositions = Arrays.asList(new BlockPos[blockAmount]);
            for (int i = 0; i < blockAmount; ++i) {
                randomPositions.set(i, this.positions.get(random.nextInt(this.positions.size())));
            }
            return randomPositions;
        }
    }

    public static class FlatFrame {
        public int height;
        public Vector3i dimensions;
        public BlockPos startPos;
        public Pair<BlockPos[], Director[]> corners = new Pair<BlockPos[], Director[]>(new BlockPos[4], new Director[4]);
        public Pair<BlockPos[], Direction[]> blocks = new Pair<BlockPos[], Direction[]>(new BlockPos[100], new Direction[100]);

        public FlatFrame(int xStart, int zStart, int xEnd, int zEnd, int yPos) {
            int xPos;
            int i;
            this.height = yPos;
            this.dimensions = new Vector3i(xEnd - xStart, 0, zEnd - zStart);
            this.startPos = new BlockPos(xStart, this.height, zStart);
            int blocksIndex = 0;
            for (i = 0; i <= xEnd - xStart; ++i) {
                xPos = xStart + i;
                if (i == 0) {
                    this.corners.getKey()[0] = new BlockPos(xPos, this.height, zStart);
                    this.corners.getValue()[0] = new Director(Direction.NORTH, Direction.WEST);
                } else if (i == xEnd - xStart) {
                    this.corners.getKey()[1] = new BlockPos(xPos, this.height, zStart);
                    this.corners.getValue()[1] = new Director(Direction.NORTH, Direction.EAST);
                } else {
                    this.blocks.getValue()[blocksIndex] = Direction.NORTH;
                }
                this.blocks.getKey()[blocksIndex] = new BlockPos(xPos, this.height, zStart);
                ++blocksIndex;
            }
            for (i = 0; i <= zEnd - zStart; ++i) {
                int zPos = zStart + i;
                this.blocks.getKey()[blocksIndex] = new BlockPos(xStart, this.height, zPos);
                this.blocks.getValue()[blocksIndex] = Direction.WEST;
                this.blocks.getKey()[++blocksIndex] = new BlockPos(xEnd, this.height, zPos);
                this.blocks.getValue()[blocksIndex] = Direction.EAST;
                ++blocksIndex;
            }
            for (i = 0; i <= xEnd - xStart; ++i) {
                xPos = xStart + i;
                if (i == 0) {
                    this.corners.getKey()[2] = new BlockPos(xPos, this.height, zEnd);
                    this.corners.getValue()[2] = new Director(Direction.SOUTH, Direction.WEST);
                } else if (i == xEnd - xStart) {
                    this.corners.getKey()[3] = new BlockPos(xPos, this.height, zEnd);
                    this.corners.getValue()[3] = new Director(Direction.SOUTH, Direction.EAST);
                } else {
                    this.blocks.getValue()[blocksIndex] = Direction.SOUTH;
                }
                this.blocks.getKey()[blocksIndex] = new BlockPos(xPos, this.height, zEnd);
                ++blocksIndex;
            }
        }
    }

    public static class RoomWall
    extends PositionStack {
        protected Direction.Axis axis;
        protected Direction outerDirection;
        public List<BlockPos> horizontalIndex;

        public RoomWall(BlockPos pivot, Direction outerDirection, int startOffset, int endOffset, int height) {
            int yStart = pivot.func_177956_o();
            int yEnd = pivot.func_177956_o() + height;
            int blockCounter = 0;
            int hiCounter = 0;
            this.axis = outerDirection.func_176746_e().func_176740_k();
            this.outerDirection = outerDirection;
            if (this.axis == Direction.Axis.X) {
                int xStart = pivot.func_177958_n() + startOffset;
                int xEnd = pivot.func_177958_n() + endOffset;
                int zStart = pivot.func_177952_p();
                int zEnd = pivot.func_177952_p();
                this.dimensions = new Vector3i(xEnd - xStart, yEnd - yStart, zEnd - zStart);
                this.startPos = new BlockPos(xStart, yStart, zStart);
                this.endPos = new BlockPos(xEnd, yEnd, zEnd);
                this.pivot = pivot;
                this.horizontalIndex = Arrays.asList(new BlockPos[xEnd - xStart + 1]);
                this.positions = Arrays.asList(new BlockPos[(this.endPos.func_177958_n() - this.startPos.func_177958_n() + 1) * (this.endPos.func_177956_o() - this.startPos.func_177956_o() + 1) + 1]);
                for (int i = 0; i <= xEnd - xStart; ++i) {
                    for (int j = 0; j <= height; ++j) {
                        this.positions.set(blockCounter, this.startPos.func_177982_a(i, j, 0));
                        ++blockCounter;
                    }
                    this.horizontalIndex.set(hiCounter, this.startPos.func_177982_a(i, 0, 0));
                    ++hiCounter;
                }
            } else if (this.axis == Direction.Axis.Z) {
                int xStart = pivot.func_177958_n();
                int xEnd = pivot.func_177958_n();
                int zStart = pivot.func_177952_p() + startOffset;
                int zEnd = pivot.func_177952_p() + endOffset;
                this.dimensions = new Vector3i(xEnd - xStart, yEnd - yStart, zEnd - zStart);
                this.startPos = new BlockPos(xStart, yStart, zStart);
                this.endPos = new BlockPos(xEnd, yEnd, zEnd);
                this.pivot = pivot;
                this.horizontalIndex = Arrays.asList(new BlockPos[zEnd - zStart + 1]);
                this.positions = Arrays.asList(new BlockPos[(this.endPos.func_177956_o() - this.startPos.func_177956_o() + 1) * (this.endPos.func_177952_p() - this.startPos.func_177952_p() + 1) + 1]);
                for (int i = 0; i <= zEnd - zStart; ++i) {
                    for (int j = 0; j <= height; ++j) {
                        this.positions.set(blockCounter, this.startPos.func_177982_a(0, j, i));
                        ++blockCounter;
                    }
                    this.horizontalIndex.set(hiCounter, this.startPos.func_177982_a(0, 0, i));
                    ++hiCounter;
                }
            } else {
                throw new Error("Danny's Expansion: wall axis cannot be vertical");
            }
        }

        public Direction.Axis getAxis() {
            return this.axis;
        }

        public Direction getOuterDirection() {
            return this.outerDirection;
        }

        public Direction getInnerDirection() {
            return this.outerDirection.func_176734_d();
        }
    }

    public static class CubeRoom {
        public Vector3i dimansions;
        public PositionStack innerCube;
        public PositionStack floor;
        public PositionStack ceiling;
        public RoomWall northWall;
        public RoomWall southWall;
        public RoomWall westWall;
        public RoomWall eastWall;
        public BlockPos startPos;
        @Nullable
        public RoomWall[] walls;
        @Nullable
        public RoomWall[] xAxisWalls;
        @Nullable
        public RoomWall[] zAxisWalls;

        public CubeRoom(int xStart, int yBottom, int zStart, int xEnd, int yTop, int zEnd) {
            this.dimansions = new Vector3i(xEnd - xStart, yTop - yBottom, zEnd - zStart);
            this.innerCube = new PositionStack(xStart, yBottom, zStart, xEnd, yTop, zEnd);
            this.floor = new PositionStack(xStart, yBottom - 1, zStart, xEnd, yBottom - 1, zEnd);
            this.ceiling = new PositionStack(xStart, yTop + 1, zStart, xEnd, yTop + 1, zEnd);
            this.startPos = new BlockPos(xStart, yBottom, zStart);
            this.northWall = new RoomWall(this.startPos.func_177978_c(), Direction.NORTH, 0, xEnd - xStart, yTop - yBottom);
            this.southWall = new RoomWall(this.startPos.func_177970_e(zEnd - zStart + 1), Direction.SOUTH, 0, xEnd - xStart, yTop - yBottom);
            this.westWall = new RoomWall(this.startPos.func_177976_e(), Direction.WEST, 0, zEnd - zStart, yTop - yBottom);
            this.eastWall = new RoomWall(this.startPos.func_177965_g(xEnd - xStart + 1), Direction.EAST, 0, zEnd - zStart, yTop - yBottom);
        }

        public RoomWall[] getWalls() {
            if (this.walls == null) {
                this.walls = new RoomWall[]{this.northWall, this.southWall, this.westWall, this.eastWall};
            }
            return this.walls;
        }

        public RoomWall[] getXWalls() {
            if (this.xAxisWalls == null) {
                this.xAxisWalls = new RoomWall[]{this.westWall, this.eastWall};
            }
            return this.xAxisWalls;
        }

        public RoomWall[] getZWalls() {
            if (this.zAxisWalls == null) {
                this.zAxisWalls = new RoomWall[]{this.northWall, this.southWall};
            }
            return this.zAxisWalls;
        }

        public List<BlockPos> getWallPairPos(Direction.Axis axis, int index) {
            List<BlockPos> positions = Arrays.asList(new BlockPos[2]);
            if (axis == Direction.Axis.X) {
                if (this.northWall.horizontalIndex.size() < index) {
                    throw new Error("Danny's Expansion: h index is bigger than wall's size");
                }
                positions.set(0, this.northWall.horizontalIndex.get(index));
                positions.set(1, this.southWall.horizontalIndex.get(index));
            } else if (axis == Direction.Axis.Z) {
                if (this.westWall.horizontalIndex.size() < index) {
                    throw new Error("Danny's Expansion: h index is bigger than wall's size");
                }
                positions.set(0, this.westWall.horizontalIndex.get(index));
                positions.set(1, this.eastWall.horizontalIndex.get(index));
            } else {
                throw new Error("Danny's Exansion: axis cannot be vertical");
            }
            return positions;
        }

        public int getDimensionFromAxis(Direction.Axis axis) {
            if (axis == Direction.Axis.X) {
                return this.dimansions.func_177958_n();
            }
            if (axis == Direction.Axis.Z) {
                return this.dimansions.func_177952_p();
            }
            return this.dimansions.func_177956_o();
        }
    }
}

