/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.core.Packets.servertoclient;

import com.bottomtextdanny.dannys_expansion.core.events.ResourceReloadHandler;
import com.bottomtextdanny.dannys_expansion.core.misc.WorkbenchCraft;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateRecipesPct {
    private final int recipeNumber;
    private final List<CompoundNBT> recipeNBT;

    public UpdateRecipesPct(PacketBuffer packetBuffer) {
        this.recipeNumber = packetBuffer.readInt();
        List<CompoundNBT> newList = Arrays.asList(new CompoundNBT[this.recipeNumber]);
        for (int i = 0; i < this.recipeNumber; ++i) {
            CompoundNBT comp = packetBuffer.func_150793_b();
            if (comp == null) continue;
            newList.set(i, comp);
        }
        this.recipeNBT = newList;
    }

    public UpdateRecipesPct(List<WorkbenchCraft> recipes) {
        ArrayList<CompoundNBT> nbt = new ArrayList<CompoundNBT>();
        recipes.forEach(rec -> nbt.add(rec.serialize()));
        this.recipeNumber = recipes.size();
        this.recipeNBT = nbt;
    }

    public void encode(PacketBuffer packetBuffer) {
        packetBuffer.writeInt(this.recipeNumber);
        this.recipeNBT.forEach(tag -> packetBuffer.func_150786_a(tag));
    }

    public static void handle(UpdateRecipesPct msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                ResourceReloadHandler.recipeManager.workbenchRecipes.clear();
                msg.recipeNBT.forEach(nbt -> ResourceReloadHandler.recipeManager.workbenchRecipes.add(WorkbenchCraft.deserialize(nbt)));
            });
            context.setPacketHandled(true);
        }
    }
}

