/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.core.Registries;

import com.bottomtextdanny.dannys_expansion.core.capabilities.player.DannyEntityCap;
import com.bottomtextdanny.dannys_expansion.core.capabilities.world.DannyWorldCap;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.thread.SidedThreadGroups;

@Mod.EventBusSubscriber(modid="dannys_expansion")
public class DannyCapabilities {
    public static void register() {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            CapabilityManager.INSTANCE.register(DannyWorldCap.class, new EmptyStorage(), DannyWorldCap::new);
            CapabilityManager.INSTANCE.register(DannyEntityCap.class, new EmptyStorage(), DannyEntityCap::new);
        }
    }

    @SubscribeEvent
    public static void attachToWorld(AttachCapabilitiesEvent<World> event) {
        DannyCapabilities.addCap(event, "wind", new DannyWorldCap());
    }

    @SubscribeEvent
    public static void attachToEntity(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            DannyCapabilities.addCap(event, "gun_stability", new DannyEntityCap());
        }
    }

    static void addCap(AttachCapabilitiesEvent<?> event, String key, ICapabilityProvider cap) {
        event.addCapability(new ResourceLocation("dannys_expansion", key), cap);
    }

    public static class EmptyStorage<C extends ICapabilityProvider>
    implements Capability.IStorage<C> {
        @Nullable
        public INBT writeNBT(Capability<C> capability, C instance, Direction side) {
            return null;
        }

        public void readNBT(Capability<C> capability, C instance, Direction side, INBT nbt) {
        }
    }
}

