/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.core.Util;

import com.bottomtextdanny.dannys_expansion.core.Util.MathUtil;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class DannyRayTraceHelper {
    @Nullable
    public static EntityRayTraceResult rayTraceEntities(World worldIn, Entity projectile, Vector3d startVec, Vector3d endVec, AxisAlignedBB boundingBox, Predicate<Entity> filter) {
        Entity entity = null;
        for (Entity entity1 : worldIn.func_175674_a(projectile, boundingBox, filter)) {
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g(1.0);
            if (!axisalignedbb.func_72326_a(boundingBox)) continue;
            entity = entity1;
        }
        return entity == null ? null : new EntityRayTraceResult(entity);
    }

    @Nullable
    public static EntityRayTraceResult rayTraceEntitiesOrb(World worldIn, Entity projectile, Vector3d startVec, Vector3d endVec, AxisAlignedBB boundingBox, Predicate<Entity> filter) {
        double d0 = Double.MAX_VALUE;
        Entity entity = null;
        for (Entity entity1 : worldIn.func_175674_a(projectile, boundingBox.func_72314_b((double)(projectile.func_213311_cf() / 2.0f), (double)(projectile.func_213302_cg() / 2.0f), (double)(projectile.func_213311_cf() / 2.0f)), filter)) {
            double d1;
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_72314_b((double)projectile.func_213311_cf(), (double)projectile.func_213302_cg(), (double)projectile.func_213311_cf());
            Optional optional = axisalignedbb.func_216365_b(startVec, endVec);
            if (!optional.isPresent() || !((d1 = startVec.func_72436_e((Vector3d)optional.get())) < d0)) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity == null ? null : new EntityRayTraceResult(entity);
    }

    @Nullable
    public static EntityRayTraceResult rayTraceEntitiesBullet(World worldIn, Entity projectile, Vector3d startVec, Vector3d endVec, AxisAlignedBB boundingBox, Predicate<Entity> filter) {
        double d0 = Double.MAX_VALUE;
        Entity entity = null;
        for (Entity entity1 : worldIn.func_175674_a(projectile, boundingBox, filter)) {
            float distProg = -2.0f;
            float closestDistance = Float.MAX_VALUE;
            Vector3d easedPosition = Vector3d.field_186680_a;
            float w = entity1.func_213311_cf() / 2.0f;
            float h = entity1.func_213302_cg();
            for (int i = 0; i < 4; ++i) {
                double d1;
                AxisAlignedBB axisalignedbb;
                Optional optional;
                Vector3d easedVec = MathUtil.getVecLerp(distProg, new Vector3d(entity1.field_70142_S, entity1.field_70137_T, entity1.field_70136_U), entity1.func_213303_ch());
                float distanceToEase = MathUtil.getDistance(projectile.func_213303_ch(), easedVec);
                if (distanceToEase < closestDistance) {
                    closestDistance = distanceToEase;
                    easedPosition = easedVec;
                }
                if ((optional = (axisalignedbb = new AxisAlignedBB(easedVec.func_72441_c((double)(-w), 0.0, (double)(-w)), easedPosition.func_72441_c((double)w, (double)h, (double)w))).func_216365_b(startVec, endVec)).isPresent() && (d1 = startVec.func_72436_e((Vector3d)optional.get())) < d0) {
                    entity = entity1;
                    d0 = d1;
                }
                distProg += 1.0f;
            }
        }
        return entity == null ? null : new EntityRayTraceResult(entity);
    }

    public static RayTraceResult bulletRaytrace(Entity entity, Predicate<Entity> predicate, Vector3d vec, RayTraceContext.FluidMode fluidMode) {
        EntityRayTraceResult entityraytraceresult;
        Vector3d vector3d3;
        Vector3d vector3d2 = entity.func_213303_ch();
        BlockRayTraceResult raytraceresult = entity.field_70170_p.func_217299_a(new RayTraceContext(vector3d2, vector3d3 = vector3d2.func_178787_e(vec), RayTraceContext.BlockMode.COLLIDER, fluidMode, entity));
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
            vector3d3 = raytraceresult.func_216347_e();
        }
        if ((entityraytraceresult = DannyRayTraceHelper.rayTraceEntitiesBullet(entity.field_70170_p, entity, vector3d2, vector3d3, entity.func_174813_aQ().func_216361_a(vec), predicate)) != null) {
            raytraceresult = entityraytraceresult;
        }
        return raytraceresult;
    }

    public static RayTraceResult orbRaytrace(Entity entity, Predicate<Entity> predicate, Vector3d vec, RayTraceContext.FluidMode fluidMode) {
        EntityRayTraceResult entityraytraceresult;
        Vector3d vector3d3;
        Vector3d vector3d2 = entity.func_213303_ch();
        BlockRayTraceResult raytraceresult = entity.field_70170_p.func_217299_a(new RayTraceContext(vector3d2, vector3d3 = vector3d2.func_178787_e(vec), RayTraceContext.BlockMode.COLLIDER, fluidMode, entity));
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
            vector3d3 = raytraceresult.func_216347_e();
        }
        if ((entityraytraceresult = DannyRayTraceHelper.rayTraceEntitiesOrb(entity.field_70170_p, entity, vector3d2, vector3d3, entity.func_174813_aQ().func_216361_a(vec), predicate)) != null) {
            raytraceresult = entityraytraceresult;
        }
        return raytraceresult;
    }

    public static BlockRayTraceResult rayTraceBlocks(Entity p_234618_0_) {
        Vector3d vector3d = p_234618_0_.func_70040_Z();
        World world = p_234618_0_.field_70170_p;
        Vector3d vector3d1 = p_234618_0_.func_213303_ch();
        Vector3d vector3d2 = vector3d1.func_178787_e(vector3d);
        return world.func_217299_a(new RayTraceContext(vector3d1, vector3d2, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.ANY, p_234618_0_));
    }
}

