/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.core.Util;

import com.bottomtextdanny.dannys_expansion.client.Particles.DannyParticle;
import com.bottomtextdanny.dannys_expansion.client.animation.Easing;
import com.bottomtextdanny.dannys_expansion.client.animation.RotationMatrix;
import java.math.BigDecimal;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;

public class MathUtil {
    public static int getRandomOffset(int base, float offset) {
        return base + (int)((double)base * new Random().nextGaussian() * (double)offset);
    }

    public static float getBlockDistance(int a1, int a2, int b1, int b2) {
        return (float)Math.sqrt(Math.pow(a1 - b1, 2.0) + Math.pow(a2 - b2, 2.0));
    }

    public static float getBlockDistance(int pos1, int pos2) {
        return (float)Math.sqrt(Math.pow(pos1, 2.0) + Math.pow(pos2, 2.0));
    }

    public static float getBlockDistance(int a1, int a2, int a3, int b1, int b2, int b3) {
        return (float)Math.sqrt(Math.pow(a1 - b1, 2.0) + Math.pow(a2 - b2, 2.0) + Math.pow(a3 - b3, 2.0));
    }

    public static float lerp(float pct, float start, float end) {
        return start + (1.0f - pct) * (BigDecimal.valueOf(start).floatValue() - BigDecimal.valueOf(end).floatValue());
    }

    public static float loopLerp(float pct, float loopStart, float loopEnd, float start, float end) {
        float difference;
        if (start > end) {
            difference = loopEnd - start;
            difference += end - loopStart;
        } else {
            difference = end - start;
        }
        return MathUtil.loop(start, loopStart, loopEnd, pct * difference);
    }

    public static float freeAnimator(float amount, float weight, float prevTick, float tick, Easing easing, float timer) {
        return MathUtil.freeAnimator(amount, weight, prevTick, tick, easing, timer, false);
    }

    public static float freeAnimator(float amount, float weight, float prevTick, float tick, Easing easing, float timer, boolean keepValue) {
        if (timer >= prevTick && timer < tick) {
            float uneasedProg = (timer - prevTick) / (tick - prevTick);
            float prog = easing.progression(uneasedProg) * amount + weight;
            return prog;
        }
        if (keepValue) {
            return timer > tick ? 1.0f : 0.0f;
        }
        return 0.0f;
    }

    public static float freeAnimator1(float amount, float weight, float prevTick, float tick, Easing easing, float timer) {
        if (timer >= prevTick && timer < tick) {
            float uneasedProg = (timer - prevTick) / (tick - prevTick);
            float prog = easing.progression(uneasedProg) * amount;
            if (timer > tick) {
                prog += weight;
            }
            return prog;
        }
        return 0.0f;
    }

    public static float motionHelper(float amount, float weight, int prevTick, int tick, int timer) {
        if (timer >= prevTick && timer < tick) {
            return amount + weight;
        }
        return 0.0f;
    }

    public static float clampedRotate(float from, float to, float maxDelta) {
        float f = MathHelper.func_203302_c((float)from, (float)to);
        float f1 = MathHelper.func_76131_a((float)f, (float)(-maxDelta), (float)maxDelta);
        return from + f1;
    }

    public static float getTargetPitch(Entity entity1, Entity entity2) {
        double d0 = entity2.func_226277_ct_() - entity1.func_226277_ct_();
        double d1 = entity2.func_226278_cu_() + entity2.func_174813_aQ().func_216360_c() / 2.0 - entity1.func_226278_cu_();
        double d2 = entity2.func_226281_cx_() - entity1.func_226281_cx_();
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        return (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.2957763671875));
    }

    public static float getTargetPitch(Entity entity1, double x, double y, double z) {
        double d0 = x - entity1.func_226277_ct_();
        double d1 = y - entity1.func_226278_cu_();
        double d2 = z - entity1.func_226281_cx_();
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        return (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.2957763671875));
    }

    public static float getTargetPitch(double x1, double y1, double z1, double x2, double y2, double z2) {
        double d0 = x2 - x1;
        double d1 = y2 - y1;
        double d2 = z2 - z1;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        return (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.2957763671875));
    }

    public static float getTargetYaw(Entity entity1, Entity entity2) {
        double d0 = entity2.func_226277_ct_() - entity1.func_226277_ct_();
        double d1 = entity2.func_226281_cx_() - entity1.func_226281_cx_();
        return (float)(MathHelper.func_181159_b((double)d1, (double)d0) * 57.2957763671875) - 90.0f;
    }

    public static float getTargetYaw(Entity entity1, double x, double y) {
        double d0 = x - entity1.func_226277_ct_();
        double d1 = y - entity1.func_226281_cx_();
        return (float)(MathHelper.func_181159_b((double)d1, (double)d0) * 57.2957763671875) - 90.0f;
    }

    public static float getTargetYaw(double x, double y, double x1, double y1) {
        double d0 = x1 - x;
        double d1 = y1 - y;
        return (float)(MathHelper.func_181159_b((double)d1, (double)d0) * 57.2957763671875) - 90.0f;
    }

    public static Vector3d fromPitchYaw(float pitch, float yaw) {
        float f = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        return new Vector3d((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    public static Vector3d fromPitchYawRoll(double pitch, double yaw, double roll) {
        RotationMatrix matrix = new RotationMatrix();
        matrix.rotX((float)Math.toRadians(pitch));
        matrix.rotY((float)Math.toRadians(yaw));
        matrix.rotZ((float)Math.toRadians(roll));
        return matrix.getTransform(new Vector3d(1.0, 1.0, 1.0));
    }

    public static float loop(float holder, float start, float end, float offset) {
        float result;
        for (result = holder + offset; result > end; result -= MathHelper.func_76135_e((float)end) + MathHelper.func_76135_e((float)start)) {
        }
        return result;
    }

    public static int verticalNonSolid(IBlockReader worldIn, BlockPos pos, int sum, int max) {
        int j = 0;
        for (int i = 0; !(i >= Math.abs(max) || worldIn.func_180495_p(pos.func_177963_a(0.0, (double)(j + sum), 0.0)).func_200132_m() && worldIn.func_180495_p(pos.func_177963_a(0.0, (double)(j + sum), 0.0)) != Blocks.field_150432_aD.func_176223_P()); ++i) {
            j += sum;
        }
        return Math.abs(j);
    }

    public static float getMovement(Entity entity) {
        return MathUtil.getDistance(entity.field_70142_S, entity.field_70137_T, entity.field_70136_U, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
    }

    public static float getMovement(DannyParticle entity) {
        return MathUtil.getDistance(entity.prevPosX(), entity.prevPosY(), entity.prevPosZ(), entity.posX(), entity.posY(), entity.posZ());
    }

    public static float getLerp(double start, double end, double actual) {
        actual = MathHelper.func_151237_a((double)actual, (double)Math.min(start, end), (double)Math.max(start, end));
        actual -= start;
        end -= start;
        if (start <= 0.0) {
            return 0.0f;
        }
        return (float)(actual / end);
    }

    public static Vector3d getVecLerp(float prog, Vector3d start, Vector3d end) {
        double easedX = (end.field_72450_a - start.field_72450_a) * (double)prog + start.field_72450_a;
        double easedY = (end.field_72448_b - start.field_72448_b) * (double)prog + start.field_72448_b;
        double easedZ = (end.field_72449_c - start.field_72449_c) * (double)prog + start.field_72449_c;
        return new Vector3d(easedX, easedY, easedZ);
    }

    public static float getDistance(Entity entityIn, double x, double y, double z) {
        float f = (float)(entityIn.func_226277_ct_() - x);
        float f1 = (float)(entityIn.func_226278_cu_() - y);
        float f2 = (float)(entityIn.func_226281_cx_() - z);
        return MathHelper.func_76129_c((float)(f * f + f1 * f1 + f2 * f2));
    }

    public static float getDistance(double x1, double y1, double z1, double x2, double y2, double z2) {
        float f = (float)(x1 - x2);
        float f1 = (float)(y1 - y2);
        float f2 = (float)(z1 - z2);
        return MathHelper.func_76129_c((float)(f * f + f1 * f1 + f2 * f2));
    }

    public static float getDistance(Vector3d vec0, Vector3d vec1) {
        float f = (float)(vec0.func_82615_a() - vec1.func_82615_a());
        float f1 = (float)(vec0.func_82617_b() - vec1.func_82617_b());
        float f2 = (float)(vec0.func_82616_c() - vec1.func_82616_c());
        return MathHelper.func_76129_c((float)(f * f + f1 * f1 + f2 * f2));
    }

    public static float getHorizontalDistance(Entity entity1, Entity entity2) {
        double d0 = entity1.func_226277_ct_() - entity2.func_226277_ct_();
        double d1 = entity1.func_226281_cx_() - entity2.func_226281_cx_();
        return (float)Math.sqrt(d0 * d0 + d1 * d1);
    }

    public static float getHorizontalDistance(Entity entity, double x2, double z2) {
        double d0 = entity.func_226277_ct_() - x2;
        double d1 = entity.func_226281_cx_() - z2;
        return (float)Math.sqrt(d0 * d0 + d1 * d1);
    }

    public static float getHorizontalDistance(double x1, double z1, double x2, double z2) {
        double d0 = x1 - x2;
        double d1 = z1 - z2;
        return (float)Math.sqrt(d0 * d0 + d1 * d1);
    }
}

