/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.core.Util;

import com.bottomtextdanny.dannys_expansion.core.config.common.CommonConfigurationHandler;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;

public class SpawnParameters {
    public static boolean canMonsterSpawnInLight(EntityType<? extends MobEntity> type, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return worldIn.func_175659_aa() != Difficulty.PEACEFUL && SpawnParameters.isValidLightLevel(worldIn, pos, randomIn) && SpawnParameters.canSpawnOn(type, worldIn, reason, pos, randomIn);
    }

    public static boolean canSpawnOn(EntityType<? extends MobEntity> typeIn, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        BlockPos blockpos = pos.func_177977_b();
        return reason == SpawnReason.SPAWNER || worldIn.func_180495_p(blockpos).func_215688_a((IBlockReader)worldIn, blockpos, typeIn);
    }

    public static boolean isValidLightLevel(IWorld worldIn, BlockPos pos, Random randomIn) {
        if (worldIn.func_226658_a_(LightType.SKY, pos) > randomIn.nextInt(32)) {
            return false;
        }
        int i = worldIn.func_72912_H().func_76061_m() ? worldIn.func_205049_d(pos, 10) : worldIn.func_201696_r(pos);
        return i <= randomIn.nextInt(8);
    }

    public static boolean canAnimalSpawn(EntityType<? extends LivingEntity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_203425_a(Blocks.field_196658_i) && worldIn.func_226659_b_(pos, 0) > 8;
    }

    public static boolean canMonsterSpawnInRain(EntityType<? extends MobEntity> type, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return (Boolean)CommonConfigurationHandler.CONFIG.sporerOnlySpawnInRain.get() != false && worldIn.func_175659_aa() != Difficulty.PEACEFUL && worldIn.func_72912_H().func_76059_o() && SpawnParameters.canSpawnOn(type, worldIn, reason, pos, randomIn) && (double)worldIn.func_226691_t_(pos).func_225486_c(pos) <= 0.95;
    }

    public static boolean canMonsterSpawnInLavaHeight(EntityType<? extends MobEntity> type, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return worldIn.func_175659_aa() != Difficulty.PEACEFUL && pos.func_177956_o() <= 36 && SpawnParameters.canSpawnOn(type, worldIn, reason, pos, randomIn);
    }

    public static boolean canSpawnInSurface(EntityType<? extends LivingEntity> entityType, IWorld worldIn, SpawnReason reason, BlockPos pos, Random rand) {
        return worldIn.func_175659_aa() != Difficulty.PEACEFUL && worldIn.func_226660_f_(pos);
    }

    public static boolean canSpawnInJungle(EntityType<? extends LivingEntity> entityType, IWorld worldIn, SpawnReason reason, BlockPos pos, Random rand) {
        BlockState blockState = worldIn.func_180495_p(pos.func_177977_b());
        return worldIn.func_175659_aa() != Difficulty.PEACEFUL && (blockState.func_235714_a_((ITag)BlockTags.field_206952_E) || blockState == Blocks.field_196658_i.func_176223_P());
    }

    public static boolean noRestriction(EntityType<? extends LivingEntity> entityType, IWorld worldIn, SpawnReason reason, BlockPos pos, Random rand) {
        return true;
    }
}

