/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.core.events;

import com.bottomtextdanny.dannys_expansion.core.Registries.DannyStructures;
import com.bottomtextdanny.dannys_expansion.core.config.common.CommonConfigurationHandler;
import com.bottomtextdanny.dannys_expansion.core.config.common.MobSpawnConfiguration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="dannys_expansion")
public class Spawns {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void addSpawn(BiomeLoadingEvent event) {
        Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(event.getName());
        List<MobSpawnConfiguration> spawns = CommonConfigurationHandler.Config.spawnList;
        if (biome != null) {
            RegistryKey biomeKey = RegistryKey.func_240903_a_((RegistryKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)event.getName());
            CommonConfigurationHandler.Config config = CommonConfigurationHandler.CONFIG;
            Set biomeDic = BiomeDictionary.getTypes((RegistryKey)biomeKey);
            if (((List)config.validIDs.get()).contains(event.getName().func_110624_b())) {
                if (biome.func_201856_r() == Biome.Category.OCEAN) {
                    event.getGeneration().func_242516_a(DannyStructures.ANGLERS_TREASURE);
                }
                if (biome.func_201856_r() == Biome.Category.JUNGLE) {
                    event.getGeneration().func_242516_a(DannyStructures.KLIFOUR_SPAWN);
                }
                for (MobSpawnConfiguration spawn : spawns) {
                    EntityType<?> type = spawn.getEntityType();
                    if (type == null) continue;
                    boolean blDictionaryFlag = false;
                    for (String str : (List)spawn.blacklistBiomeDictionaries.get()) {
                        List<String> subStr = MobSpawnConfiguration.decodeNode(str);
                        boolean validate = true;
                        Iterator<String> iterator = subStr.iterator();
                        while (iterator.hasNext()) {
                            String s = iterator.next();
                            if (!biomeDic.stream().noneMatch(dic -> dic.getName().equals(s))) continue;
                            validate = false;
                            break;
                        }
                        if (blDictionaryFlag || !validate) continue;
                        blDictionaryFlag = true;
                    }
                    boolean blBiomeFlag = ((List)spawn.blacklistBiomes.get()).stream().anyMatch(o -> new ResourceLocation(o).equals((Object)biomeKey.func_240901_a_()));
                    if (blDictionaryFlag || blBiomeFlag) continue;
                    boolean dictionaryFlag = false;
                    for (String str : (List)spawn.biomeDictionaries.get()) {
                        List<String> subStr = MobSpawnConfiguration.decodeNode(str);
                        boolean validate = true;
                        for (String s : subStr) {
                            if (!biomeDic.stream().noneMatch(dic -> dic.getName().equals(s))) continue;
                            validate = false;
                            break;
                        }
                        if (dictionaryFlag || !validate) continue;
                        dictionaryFlag = true;
                    }
                    boolean biomeFlag = ((List)spawn.biomes.get()).stream().anyMatch(o -> new ResourceLocation(o).equals((Object)biomeKey.func_240901_a_()));
                    if (!dictionaryFlag && !biomeFlag || (Integer)spawn.weight.get() <= 0) continue;
                    event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners(type, ((Integer)spawn.weight.get()).intValue(), ((Integer)spawn.min.get()).intValue(), ((Integer)spawn.max.get()).intValue()));
                }
            }
        }
    }
}

