/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.core.events;

import com.bottomtextdanny.dannys_expansion.common.Items.accessory.Accessory;
import com.bottomtextdanny.dannys_expansion.common.Items.bow.DannyBowItem;
import com.bottomtextdanny.dannys_expansion.core.Packets.DENetwork;
import com.bottomtextdanny.dannys_expansion.core.Util.EntityUtil;
import com.bottomtextdanny.dannys_expansion.core.Util.Timer;
import com.bottomtextdanny.dannys_expansion.core.capabilities.player.DannyEntityCap;
import com.bottomtextdanny.dannys_expansion.core.capabilities.world.DannyWorldCap;
import com.bottomtextdanny.dannys_expansion.core.interfaces.IDannyHoldable;
import com.bottomtextdanny.dannys_expansion.core.interfaces.IHoldable;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.GameRules;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dannys_expansion")
public class TickHandler {
    static float windDirectionQuery = 150.0f;
    static Timer stopTimer = new Timer(40);

    @SubscribeEvent
    public static void handleWorldTick(TickEvent.WorldTickEvent event) {
        DannyWorldCap capability = (DannyWorldCap)event.world.getCapability(DannyWorldCap.WORLD_WIND).orElse(null);
        if (event.phase.equals((Object)TickEvent.Phase.END)) {
            stopTimer.tryUp();
            int i0 = new Random().nextInt(220);
            if (capability.isWindStop()) {
                DENetwork.setWindWave(false, 0);
                capability.windStopMagnitude = 0;
                capability.setWindStop(false);
            } else if (i0 == 2 && stopTimer.hasEnded()) {
                int i1 = new Random(event.world.func_82737_E()).nextInt(3) + 1;
                DENetwork.setWindWave(true, i1);
                capability.windStopMagnitude = i1;
                capability.setWindStop(true);
                stopTimer.reset();
            }
            if (MathHelper.func_76141_d((float)windDirectionQuery) == MathHelper.func_76141_d((float)capability.getWindDirection())) {
                float f0 = 1.0f;
                if (event.world.func_72911_I()) {
                    f0 = 1.4f;
                } else if (event.world.func_72896_J()) {
                    f0 = 1.2f;
                }
                windDirectionQuery = MathHelper.func_76131_a((float)MathHelper.func_151240_a((Random)new Random(), (float)(capability.windDirection - 22.5f), (float)(capability.windDirection + 22.5f)), (float)(-10.0f * f0), (float)(90.0f + 10.0f * f0));
            } else {
                float addition;
                float f = addition = capability.getWindDirection() < windDirectionQuery ? 0.25f : -0.25f;
                if (event.world.func_72911_I()) {
                    addition *= 2.5f;
                } else if (event.world.func_72896_J()) {
                    addition *= 1.5f;
                }
                capability.setWindDirection(capability.getWindDirection() + addition);
            }
            if (event.world.func_72912_H().func_76061_m()) {
                capability.setWindStrength(20.0f);
            } else if (event.world.func_72912_H().func_76059_o()) {
                capability.setWindStrength(16.0f);
            } else {
                capability.setWindStrength(10.0f);
            }
        }
    }

    @SubscribeEvent
    public static void handlePlayerTick(TickEvent.PlayerTickEvent event) {
        DannyEntityCap capability = (DannyEntityCap)event.player.getCapability(DannyEntityCap.GUN_STABILITY).orElse(null);
        if (event.player.getCapability(DannyEntityCap.GUN_STABILITY).isPresent()) {
            if (event.phase == TickEvent.Phase.START) {
                capability.setPrevHoldableProgression(capability.getHoldableProgression());
                capability.setPrevRecoil(capability.getRecoil());
            } else if (event.phase == TickEvent.Phase.END) {
                Object item;
                if (event.player.func_184607_cu().func_77973_b() instanceof IDannyHoldable && (item = (IDannyHoldable)event.player.func_184607_cu().func_77973_b()).automatic() && event.player.func_184612_cw() >= item.getTrueMaxCount(event.player.func_184607_cu())) {
                    event.player.func_184597_cx();
                }
                for (Hand hand : Hand.values()) {
                    ItemStack stack;
                    CompoundNBT nbt;
                    if (!(event.player.func_184586_b(hand).func_77973_b() instanceof DannyBowItem) || (nbt = (stack = event.player.func_184586_b(hand)).func_190925_c("DannyBowHolder")).func_74764_b("holder") && nbt.func_186857_a("holder") == event.player.func_110124_au()) continue;
                    nbt.func_186854_a("holder", event.player.func_110124_au());
                }
                if (capability.getItemSlot() != event.player.field_71071_by.field_70461_c) {
                    capability.setItemSlot(event.player.field_71071_by.field_70461_c);
                    capability.setPrevHoldableProgression(0);
                    capability.setHoldableProgression(0);
                }
                if (capability.getRecoil() > 0.0f) {
                    capability.setRecoil(MathHelper.func_76131_a((float)(capability.getRecoil() * capability.getRecoilMult()), (float)0.0f, (float)2.1474836E9f));
                    capability.setRecoil(MathHelper.func_76131_a((float)(capability.getRecoil() - capability.getRecoilSub()), (float)0.0f, (float)2.1474836E9f));
                }
                if (!event.player.field_70170_p.field_72995_K) {
                    if (capability.accessoriesNeedSync) {
                        DENetwork.syncAccessories(event.player);
                        capability.accessoriesNeedSync = false;
                    }
                    DENetwork.tickAccessory(event.player);
                    for (int i = 0; i < 5; ++i) {
                        Accessory accessory = capability.getAccessories().getAccessoryInstances().get(i);
                        if (accessory.isInitialized()) {
                            accessory.tick();
                            continue;
                        }
                        accessory.initialize(event.player, i);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLogin(PlayerEvent.LoadFromFile event) {
        DannyEntityCap capability = EntityUtil.getDannyCap(event.getPlayer());
        capability.accessoriesNeedSync = true;
        DENetwork.syncRightClickActions((ServerPlayerEntity)event.getPlayer());
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        if (!event.getEntity().field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c) && event.getEntity() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntity();
            DannyEntityCap capability = (DannyEntityCap)player.getCapability(DannyEntityCap.GUN_STABILITY).orElse(null);
            for (int i = 0; i < 5; ++i) {
                player.func_146097_a(capability.getAccessories().func_70301_a(i), true, false);
            }
            capability.getAccessories().getInventoryContents().clear();
        }
    }

    @SubscribeEvent
    public static void onHurt(LivingHurtEvent event) {
        DannyEntityCap capability;
        if (event.getSource().func_76346_g() instanceof PlayerEntity) {
            capability = EntityUtil.getDannyCap((PlayerEntity)event.getSource().func_76346_g());
            AtomicReference<Float> atomicDamage = new AtomicReference<Float>(Float.valueOf(event.getAmount()));
            capability.getAccessories().getAccessoryInstances().forEach(acc -> acc.onDealDamage(event.getEntityLiving(), event.getSource(), atomicDamage));
            event.setAmount(atomicDamage.get().floatValue());
        }
        if (event.getEntity() instanceof PlayerEntity) {
            capability = EntityUtil.getDannyCap((PlayerEntity)event.getEntity());
            capability.getAccessories().getAccessoryInstances().forEach(acc -> acc.onHarm(event.getSource(), event.getAmount()));
        }
    }

    @SubscribeEvent
    public static void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        DannyEntityCap capability = EntityUtil.getDannyCap(event.getPlayer());
        capability.accessoriesNeedSync = true;
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        if (event.getEntity().field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c)) {
            DannyEntityCap ogCapability = (DannyEntityCap)event.getOriginal().getCapability(DannyEntityCap.GUN_STABILITY).orElse(null);
            DannyEntityCap capability = (DannyEntityCap)event.getPlayer().getCapability(DannyEntityCap.GUN_STABILITY).orElse(null);
            for (int i = 0; i < 5; ++i) {
                capability.setAccessory(i, ogCapability.getAccessories().func_70301_a(i));
            }
        }
    }

    @SubscribeEvent
    public static void onItemRightClick(PlayerInteractEvent.RightClickItem event) {
        Item item;
        PlayerEntity player = event.getPlayer();
        if (event.getHand() == Hand.OFF_HAND && (item = player.func_184586_b(Hand.MAIN_HAND).func_77973_b()) instanceof IHoldable && ((IHoldable)item).canBePressed(event.getWorld(), event.getPlayer(), player.func_184586_b(Hand.MAIN_HAND))) {
            event.setCanceled(true);
        }
    }
}

