/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.core.misc;

import com.bottomtextdanny.dannys_expansion.core.misc.WorkbenchCraftType;
import com.bottomtextdanny.dannys_expansion.core.misc.WorkbenchIngredient;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;

public class WorkbenchCraft {
    public static WorkbenchCraft EMPTY = new WorkbenchCraft(null, ItemStack.field_190927_a, null);
    ResourceLocation resourceLocation;
    List<WorkbenchIngredient> ingredients;
    ItemStack result;
    WorkbenchCraftType type;

    public WorkbenchCraft(List<WorkbenchIngredient> ingredients, ItemStack result, ResourceLocation resourceLocation) {
        this.ingredients = ingredients;
        this.result = result;
        this.resourceLocation = resourceLocation;
    }

    public List<WorkbenchIngredient> getIngredients() {
        return this.ingredients;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public CompoundNBT serialize() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74778_a("location", this.resourceLocation.toString());
        compound.func_218657_a("result_stack", (INBT)this.result.serializeNBT());
        for (int i = 0; i < this.ingredients.size(); ++i) {
            compound.func_218657_a("ingredient_" + i, (INBT)this.ingredients.get(i).serialize());
        }
        compound.func_74768_a("type", this.type.ordinal());
        return compound;
    }

    public static WorkbenchCraft deserialize(CompoundNBT compound) {
        ArrayList<WorkbenchIngredient> desIngredients = new ArrayList<WorkbenchIngredient>();
        ResourceLocation desLocation = new ResourceLocation(compound.func_74779_i("location"));
        int iteration = 0;
        do {
            desIngredients.add(WorkbenchIngredient.deserialize((CompoundNBT)compound.func_74781_a("ingredient_" + iteration)));
        } while (compound.func_74764_b("ingredient_" + ++iteration));
        ItemStack desResult = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)compound.func_74781_a("result_stack")));
        int desType = compound.func_74762_e("type");
        WorkbenchCraft recipe = new WorkbenchCraft(desIngredients, desResult, desLocation);
        recipe.type = WorkbenchCraftType.values()[desType];
        return recipe;
    }

    public WorkbenchCraft copy() {
        ArrayList<WorkbenchIngredient> ingredients1 = new ArrayList<WorkbenchIngredient>(9999);
        for (WorkbenchIngredient ingredient : this.getIngredients()) {
            ingredients1.add(ingredient.copy());
        }
        return new WorkbenchCraft(ingredients1, this.result.func_77946_l(), this.resourceLocation);
    }
}

