/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.core.misc;

import com.bottomtextdanny.dannys_expansion.core.misc.WorkbenchCraft;
import com.bottomtextdanny.dannys_expansion.core.misc.WorkbenchCraftType;
import com.bottomtextdanny.dannys_expansion.core.misc.WorkbenchIngredient;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class WorkbenchRecipeManager
extends JsonReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public ArrayList<WorkbenchCraft> workbenchRecipes = new ArrayList(99999);

    public WorkbenchRecipeManager() {
        super(GSON, "workbench_recipes");
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        this.workbenchRecipes.clear();
        objectIn.forEach((id, element) -> {
            ArrayList<WorkbenchIngredient> ingredients = new ArrayList<WorkbenchIngredient>();
            JsonArray jsonIngredients = JSONUtils.func_151214_t((JsonObject)element.getAsJsonObject(), (String)"ingredients");
            jsonIngredients.forEach(jsonElement -> ingredients.add(WorkbenchRecipeManager.deserializeIngredient(jsonElement.getAsJsonObject())));
            JsonObject jsonResult = JSONUtils.func_152754_s((JsonObject)element.getAsJsonObject(), (String)"result");
            ItemStack itemStack = new ItemStack((IItemProvider)JSONUtils.func_188180_i((JsonObject)jsonResult, (String)"item"));
            itemStack.func_190920_e(JSONUtils.func_151203_m((JsonObject)jsonResult, (String)"count"));
            WorkbenchCraft recipe = new WorkbenchCraft((List<WorkbenchIngredient>)ingredients, itemStack, (ResourceLocation)id);
            recipe.type = WorkbenchCraftType.valueOf(JSONUtils.func_151200_h((JsonObject)element.getAsJsonObject(), (String)"type"));
            this.workbenchRecipes.add(recipe);
        });
        this.workbenchRecipes.sort(new Comparator<WorkbenchCraft>(){

            @Override
            public int compare(WorkbenchCraft t0, WorkbenchCraft t1) {
                if (t0.type.ordinal() == t1.type.ordinal()) {
                    return 0;
                }
                if (t0.type.ordinal() < t1.type.ordinal()) {
                    return -1;
                }
                return 1;
            }
        });
    }

    public static WorkbenchIngredient deserializeIngredient(JsonObject object) {
        String s = JSONUtils.func_151200_h((JsonObject)object, (String)"item");
        Item item = (Item)Registry.field_212630_s.func_241873_b(new ResourceLocation(s)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + s + "'"));
        if (object.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        int i = JSONUtils.func_151208_a((JsonObject)object, (String)"count", (int)1);
        return new WorkbenchIngredient(item, i);
    }

    public List<WorkbenchCraft> getWorkbenchRecipes() {
        return this.workbenchRecipes;
    }
}

