/*
 * Decompiled with CFR 0.152.
 */
package com.thenatekirby.babel.core;

import com.google.gson.JsonObject;
import com.thenatekirby.babel.util.ItemStackUtil;
import com.thenatekirby.babel.util.TagUtil;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class RecipeIngredient {
    private boolean isTag;
    private String resultId;
    private int count;

    private RecipeIngredient(boolean isTag, String resultId, int count) {
        this.isTag = isTag;
        this.resultId = resultId;
        this.count = count;
    }

    public static RecipeIngredient fromTag(@Nonnull String resultId) {
        return new RecipeIngredient(true, resultId, 1);
    }

    public static RecipeIngredient fromTag(@Nonnull String resultId, int count) {
        return new RecipeIngredient(true, resultId, count);
    }

    public static RecipeIngredient fromTag(@Nonnull ResourceLocation resultId) {
        return new RecipeIngredient(true, resultId.toString(), 1);
    }

    public static RecipeIngredient fromItem(@Nonnull String resultId) {
        return new RecipeIngredient(false, resultId, 1);
    }

    public static RecipeIngredient fromItem(@Nonnull String resultId, int count) {
        return new RecipeIngredient(false, resultId, count);
    }

    public static RecipeIngredient fromItem(@Nonnull ResourceLocation resultId) {
        return new RecipeIngredient(false, resultId.toString(), 1);
    }

    public static RecipeIngredient fromItem(@Nonnull IItemProvider item) {
        return new RecipeIngredient(false, item.func_199767_j().getRegistryName().toString(), 1);
    }

    public static RecipeIngredient fromItem(@Nonnull IItemProvider item, int count) {
        return new RecipeIngredient(false, item.func_199767_j().getRegistryName().toString(), count);
    }

    @Nonnull
    public JsonObject serializeJson() {
        JsonObject jsonObject = new JsonObject();
        if (this.isTag) {
            jsonObject.addProperty("tag", this.resultId.toString());
        } else {
            jsonObject.addProperty("item", this.resultId.toString());
        }
        if (this.count > 1) {
            jsonObject.addProperty("count", (Number)this.count);
        }
        return jsonObject;
    }

    @Nonnull
    public ItemStack makeItemStack() {
        ResourceLocation id = new ResourceLocation(this.resultId);
        if (this.isTag) {
            return TagUtil.firstItemInTag(id, this.count);
        }
        return ItemStackUtil.makeItemStack(id, this.count);
    }

    public void write(@Nonnull PacketBuffer buffer) {
        buffer.writeBoolean(this.isTag);
        buffer.func_180714_a(this.resultId);
        buffer.writeInt(this.count);
    }

    public static RecipeIngredient read(@Nonnull PacketBuffer buffer) {
        boolean isTag = buffer.readBoolean();
        String resultId = buffer.func_218666_n();
        int count = buffer.readInt();
        return new RecipeIngredient(isTag, resultId, count);
    }

    public Ingredient makeIngredient() {
        if (this.isTag) {
            return Ingredient.func_199805_a(TagUtil.getItemTag(new ResourceLocation(this.resultId)));
        }
        return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.resultId))});
    }
}

