/*
 * Decompiled with CFR 0.152.
 */
package com.thenatekirby.babel.core.inventory;

import com.thenatekirby.babel.core.slots.ItemSlot;
import com.thenatekirby.babel.util.ItemStackUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class BabelItemHandler
implements IItemHandler {
    @Nonnull
    private final List<ItemSlot> allSlots;

    public BabelItemHandler(@Nonnull List<ItemSlot> allSlots) {
        this.allSlots = allSlots;
    }

    public int getSlots() {
        return this.allSlots.size();
    }

    public ItemSlot getSlot(int slot) {
        return this.allSlots.get(slot);
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.getSlot(slot).getItemStack();
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (slot < 0 || slot > this.getSlots()) {
            return stack;
        }
        ItemStack insertStack = ItemStackUtil.itemStackWithSize(stack, stack.func_190916_E());
        for (ItemSlot itemSlot : this.allSlots) {
            insertStack = itemSlot.insertItem(0, insertStack, simulate);
            if (!insertStack.func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return insertStack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot < 0 || slot > this.getSlots()) {
            return ItemStack.field_190927_a;
        }
        return this.allSlots.get(slot).extractItem(0, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.getSlot(slot).getSlotLimit(0);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return this.getSlot(slot).isItemValid(0, stack);
    }

    @Nonnull
    public List<ItemSlot> getAllSlots() {
        return this.allSlots;
    }
}

