/*
 * Decompiled with CFR 0.152.
 */
package com.thenatekirby.babel.core.inventory;

import com.thenatekirby.babel.core.energy.BabelEnergyStorage;
import com.thenatekirby.babel.core.energy.EnergyBuffer;
import com.thenatekirby.babel.core.inventory.BabelItemHandler;
import com.thenatekirby.babel.core.inventory.InventoryItemHandler;
import com.thenatekirby.babel.core.inventory.SlotConfiguration;
import com.thenatekirby.babel.core.slots.ItemSlot;
import com.thenatekirby.babel.core.tileentity.BabelTileEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class ContainerInventory<T extends BabelTileEntity>
implements INBTSerializable<CompoundNBT>,
BabelEnergyStorage.IEnergyStorageChangedObserver,
ItemSlot.IOnSlotChangedListener {
    private final T tileEntity;
    private BabelEnergyStorage energyStorage = new BabelEnergyStorage(EnergyBuffer.ZERO);
    private InventoryItemHandler inputItemHandler;
    private InventoryItemHandler outputItemHandler;
    private InventoryItemHandler allItemHandler;
    private BabelItemHandler manualItemHandler;

    public ContainerInventory(T tileEntity) {
        this.tileEntity = tileEntity;
        this.setupHandlers();
    }

    public BabelEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public InventoryItemHandler getInputItemHandler() {
        return this.inputItemHandler;
    }

    public InventoryItemHandler getOutputItemHandler() {
        return this.outputItemHandler;
    }

    public InventoryItemHandler getAllItemHandler() {
        return this.allItemHandler;
    }

    public BabelItemHandler getManualItemHandler() {
        return this.manualItemHandler;
    }

    public abstract SlotConfiguration makeConfiguration();

    private void setupHandlers() {
        SlotConfiguration configuration = this.makeConfiguration();
        this.setupHandlers(configuration);
    }

    protected void setupHandlers(@Nonnull SlotConfiguration configuration) {
        List<ItemSlot> inputSlots = configuration.getInputItemSlots();
        List<ItemSlot> outputSlots = configuration.getOutputItemSlots();
        List<ItemSlot> auxSlots = configuration.getAuxilaryItemSlots();
        ArrayList<ItemSlot> allSlots = new ArrayList<ItemSlot>();
        allSlots.addAll(inputSlots);
        allSlots.addAll(outputSlots);
        allSlots.addAll(auxSlots);
        this.energyStorage = new BabelEnergyStorage(configuration.getEnergyBuffer());
        this.inputItemHandler = new InventoryItemHandler(this, inputSlots, Collections.emptyList(), Collections.emptyList());
        this.outputItemHandler = new InventoryItemHandler(this, Collections.emptyList(), outputSlots, Collections.emptyList());
        this.allItemHandler = new InventoryItemHandler(this, inputSlots, outputSlots, auxSlots);
        this.manualItemHandler = new BabelItemHandler(allSlots);
        for (ItemSlot slot : allSlots) {
            slot.setListener(this);
        }
    }

    public int getSlotCount() {
        return this.allItemHandler.getSlots();
    }

    public boolean canInsert(@Nonnull ItemStack itemStack) {
        for (ItemSlot itemSlot : this.inputItemHandler.getInputSlots()) {
            ItemStack result = itemSlot.insertItem(0, itemStack, true);
            if (result.func_190916_E() >= itemStack.func_190916_E()) continue;
            return true;
        }
        return false;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        if (this.energyStorage != null) {
            nbt.func_218657_a("energy", (INBT)this.energyStorage.serializeNBT());
        }
        if (this.allItemHandler != null) {
            nbt.func_218657_a("items", (INBT)this.allItemHandler.serializeNBT());
        }
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (this.energyStorage != null) {
            this.energyStorage.deserializeNBT(nbt.func_74775_l("energy"));
        }
        if (this.allItemHandler != null) {
            this.allItemHandler.deserializeNBT(nbt.func_74775_l("items"));
        }
    }

    @Override
    public void onEnergyChanged(BabelEnergyStorage storage) {
        this.tileEntity.func_70296_d();
    }

    @Override
    public void onSlotChanged(ItemSlot slot) {
        this.tileEntity.func_70296_d();
        ((BabelTileEntity)((Object)this.tileEntity)).markInventoryDirty();
    }
}

