/*
 * Decompiled with CFR 0.152.
 */
package com.thenatekirby.babel.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.thenatekirby.babel.core.RecipeIngredient;
import com.thenatekirby.babel.mod.BabelSerializers;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class TaggedShapelessCraftingRecipe
extends ShapelessRecipe {
    public static String RECIPE_TYPE_NAME = "crafting_shapeless";
    private final RecipeIngredient result;

    private TaggedShapelessCraftingRecipe(ResourceLocation recipeId, String group, RecipeIngredient result, NonNullList<Ingredient> ingredients) {
        super(recipeId, group, ItemStack.field_190927_a, ingredients);
        this.result = result;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return this.result.makeItemStack();
    }

    @Nonnull
    public ItemStack func_77572_b(CraftingInventory inv) {
        return this.func_77571_b().func_77946_l();
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return BabelSerializers.TAGGED_SHAPELESS.getAsRecipeSerializer();
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<TaggedShapelessCraftingRecipe> {
        @Nonnull
        public TaggedShapelessCraftingRecipe read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> ingredients = Serializer.readIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
            JsonObject resultJson = JSONUtils.func_152754_s((JsonObject)json, (String)"result");
            if (resultJson.has("tag")) {
                return new TaggedShapelessCraftingRecipe(recipeId, group, RecipeIngredient.fromTag(JSONUtils.func_151200_h((JsonObject)resultJson, (String)"tag")), ingredients);
            }
            return new TaggedShapelessCraftingRecipe(recipeId, group, RecipeIngredient.fromItem(JSONUtils.func_151200_h((JsonObject)resultJson, (String)"item")), ingredients);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
            NonNullList list = NonNullList.func_191196_a();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.func_199802_a((JsonElement)ingredientArray.get(i));
                if (ingredient.func_203189_d()) continue;
                list.add((Object)ingredient);
            }
            return list;
        }

        @Nullable
        public TaggedShapelessCraftingRecipe read(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
            String group = buffer.func_150789_c(Short.MAX_VALUE);
            int size = buffer.func_150792_a();
            NonNullList list = NonNullList.func_191197_a((int)size, (Object)Ingredient.field_193370_a);
            for (int idx = 0; idx < size; ++idx) {
                list.set(idx, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            RecipeIngredient result = RecipeIngredient.read(buffer);
            return new TaggedShapelessCraftingRecipe(recipeId, group, result, list);
        }

        public void write(@Nonnull PacketBuffer buffer, @Nonnull TaggedShapelessCraftingRecipe recipe) {
            buffer.func_180714_a(recipe.func_193358_e());
            buffer.func_150787_b(recipe.func_192400_c().size());
            for (Ingredient ingredient : recipe.func_192400_c()) {
                ingredient.func_199564_a(buffer);
            }
            recipe.result.write(buffer);
        }
    }
}

