/*
 * Decompiled with CFR 0.152.
 */
package com.teamaurora.bayou_blues.common.world.gen.feature;

import com.google.common.collect.Sets;
import com.minecraftabnormals.abnormals_core.core.util.TreeUtil;
import com.mojang.serialization.Codec;
import com.teamaurora.bayou_blues.common.util.DirectionalBlockPos;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.fluid.Fluids;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.Feature;

public class WaterCypressFeature
extends Feature<BaseTreeFeatureConfig> {
    public WaterCypressFeature(Codec<BaseTreeFeatureConfig> config) {
        super(config);
    }

    public boolean generate(ISeedReader worldIn, ChunkGenerator generator, Random rand, BlockPos posIn, BaseTreeFeatureConfig config) {
        int z;
        int x;
        int i;
        boolean bald;
        int height = rand.nextInt(5) + 12;
        boolean bl = bald = rand.nextInt(15) == 0;
        if (posIn.func_177956_o() <= 0 || posIn.func_177956_o() + height > worldIn.func_217301_I() - 1) {
            return false;
        }
        int surfaceY = worldIn.func_205770_a(Heightmap.Type.OCEAN_FLOOR, posIn).func_177956_o();
        int waterY = worldIn.func_205770_a(Heightmap.Type.WORLD_SURFACE, posIn).func_177956_o();
        if (waterY <= surfaceY) {
            return false;
        }
        BlockPos position = new BlockPos(posIn.func_177958_n(), waterY, posIn.func_177952_p());
        BlockPos bottom = new BlockPos(posIn.func_177958_n(), surfaceY, posIn.func_177952_p());
        if (!WaterCypressFeature.isAirOrWaterOrLeaves((IWorldGenerationBaseReader)worldIn, bottom)) {
            return false;
        }
        ArrayList<DirectionalBlockPos> logs = new ArrayList<DirectionalBlockPos>();
        ArrayList<BlockPos> leaves = new ArrayList<BlockPos>();
        for (i = 0; i <= waterY - surfaceY; ++i) {
            for (x = -1; x <= 1; ++x) {
                for (z = -1; z <= 1; ++z) {
                    if (i == 0 && worldIn.func_204610_c(bottom.func_177982_a(x, -1, z)).func_206886_c() == Fluids.field_204546_a) {
                        return false;
                    }
                    logs.add(new DirectionalBlockPos(bottom.func_177982_a(x, i, z), Direction.UP));
                }
            }
        }
        for (i = 1; i <= height; ++i) {
            if (i <= 2) {
                for (x = -1; x <= 1; ++x) {
                    for (z = -1; z <= 1; ++z) {
                        if (x != 0 && z != 0) continue;
                        logs.add(new DirectionalBlockPos(position.func_177982_a(x, i, z), Direction.UP));
                    }
                }
                continue;
            }
            logs.add(new DirectionalBlockPos(position.func_177981_b(i), Direction.UP));
        }
        int numBranches = rand.nextInt(4) + 1;
        if (numBranches == 4) {
            numBranches = 2;
        }
        for (int i2 = 0; i2 < numBranches; ++i2) {
            Direction dir = Direction.func_176731_b((int)rand.nextInt(4));
            int x2 = bald ? rand.nextInt(height - 3) + 6 : rand.nextInt(height - 5) + 6;
            logs.add(new DirectionalBlockPos(position.func_177981_b(x2).func_177972_a(dir), dir));
            logs.add(new DirectionalBlockPos(position.func_177981_b(x2).func_177967_a(dir, 2), dir));
            this.disc2H(position.func_177981_b(x2).func_177967_a(dir, 2), leaves, rand);
            this.disc1(position.func_177981_b(x2 + 1).func_177967_a(dir, 2), leaves);
        }
        if (!bald) {
            this.disc1(position.func_177981_b(height - 1), leaves);
            this.disc3H(position.func_177981_b(height), leaves, rand);
            this.disc2(position.func_177981_b(height + 1), leaves);
        }
        List<BlockPos> leavesClean = this.cleanLeavesArray(leaves, logs);
        boolean flag = true;
        for (DirectionalBlockPos log : logs) {
            if (WaterCypressFeature.isAirOrWaterOrLeaves((IWorldGenerationBaseReader)worldIn, log.pos)) continue;
            flag = false;
        }
        if (!flag) {
            return false;
        }
        TreeUtil.setDirtAt((IWorld)worldIn, (BlockPos)position.func_177977_b());
        for (DirectionalBlockPos log : logs) {
            TreeUtil.placeDirectionalLogAt((IWorldWriter)worldIn, (BlockPos)log.pos, (Direction)log.direction, (Random)rand, (BaseTreeFeatureConfig)config);
        }
        for (BlockPos leaf : leavesClean) {
            TreeUtil.placeLeafAt((IWorldGenerationReader)worldIn, (BlockPos)leaf, (Random)rand, (BaseTreeFeatureConfig)config);
        }
        HashSet decSet = Sets.newHashSet();
        MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_78887_a();
        ArrayList<BlockPos> logsPos = new ArrayList<BlockPos>();
        for (DirectionalBlockPos log : logs) {
            logsPos.add(log.pos);
        }
        if (!config.field_227370_o_.isEmpty()) {
            logsPos.sort(Comparator.comparingInt(Vector3i::func_177956_o));
            leavesClean.sort(Comparator.comparingInt(Vector3i::func_177956_o));
            config.field_227370_o_.forEach(decorator -> decorator.func_225576_a_(worldIn, rand, logsPos, leavesClean, decSet, mutableBoundingBox));
        }
        return true;
    }

    private void disc1(BlockPos pos, List<BlockPos> leaves) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (Math.abs(x) == 1 && Math.abs(z) == 1) continue;
                leaves.add(pos.func_177982_a(x, 0, z));
            }
        }
    }

    private void disc2(BlockPos pos, List<BlockPos> leaves) {
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                if (Math.abs(x) == 2 && Math.abs(z) == 2) continue;
                leaves.add(pos.func_177982_a(x, 0, z));
            }
        }
    }

    private void disc2H(BlockPos pos, List<BlockPos> leaves, Random rand) {
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                if (Math.abs(x) == 2 && Math.abs(z) == 2) continue;
                leaves.add(pos.func_177982_a(x, 0, z));
                if (rand.nextInt(3) != 0) continue;
                leaves.add(pos.func_177982_a(x, -1, z));
                if (rand.nextInt(3) != 0) continue;
                leaves.add(pos.func_177982_a(x, -2, z));
            }
        }
    }

    private void disc3H(BlockPos pos, List<BlockPos> leaves, Random rand) {
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                if (Math.abs(x) == 3 && Math.abs(z) == 3) continue;
                leaves.add(pos.func_177982_a(x, 0, z));
                if (rand.nextInt(3) != 0) continue;
                leaves.add(pos.func_177982_a(x, -1, z));
                if (!rand.nextBoolean()) continue;
                leaves.add(pos.func_177982_a(x, -2, z));
            }
        }
    }

    private List<BlockPos> cleanLeavesArray(List<BlockPos> leaves, List<DirectionalBlockPos> logs) {
        ArrayList<BlockPos> logsPos = new ArrayList<BlockPos>();
        for (DirectionalBlockPos log : logs) {
            logsPos.add(log.pos);
        }
        ArrayList<BlockPos> newLeaves = new ArrayList<BlockPos>();
        for (BlockPos leaf : leaves) {
            if (logsPos.contains(leaf)) continue;
            newLeaves.add(leaf);
        }
        return newLeaves;
    }

    public static boolean isAirOrWater(IWorldGenerationBaseReader world, BlockPos pos) {
        if (!(world instanceof IBlockReader)) {
            return world.func_217375_a(pos, AbstractBlock.AbstractBlockState::func_196958_f) || world.func_217375_a(pos, state -> state.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a));
        }
        return world.func_217375_a(pos, state -> state.isAir((IBlockReader)world, pos)) || world.func_217375_a(pos, state -> state.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a));
    }

    public static boolean isAirOrWaterOrLeaves(IWorldGenerationBaseReader world, BlockPos pos) {
        if (world instanceof IWorldReader) {
            return world.func_217375_a(pos, state -> state.canBeReplacedByLeaves((IWorldReader)world, pos)) || world.func_217375_a(pos, state -> state.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a));
        }
        return world.func_217375_a(pos, state -> WaterCypressFeature.isAirOrWater(world, pos) || state.func_235714_a_((ITag)BlockTags.field_206952_E));
    }
}

