/*
 * Decompiled with CFR 0.152.
 */
package com.teamaurora.bayou_blues.core;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class BayouBluesConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Integer> bayouWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> bayouHillsWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> lilyBonemealBehavior;
        public final ForgeConfigSpec.ConfigValue<Boolean> doLiliesSpawn;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Common configurations for Bayou Blues").push("common");
            builder.comment("Lily flower configuration").push("lily_flowers");
            this.lilyBonemealBehavior = builder.comment("Lily bonemeal behavior. 0=none. 1=bonemealing lily pad grows lily flowers. 2=bonemealing lily flower gives you more of it.").define("Lily bonemeal behavior", (Object)1);
            this.doLiliesSpawn = builder.define("Lily flower spawns in the world", true);
            builder.pop();
            builder.comment("Values for biome frequencies; lower = more rare. (Requires restart)").push("biome_weights");
            this.bayouWeight = builder.define("Bayou weight", (Object)1);
            this.bayouHillsWeight = builder.define("Bayou Hills weight", (Object)0);
            builder.pop();
            builder.pop();
        }
    }
}

