/*
 * Decompiled with CFR 0.152.
 */
package com.teamaurora.better_badlands.common.block;

import com.teamaurora.better_badlands.core.registry.BetterBadlandsParticles;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.TNTBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public interface IKindling {
    public static final IntegerProperty BURN_DISTANCE = IntegerProperty.func_177719_a((String)"burn_distance", (int)0, (int)21);
    public static final BooleanProperty IS_BURNED = BooleanProperty.func_177716_a((String)"burned");
    public static final int TO_SCHEDULE = 30;

    default public void onProjectileCollisionI(World worldIn, BlockState state, BlockRayTraceResult hit, ProjectileEntity projectile) {
        if (!worldIn.field_72995_K) {
            Entity entity = projectile.func_234616_v_();
            if (projectile.func_70027_ad()) {
                BlockPos blockpos = hit.func_216350_a();
                worldIn.func_175656_a(hit.func_216350_a(), (BlockState)state.func_206870_a((Property)this.getDistProperty(state), (Comparable)Integer.valueOf(1)));
            }
        }
    }

    default public void onBlockAddedI(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        boolean flag = false;
        for (Direction dir : Direction.values()) {
            if (worldIn.func_180495_p(pos.func_177972_a(dir)).func_177230_c() != Blocks.field_150353_l) continue;
            flag = true;
        }
        if (flag) {
            worldIn.func_175655_b(pos, false);
        } else {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)state.func_177230_c(), 30);
        }
    }

    default public void neighborChangedI(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag = false;
        boolean fireFlag = false;
        for (Direction dir : Direction.values()) {
            if (worldIn.func_180495_p(pos.func_177972_a(dir)).func_177230_c() == Blocks.field_150353_l) {
                flag = true;
                continue;
            }
            if (worldIn.func_180495_p(pos.func_177972_a(dir)).func_177230_c() != Blocks.field_150480_ab) continue;
            fireFlag = true;
        }
        if (flag) {
            worldIn.func_175655_b(pos, false);
        } else if (fireFlag) {
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)this.getDistProperty(state), (Comparable)Integer.valueOf(1)));
        }
    }

    default public int getDistFromBlockstate(BlockState state) {
        try {
            return (Integer)state.func_177229_b((Property)BURN_DISTANCE);
        }
        catch (IllegalArgumentException e) {
            return 0;
        }
    }

    default public IntegerProperty getDistProperty(BlockState state) {
        return BURN_DISTANCE;
    }

    default public void animateTickI(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (this.getDistFromBlockstate(stateIn) > 0) {
            for (int i = 0; i < 20; ++i) {
                double d3 = (double)pos.func_177958_n() + rand.nextDouble() + rand.nextDouble() / 6.0;
                double d8 = (double)pos.func_177956_o() + rand.nextDouble() + rand.nextDouble() / 6.0;
                double d13 = (double)pos.func_177952_p() + rand.nextDouble() + rand.nextDouble() / 6.0;
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d3, d8, d13, 0.0, 0.0, 0.0);
            }
            int b = rand.nextInt(35) + 5;
            for (int i = 0; i < b; ++i) {
                double d3 = (double)pos.func_177958_n() + rand.nextDouble() + rand.nextDouble() / 6.0;
                double d8 = (double)pos.func_177956_o() + rand.nextDouble() + rand.nextDouble() / 6.0;
                double d13 = (double)pos.func_177952_p() + rand.nextDouble() + rand.nextDouble() / 6.0;
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d3, d8, d13, 0.0, 0.0, 0.0);
            }
            if (rand.nextInt(64) == 0) {
                worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187643_bs, SoundCategory.BLOCKS, rand.nextFloat() * 0.25f + 0.75f, rand.nextFloat() + 0.5f, false);
            }
        }
    }

    public static int getEquation(int x) {
        int i = 8;
        return x * (x / 5) / (25 * i);
    }

    default public boolean getBurntFromblockstate(BlockState state) {
        try {
            return (Boolean)state.func_177229_b((Property)IS_BURNED);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    default public void tickI(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        int dist = this.getDistFromBlockstate(state);
        if (this.getBurntFromblockstate(state)) {
            VoxelShape shapeIn = state.func_196954_c((IBlockReader)worldIn, pos);
            double d3 = (double)pos.func_177958_n() + Math.min(shapeIn.func_197752_a().field_72336_d, rand.nextDouble()) * (double)0.1f;
            double d8 = (double)pos.func_177956_o() + Math.min(shapeIn.func_197752_a().field_72337_e, rand.nextDouble());
            double d13 = (double)pos.func_177952_p() + Math.min(shapeIn.func_197752_a().field_72334_f, rand.nextDouble());
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197594_E, d3, d8, d13, 0.0, 0.0, 0.0);
            worldIn.func_195598_a((IParticleData)ParticleTypes.field_197595_F, d3, d8, d13, rand.nextInt(5) + 1, (double)rand.nextFloat(), (double)rand.nextFloat(), (double)rand.nextFloat(), 0.0);
            worldIn.func_195598_a((IParticleData)((BasicParticleType)BetterBadlandsParticles.TWIG.get()), d3, d8, d13, rand.nextInt(10) + 5, (double)rand.nextFloat(), (double)rand.nextFloat(), (double)rand.nextFloat(), 0.0);
            worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            worldIn.func_184133_a(null, pos, SoundEvents.field_187658_bx, SoundCategory.PLAYERS, 1.0f, worldIn.field_73012_v.nextFloat() * 0.4f + 0.8f);
            for (Direction direction : Direction.values()) {
                BlockState stateo = worldIn.func_180495_p(pos.func_177972_a(direction));
                if (!stateo.func_177230_c().isFlammable(stateo, (IBlockReader)worldIn, pos, direction)) continue;
                stateo.func_177230_c().catchFire(stateo, (World)worldIn, pos, direction, null);
                worldIn.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
                if (!(stateo.func_177230_c() instanceof TNTBlock)) continue;
                worldIn.func_175656_a(pos.func_177972_a(direction), Blocks.field_150350_a.func_176223_P());
            }
            return;
        }
        if (dist > 0) {
            worldIn.func_184133_a(null, pos, SoundEvents.field_187643_bs, SoundCategory.PLAYERS, 1.0f, worldIn.field_73012_v.nextFloat() * 0.4f + 0.8f);
            if (dist < 21) {
                for (Direction dir : Direction.values()) {
                    BlockState stateo = worldIn.func_180495_p(pos.func_177972_a(dir));
                    if (stateo.func_177230_c() instanceof IKindling) {
                        if (this.getDistFromBlockstate(stateo) != 0) continue;
                        worldIn.func_175656_a(pos.func_177972_a(dir), (BlockState)stateo.func_206870_a((Property)this.getDistProperty(stateo), (Comparable)Integer.valueOf(dist + 1)));
                        worldIn.func_205220_G_().func_205360_a(pos.func_177972_a(dir), (Object)stateo.func_177230_c(), 30);
                        continue;
                    }
                    if (!(stateo.func_177230_c() instanceof TNTBlock)) continue;
                    stateo.func_177230_c().catchFire(stateo, (World)worldIn, pos.func_177972_a(dir), dir, null);
                    worldIn.func_175656_a(pos.func_177972_a(dir), Blocks.field_150350_a.func_176223_P());
                }
            }
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)IS_BURNED, (Comparable)Boolean.valueOf(true)));
            worldIn.func_205220_G_().func_205360_a(pos, (Object)state.func_177230_c(), IKindling.getEquation(dist));
        } else {
            boolean fireFlag = false;
            for (Direction dir : Direction.values()) {
                if (worldIn.func_180495_p(pos.func_177972_a(dir)).func_177230_c() != Blocks.field_150480_ab) continue;
                fireFlag = true;
            }
            if (fireFlag) {
                worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)this.getDistProperty(state), (Comparable)Integer.valueOf(1)));
            }
        }
    }

    default public ActionResultType onBlockActivatedI(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        Item item = player.func_184586_b(handIn).func_77973_b();
        if (item == Items.field_151033_d || item == Items.field_151059_bz) {
            worldIn.func_184133_a(null, pos, SoundEvents.field_187649_bu, SoundCategory.PLAYERS, 1.0f, worldIn.field_73012_v.nextFloat() * 0.4f + 0.8f);
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)this.getDistProperty(state), (Comparable)Integer.valueOf(1)));
            return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
        }
        return ActionResultType.PASS;
    }
}

