/*
 * Decompiled with CFR 0.152.
 */
package com.teamaurora.better_badlands.common.world.gen.feature;

import com.google.common.collect.Sets;
import com.minecraftabnormals.abnormals_core.core.util.TreeUtil;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Blocks;
import net.minecraft.block.SaplingBlock;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.Feature;

public class SmallDarkOakFeature
extends Feature<BaseTreeFeatureConfig> {
    public SmallDarkOakFeature(Codec<BaseTreeFeatureConfig> config) {
        super(config);
    }

    @ParametersAreNonnullByDefault
    public boolean generate(ISeedReader worldIn, ChunkGenerator generator, Random rand, BlockPos position, BaseTreeFeatureConfig config) {
        int height = rand.nextInt(3) + 3;
        int splitHeight = rand.nextInt(height - 2) + 2;
        int randDir = rand.nextInt(4);
        Direction direction = Direction.func_176731_b((int)randDir);
        if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 2 <= worldIn.func_217301_I()) {
            if (TreeUtil.isValidGround((IWorld)worldIn, (BlockPos)position.func_177977_b(), (SaplingBlock)((SaplingBlock)Blocks.field_196680_y))) {
                ArrayList<BlockPos> logs = new ArrayList<BlockPos>();
                ArrayList<BlockPos> leaves = new ArrayList<BlockPos>();
                for (BlockPos blockPos : BlockPos.func_218278_a((BlockPos)position, (BlockPos)position.func_177981_b(splitHeight))) {
                    logs.add(new BlockPos((Vector3i)blockPos));
                }
                for (BlockPos blockPos : BlockPos.func_218278_a((BlockPos)position.func_177972_a(direction).func_177981_b(splitHeight), (BlockPos)position.func_177972_a(direction).func_177981_b(height))) {
                    logs.add(new BlockPos((Vector3i)blockPos));
                }
                this.placeLeavesAt(leaves, position.func_177972_a(direction).func_177981_b(height), direction, rand);
                List<BlockPos> leavesClean = this.cleanLeavesArray(leaves, logs);
                boolean flag = true;
                for (BlockPos log : logs) {
                    if (TreeUtil.isAirOrLeaves((IWorldGenerationBaseReader)worldIn, (BlockPos)log)) continue;
                    flag = false;
                }
                if (!flag) {
                    return false;
                }
                TreeUtil.setDirtAt((IWorld)worldIn, (BlockPos)position.func_177977_b());
                for (BlockPos log : logs) {
                    TreeUtil.placeLogAt((IWorldWriter)worldIn, (BlockPos)log, (Random)rand, (BaseTreeFeatureConfig)config);
                }
                for (BlockPos leaf : leavesClean) {
                    TreeUtil.placeLeafAt((IWorldGenerationReader)worldIn, (BlockPos)leaf, (Random)rand, (BaseTreeFeatureConfig)config);
                }
                HashSet decSet = Sets.newHashSet();
                MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_78887_a();
                if (!config.field_227370_o_.isEmpty()) {
                    logs.sort(Comparator.comparingInt(Vector3i::func_177956_o));
                    leaves.sort(Comparator.comparingInt(Vector3i::func_177956_o));
                    config.field_227370_o_.forEach(decorator -> decorator.func_225576_a_(worldIn, rand, logs, leaves, decSet, mutableBoundingBox));
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void placeLeavesAt(List<BlockPos> leaf, BlockPos pos, Direction dir, Random rand) {
        for (BlockPos blockPos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-1, -1, -1), (BlockPos)pos.func_177982_a(1, 1, 1))) {
            leaf.add(new BlockPos((Vector3i)blockPos));
        }
        for (BlockPos blockPos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-2, 0, -1), (BlockPos)pos.func_177982_a(-2, 0, 1))) {
            leaf.add(new BlockPos((Vector3i)blockPos));
        }
        for (BlockPos blockPos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(2, 0, -1), (BlockPos)pos.func_177982_a(2, 0, 1))) {
            leaf.add(new BlockPos((Vector3i)blockPos));
        }
        for (BlockPos blockPos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-1, 0, -2), (BlockPos)pos.func_177982_a(1, 0, -2))) {
            leaf.add(new BlockPos((Vector3i)blockPos));
        }
        for (BlockPos blockPos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-1, 0, 2), (BlockPos)pos.func_177982_a(1, 0, 2))) {
            leaf.add(new BlockPos((Vector3i)blockPos));
        }
        leaf.add(pos.func_177982_a(-2, 1, 0));
        leaf.add(pos.func_177982_a(2, 1, 0));
        leaf.add(pos.func_177982_a(0, 1, -2));
        leaf.add(pos.func_177982_a(0, 1, 2));
        leaf.add(pos.func_177981_b(2));
        leaf.add(pos.func_177967_a(dir, 3));
        this.placeRandomLeafAt(pos.func_177981_b(2).func_177972_a(dir), rand, leaf);
        for (BlockPos blockPos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-1, 0, -1).func_177967_a(dir, 2), (BlockPos)pos.func_177982_a(1, 0, 1).func_177967_a(dir, 2))) {
            this.placeRandomLeafAt(new BlockPos((Vector3i)blockPos), rand, leaf);
        }
        this.placeRandomLeafAt(pos.func_177977_b().func_177967_a(dir, -2), rand, leaf);
    }

    private void placeRandomLeafAt(BlockPos pos, Random rand, List<BlockPos> leaf) {
        if (rand.nextBoolean()) {
            leaf.add(pos);
        }
    }

    private List<BlockPos> cleanLeavesArray(List<BlockPos> leaves, List<BlockPos> logs) {
        ArrayList<BlockPos> newLeaves = new ArrayList<BlockPos>();
        for (BlockPos leaf : leaves) {
            if (logs.contains(leaf)) continue;
            newLeaves.add(leaf);
        }
        return newLeaves;
    }
}

