/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.init;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.bettermineshafts.BetterMineshafts;
import com.yungnickyoung.minecraft.bettermineshafts.init.ModStructureFeatures;
import com.yungnickyoung.minecraft.bettermineshafts.init.ModStructurePieces;
import com.yungnickyoung.minecraft.bettermineshafts.world.BetterMineshaftStructure;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModStructures {
    public static final DeferredRegister<Structure<?>> DEFERRED_REGISTRY_STRUCTURE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"bettermineshafts");
    public static final RegistryObject<Structure<NoFeatureConfig>> MINESHAFT_STRUCTURE = DEFERRED_REGISTRY_STRUCTURE.register("mineshaft", () -> new BetterMineshaftStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));

    public static void init() {
        DEFERRED_REGISTRY_STRUCTURE.register(FMLJavaModLoadingContext.get().getModEventBus());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ModStructures::commonSetup);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, ModStructures::onBiomeLoad);
        MinecraftForge.EVENT_BUS.addListener(ModStructures::addDimensionalSpacing);
    }

    public static void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            Structure.field_236365_a_.put((Object)"Better Mineshaft".toLowerCase(Locale.ROOT), (Object)MINESHAFT_STRUCTURE.get());
            DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put((Object)MINESHAFT_STRUCTURE.get(), (Object)new StructureSeparationSettings(1, 0, 593751784)).build();
            Registry registry = WorldGenRegistries.field_243654_f;
            Registry.func_218322_a((Registry)registry, (ResourceLocation)new ResourceLocation("bettermineshafts", "mineshaft"), ModStructureFeatures.MINESHAFT_STRUCTURE_FEATURE);
            FlatGenerationSettings.field_202247_j.put(MINESHAFT_STRUCTURE.get(), ModStructureFeatures.MINESHAFT_STRUCTURE_FEATURE);
            ModStructurePieces.init();
            WorldGenRegistries.field_243658_j.func_239659_c_().forEach(settings -> {
                Map structureMap = ((DimensionSettings)settings.getValue()).func_236108_a_().func_236195_a_();
                if (structureMap instanceof ImmutableMap) {
                    HashMap<IForgeRegistryEntry, Object> tempMap = new HashMap<IForgeRegistryEntry, Object>(structureMap);
                    tempMap.put(MINESHAFT_STRUCTURE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)MINESHAFT_STRUCTURE.get()));
                    ((DimensionSettings)settings.getValue()).func_236108_a_().field_236193_d_ = tempMap;
                } else {
                    structureMap.put(MINESHAFT_STRUCTURE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)MINESHAFT_STRUCTURE.get()));
                }
            });
        });
    }

    public static void addDimensionalSpacing(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            try {
                Method getCodecMethod = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"func_230347_a_", (Class[])new Class[0]);
                ResourceLocation chunkGenResourceLocation = Registry.field_239690_aB_.func_177774_c((Object)((Codec)getCodecMethod.invoke((Object)serverWorld.func_72863_F().field_186029_c, new Object[0])));
                if (chunkGenResourceLocation != null && chunkGenResourceLocation.func_110624_b().equals("terraforged")) {
                    return;
                }
            }
            catch (Exception e) {
                BetterMineshafts.LOGGER.error("Was unable to check if " + serverWorld.func_234923_W_().func_240901_a_() + " is using Terraforged's ChunkGenerator.");
            }
            if (serverWorld.func_72863_F().func_201711_g() instanceof FlatChunkGenerator && serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
                return;
            }
            HashMap<IForgeRegistryEntry, Object> tempMap = new HashMap<IForgeRegistryEntry, Object>(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            tempMap.put(MINESHAFT_STRUCTURE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)MINESHAFT_STRUCTURE.get()));
            serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
        }
    }

    public static void onBiomeLoad(BiomeLoadingEvent event) {
        boolean found = false;
        for (Supplier supplier2 : event.getGeneration().getStructures()) {
            if (((StructureFeature)supplier2.get()).field_236268_b_ != Structure.field_236367_c_) continue;
            found = true;
            break;
        }
        if (!found) {
            return;
        }
        event.getGeneration().getStructures().removeIf(supplier -> ((StructureFeature)supplier.get()).field_236268_b_ == Structure.field_236367_c_);
        if (event.getCategory() == Biome.Category.OCEAN || event.getCategory() == Biome.Category.BEACH) {
            return;
        }
        event.getGeneration().getStructures().add(() -> ModStructureFeatures.MINESHAFT_STRUCTURE_FEATURE);
    }
}

