/*
 * Decompiled with CFR 0.152.
 */
package com.tome.bettershields;

import com.tome.bettershields.BetterShieldItem;
import com.tome.bettershields.Config;
import com.tome.bettershields.ShieldRecipes;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="bettershields")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class BetterShields {
    public static final String MODID = "bettershields";
    public static BetterShieldItem ironShield;
    public static BetterShieldItem goldShield;
    public static BetterShieldItem diamondShield;
    public static BetterShieldItem netheriteShield;

    public BetterShields() {
        new Config();
        ironShield = new BetterShieldItem("iron_shield", () -> (Integer)Config.ironDamageReduction.get(), (ITag<Item>)Tags.Items.INGOTS_IRON, (int)((Integer)Config.ironDurability.get()), false);
        goldShield = new BetterShieldItem("gold_shield", () -> (Integer)Config.goldDamageReduction.get(), (ITag<Item>)Tags.Items.INGOTS_GOLD, (int)((Integer)Config.goldDurability.get()), false);
        diamondShield = new BetterShieldItem("diamond_shield", () -> (Integer)Config.diamondDamageReduction.get(), (ITag<Item>)Tags.Items.GEMS_DIAMOND, (int)((Integer)Config.diamondDurability.get()), false);
        netheriteShield = new BetterShieldItem("netherite_shield", () -> (Integer)Config.netheriteDamageReduction.get(), (ITag<Item>)Tags.Items.INGOTS_NETHERITE, (int)((Integer)Config.netheriteDurability.get()), true);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> e) {
        IForgeRegistry registry = e.getRegistry();
        registry.registerAll((IForgeRegistryEntry[])new Item[]{ironShield, goldShield, diamondShield, netheriteShield});
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipeSerializer<?>> e) {
        IForgeRegistry registry = e.getRegistry();
        registry.register(ShieldRecipes.SERIALIZER.setRegistryName(new ResourceLocation(MODID, "shield_decoration")));
    }

    public static ITextComponent getBlockingTextComponent() {
        return new TranslationTextComponent("bettershields.shield_blocking").func_240699_a_(TextFormatting.GRAY);
    }

    public static ITextComponent getDamageReductionTextComponent(int reduction) {
        return new TranslationTextComponent("bettershields.shield_damage_reduction", new Object[]{reduction}).func_240699_a_(TextFormatting.DARK_GREEN);
    }
}

