/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.client.hud.element;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.client.Sprite;
import wayoftime.bloodmagic.client.hud.element.HUDElement;

public abstract class ElementTileInformation<T extends TileEntity>
extends HUDElement {
    protected final Class<T> tileClass;
    private final List<Pair<Sprite, Function<T, String>>> information;

    public ElementTileInformation(int width, int lines, Class<T> tileClass) {
        super(width, 18 * lines - 2);
        this.tileClass = tileClass;
        this.information = Lists.newArrayList();
        this.gatherInformation(this.information::add);
    }

    public abstract void gatherInformation(Consumer<Pair<Sprite, Function<T, String>>> var1);

    @Override
    public void draw(MatrixStack matrixStack, float partialTicks, int drawX, int drawY) {
        RayTraceResult trace = Minecraft.func_71410_x().field_71476_x;
        if (trace == null || trace.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return;
        }
        TileEntity tile = Minecraft.func_71410_x().field_71441_e.func_175625_s(((BlockRayTraceResult)trace).func_216350_a());
        int yOffset = 0;
        for (Pair<Sprite, Function<T, String>> sprite : this.information) {
            ((Sprite)sprite.getLeft()).draw(matrixStack, drawX, drawY + yOffset);
            int textY = drawY + yOffset + ((Sprite)sprite.getLeft()).getTextureHeight() / 4;
            Minecraft.func_71410_x().field_71466_p.func_238405_a_(matrixStack, tile != null && tile.getClass() == this.tileClass ? (String)((Function)sprite.getRight()).apply(tile) : "?", (float)(drawX + ((Sprite)sprite.getLeft()).getTextureWidth() + 2), (float)textY, Color.WHITE.getRGB());
            yOffset += ((Sprite)sprite.getLeft()).getTextureHeight() + 2;
        }
    }

    @Override
    public boolean shouldRender(Minecraft minecraft) {
        RayTraceResult trace = Minecraft.func_71410_x().field_71476_x;
        if (trace == null || trace.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return false;
        }
        TileEntity tile = Minecraft.func_71410_x().field_71441_e.func_175625_s(((BlockRayTraceResult)trace).func_216350_a());
        return tile != null && this.tileClass.isAssignableFrom(tile.getClass());
    }
}

