/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import wayoftime.bloodmagic.ConfigManager;
import wayoftime.bloodmagic.common.routing.INodeRenderer;
import wayoftime.bloodmagic.tile.routing.TileRoutingNode;

public class RenderItemRoutingNode
extends TileEntityRenderer<TileRoutingNode> {
    private static final ResourceLocation beamTexture = new ResourceLocation("bloodmagic", "textures/entities/nodebeam.png");
    private static final Minecraft mc = Minecraft.func_71410_x();

    public RenderItemRoutingNode(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TileRoutingNode tileNode, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderer, int combinedLightIn, int combinedOverlayIn) {
        if (RenderItemRoutingNode.mc.field_71439_g.func_184614_ca().func_77973_b() instanceof INodeRenderer || ((Boolean)ConfigManager.CLIENT.alwaysRenderRoutingLines.get()).booleanValue()) {
            List<BlockPos> connectionList = tileNode.getConnected();
            BlockPos masterPos = tileNode.getMasterPos();
            for (BlockPos wantedPos : connectionList) {
                boolean doRender;
                BlockPos offsetPos = wantedPos.func_177973_b((Vector3i)tileNode.func_174877_v());
                int xd = offsetPos.func_177958_n();
                int yd = offsetPos.func_177956_o();
                int zd = offsetPos.func_177952_p();
                boolean bl = doRender = wantedPos.equals((Object)masterPos) || xd > 0 || xd == 0 && zd > 0 || zd == 0 && yd > 0;
                if (!doRender) continue;
                double distance = Math.sqrt(xd * xd + yd * yd + zd * zd);
                double subLength = MathHelper.func_76129_c((float)(xd * xd + zd * zd));
                float rotYaw = -((float)(Math.atan2(xd, zd) * 180.0 / Math.PI));
                float rotPitch = (float)(Math.atan2(yd, subLength) * 180.0 / Math.PI);
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(0.5, 0.5, 0.5);
                matrixStack.func_227863_a_(new Quaternion(Direction.UP.func_229386_k_(), -rotYaw, true));
                matrixStack.func_227863_a_(new Quaternion(Direction.WEST.func_229386_k_(), rotPitch - 90.0f, true));
                matrixStack.func_227860_a_();
                long i = tileNode.func_145831_w().func_82737_E();
                boolean j = false;
                float[] colors = new float[]{0.0f, 1.0f, 1.0f};
                float height = (float)distance;
                RenderItemRoutingNode.renderBeamSegment(matrixStack, renderer, partialTicks, i, (float)j, height, colors);
                matrixStack.func_227865_b_();
                matrixStack.func_227865_b_();
            }
        }
    }

    private static void renderBeamSegment(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, float partialTicks, long totalWorldTime, float yOffset, float height, float[] colors) {
        RenderItemRoutingNode.renderBeamSegment(matrixStackIn, bufferIn, beamTexture, partialTicks, 1.0f, totalWorldTime, yOffset, height, colors, 0.06f, 0.1f);
    }

    public static void renderBeamSegment(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, ResourceLocation textureLocation, float partialTicks, float textureScale, long totalWorldTime, float yOffset, float height, float[] colors, float beamRadius, float glowRadius) {
        float i = yOffset + height;
        matrixStackIn.func_227860_a_();
        float f = (float)Math.floorMod(totalWorldTime, 40L) + partialTicks;
        float f1 = height < 0.0f ? f : -f;
        float f2 = MathHelper.func_226164_h_((float)(f1 * 0.2f - (float)MathHelper.func_76141_d((float)(f1 * 0.1f))));
        float f3 = colors[0];
        float f4 = colors[1];
        float f5 = colors[2];
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f * 2.25f - 45.0f));
        float f6 = 0.0f;
        float f8 = 0.0f;
        float f9 = -beamRadius;
        float f10 = 0.0f;
        float f11 = 0.0f;
        float f12 = -beamRadius;
        float f13 = 0.0f;
        float f14 = 1.0f;
        float f15 = -1.0f + f2;
        float f16 = height * textureScale * (0.5f / beamRadius) + f15;
        RenderItemRoutingNode.renderPart(matrixStackIn, bufferIn.getBuffer(RenderType.func_228637_a_((ResourceLocation)textureLocation, (boolean)false)), f3, f4, f5, 1.0f, yOffset, i, 0.0f, beamRadius, beamRadius, 0.0f, f9, 0.0f, 0.0f, f12, 0.0f, 1.0f, f16, f15);
        matrixStackIn.func_227865_b_();
        f6 = -glowRadius;
        float f7 = -glowRadius;
        f8 = -glowRadius;
        f9 = -glowRadius;
        f13 = 0.0f;
        f14 = 1.0f;
        f15 = -1.0f + f2;
        f16 = height * textureScale + f15;
        RenderItemRoutingNode.renderPart(matrixStackIn, bufferIn.getBuffer(RenderType.func_228637_a_((ResourceLocation)textureLocation, (boolean)true)), f3, f4, f5, 0.125f, yOffset, i, f6, f7, glowRadius, f8, f9, glowRadius, glowRadius, glowRadius, 0.0f, 1.0f, f16, f15);
        matrixStackIn.func_227865_b_();
    }

    private static void renderPart(MatrixStack matrixStackIn, IVertexBuilder bufferIn, float red, float green, float blue, float alpha, float yMin, float yMax, float p_228840_8_, float p_228840_9_, float p_228840_10_, float p_228840_11_, float p_228840_12_, float p_228840_13_, float p_228840_14_, float p_228840_15_, float u1, float u2, float v1, float v2) {
        MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
        Matrix4f matrix4f = matrixstack$entry.func_227870_a_();
        Matrix3f matrix3f = matrixstack$entry.func_227872_b_();
        RenderItemRoutingNode.addQuad(matrix4f, matrix3f, bufferIn, red, green, blue, alpha, yMin, yMax, p_228840_8_, p_228840_9_, p_228840_10_, p_228840_11_, u1, u2, v1, v2);
        RenderItemRoutingNode.addQuad(matrix4f, matrix3f, bufferIn, red, green, blue, alpha, yMin, yMax, p_228840_14_, p_228840_15_, p_228840_12_, p_228840_13_, u1, u2, v1, v2);
        RenderItemRoutingNode.addQuad(matrix4f, matrix3f, bufferIn, red, green, blue, alpha, yMin, yMax, p_228840_10_, p_228840_11_, p_228840_14_, p_228840_15_, u1, u2, v1, v2);
        RenderItemRoutingNode.addQuad(matrix4f, matrix3f, bufferIn, red, green, blue, alpha, yMin, yMax, p_228840_12_, p_228840_13_, p_228840_8_, p_228840_9_, u1, u2, v1, v2);
    }

    private static void addQuad(Matrix4f matrixPos, Matrix3f matrixNormal, IVertexBuilder bufferIn, float red, float green, float blue, float alpha, float yMin, float yMax, float x1, float z1, float x2, float z2, float u1, float u2, float v1, float v2) {
        RenderItemRoutingNode.addVertex(matrixPos, matrixNormal, bufferIn, red, green, blue, alpha, yMax, x1, z1, u2, v1);
        RenderItemRoutingNode.addVertex(matrixPos, matrixNormal, bufferIn, red, green, blue, alpha, yMin, x1, z1, u2, v2);
        RenderItemRoutingNode.addVertex(matrixPos, matrixNormal, bufferIn, red, green, blue, alpha, yMin, x2, z2, u1, v2);
        RenderItemRoutingNode.addVertex(matrixPos, matrixNormal, bufferIn, red, green, blue, alpha, yMax, x2, z2, u1, v1);
    }

    private static void addVertex(Matrix4f matrixPos, Matrix3f matrixNormal, IVertexBuilder bufferIn, float red, float green, float blue, float alpha, float y, float x, float z, float texU, float texV) {
        bufferIn.func_227888_a_(matrixPos, x, y, z).func_227885_a_(red, green, blue, alpha).func_225583_a_(texU, texV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(matrixNormal, 0.0f, 1.0f, 0.0f).func_181675_d();
    }

    public boolean isGlobalRenderer(TileRoutingNode te) {
        return true;
    }
}

