/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item;

import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.item.IBindable;
import wayoftime.bloodmagic.core.data.Binding;

public class ItemActivationCrystal
extends Item
implements IBindable {
    final CrystalType type;

    public ItemActivationCrystal(CrystalType type) {
        super(new Item.Properties().func_200917_a(1).func_200916_a(BloodMagic.TAB));
        this.type = type;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.activationcrystal." + this.type.name().toLowerCase(Locale.ROOT)).func_240699_a_(TextFormatting.GRAY));
        if (!stack.func_77942_o()) {
            return;
        }
        Binding binding = this.getBinding(stack);
        if (binding != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.currentOwner", new Object[]{binding.getOwnerName()}).func_240699_a_(TextFormatting.GRAY));
        }
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public int getCrystalLevel(ItemStack stack) {
        return this.type.equals((Object)CrystalType.CREATIVE) ? Integer.MAX_VALUE : this.type.ordinal() + 1;
    }

    public static enum CrystalType {
        WEAK,
        AWAKENED,
        CREATIVE;


        @Nonnull
        public static ItemStack getStack(int level) {
            if (level < 0) {
                level = 0;
            }
            switch (level) {
                case 0: {
                    return new ItemStack((IItemProvider)BloodMagicItems.WEAK_ACTIVATION_CRYSTAL.get());
                }
                case 1: {
                    return new ItemStack((IItemProvider)BloodMagicItems.AWAKENED_ACTIVATION_CRYSTAL.get());
                }
            }
            return new ItemStack((IItemProvider)BloodMagicItems.CREATIVE_ACTIVATION_CRYSTAL.get());
        }
    }
}

