/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.potion.BloodMagicPotions;
import wayoftime.bloodmagic.recipe.flask.RecipePotionTransform;

public class PotionTransformRecipeSerializer<RECIPE extends RecipePotionTransform>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;

    public PotionTransformRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @Nonnull
    public RECIPE read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        ArrayList<Ingredient> inputList = new ArrayList<Ingredient>();
        if (json.has("input") && JSONUtils.func_151202_d((JsonObject)json, (String)"input")) {
            JsonArray mainArray = JSONUtils.func_151214_t((JsonObject)json, (String)"input");
            for (Object element : mainArray) {
                if (inputList.size() >= 5) break;
                if (element.isJsonArray()) {
                    element = element.getAsJsonArray();
                } else {
                    element.getAsJsonObject();
                }
                inputList.add(Ingredient.func_199802_a((JsonElement)element));
            }
        }
        ArrayList<Pair<Effect, Integer>> outputEffectList = new ArrayList<Pair<Effect, Integer>>();
        if (json.has("outputEffect") && JSONUtils.func_151202_d((JsonObject)json, (String)"outputEffect")) {
            JsonArray mainArray = JSONUtils.func_151214_t((JsonObject)json, (String)"outputEffect");
            for (Object element : mainArray) {
                JsonObject obj = element.getAsJsonObject();
                Effect outputEffect = BloodMagicPotions.getEffect(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)obj, (String)"effect")));
                int baseDuration = JSONUtils.func_151203_m((JsonObject)obj, (String)"baseDuration");
                outputEffectList.add((Pair<Effect, Integer>)Pair.of((Object)outputEffect, (Object)baseDuration));
            }
        }
        ArrayList<Effect> inputEffectList = new ArrayList<Effect>();
        if (json.has("inputEffect") && JSONUtils.func_151202_d((JsonObject)json, (String)"inputEffect")) {
            JsonArray mainArray = JSONUtils.func_151214_t((JsonObject)json, (String)"inputEffect");
            for (JsonElement element : mainArray) {
                Effect inputEffect = BloodMagicPotions.getEffect(new ResourceLocation(JSONUtils.func_151206_a((JsonElement)element, (String)"effect")));
                inputEffectList.add(inputEffect);
            }
        }
        int syphon = JSONUtils.func_151203_m((JsonObject)json, (String)"syphon");
        int ticks = JSONUtils.func_151203_m((JsonObject)json, (String)"ticks");
        int minimumTier = JSONUtils.func_151203_m((JsonObject)json, (String)"upgradeLevel");
        return this.factory.create(recipeId, inputList, outputEffectList, inputEffectList, syphon, ticks, minimumTier);
    }

    public RECIPE read(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
        int size = buffer.readInt();
        ArrayList<Ingredient> input = new ArrayList<Ingredient>(size);
        for (int i = 0; i < size; ++i) {
            input.add(i, Ingredient.func_199566_b((PacketBuffer)buffer));
        }
        int syphon = buffer.readInt();
        int ticks = buffer.readInt();
        int minimumTier = buffer.readInt();
        int outputEffectSize = buffer.readInt();
        ArrayList<Pair<Effect, Integer>> outputEffectList = new ArrayList<Pair<Effect, Integer>>(outputEffectSize);
        for (int i = 0; i < outputEffectSize; ++i) {
            int effectId = buffer.readInt();
            outputEffectList.add(i, Pair.of((Object)Effect.func_188412_a((int)effectId), (Object)buffer.readInt()));
        }
        int inputEffectSize = buffer.readInt();
        ArrayList<Effect> inputEffectList = new ArrayList<Effect>();
        for (int i = 0; i < inputEffectSize; ++i) {
            inputEffectList.add(i, Effect.func_188412_a((int)buffer.readInt()));
        }
        return this.factory.create(recipeId, input, outputEffectList, inputEffectList, syphon, ticks, minimumTier);
    }

    public void write(@Nonnull PacketBuffer buffer, @Nonnull RECIPE recipe) {
        ((RecipePotionTransform)recipe).write(buffer);
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends RecipePotionTransform> {
        public RECIPE create(ResourceLocation var1, List<Ingredient> var2, List<Pair<Effect, Integer>> var3, List<Effect> var4, int var5, int var6, int var7);
    }
}

