/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.common.recipe.BloodMagicRecipeType;
import wayoftime.bloodmagic.recipe.EffectHolder;
import wayoftime.bloodmagic.recipe.RecipeARC;
import wayoftime.bloodmagic.recipe.RecipeAlchemyArray;
import wayoftime.bloodmagic.recipe.RecipeAlchemyTable;
import wayoftime.bloodmagic.recipe.RecipeBloodAltar;
import wayoftime.bloodmagic.recipe.RecipeLivingDowngrade;
import wayoftime.bloodmagic.recipe.RecipeMeteor;
import wayoftime.bloodmagic.recipe.RecipeTartaricForge;
import wayoftime.bloodmagic.recipe.flask.RecipePotionFlaskBase;

public class BloodMagicRecipeRegistrar {
    @Nullable
    public RecipeBloodAltar getBloodAltar(World world, @Nonnull ItemStack input) {
        Preconditions.checkNotNull((Object)input, (Object)"input cannot be null.");
        if (input.func_190926_b()) {
            return null;
        }
        List altarRecipes = world.func_199532_z().func_241447_a_(BloodMagicRecipeType.ALTAR);
        for (RecipeBloodAltar recipe : altarRecipes) {
            if (!recipe.getInput().test(input)) continue;
            return recipe;
        }
        return null;
    }

    public RecipeARC getARC(World world, @Nonnull ItemStack input, @Nonnull ItemStack arcToolInput, @Nonnull FluidStack inputFluid) {
        Preconditions.checkNotNull((Object)input, (Object)"input cannot be null.");
        Preconditions.checkNotNull((Object)arcToolInput, (Object)"tool cannot be null.");
        if (input.func_190926_b() || arcToolInput.func_190926_b()) {
            return null;
        }
        List arcRecipes = world.func_199532_z().func_241447_a_(BloodMagicRecipeType.ARC);
        for (RecipeARC recipe : arcRecipes) {
            if (!recipe.getInput().test(input) || !recipe.getTool().test(arcToolInput)) continue;
            if (recipe.getFluidIngredient() == null) {
                return recipe;
            }
            if (!recipe.getFluidIngredient().test(inputFluid)) continue;
            return recipe;
        }
        return null;
    }

    @Nullable
    public RecipeAlchemyTable getAlchemyTable(World world, @Nonnull List<ItemStack> input) {
        Preconditions.checkNotNull(input, (Object)"input cannot be null.");
        if (input.isEmpty()) {
            return null;
        }
        List tartaricForgeRecipes = world.func_199532_z().func_241447_a_(BloodMagicRecipeType.ALCHEMYTABLE);
        block0: for (RecipeAlchemyTable recipe : tartaricForgeRecipes) {
            if (recipe.getInput().size() != input.size()) continue;
            ArrayList<Ingredient> recipeInput = new ArrayList<Ingredient>(recipe.getInput());
            for (int i = 0; i < input.size(); ++i) {
                boolean matched = false;
                for (int j = 0; j < recipeInput.size(); ++j) {
                    Ingredient ingredient = (Ingredient)recipeInput.get(j);
                    if (!ingredient.test(input.get(i))) continue;
                    matched = true;
                    recipeInput.remove(j);
                    break;
                }
                if (!matched) continue block0;
            }
            return recipe;
        }
        return null;
    }

    @Nullable
    public RecipeMeteor getMeteor(World world, @Nonnull ItemStack input) {
        Preconditions.checkNotNull((Object)input, (Object)"input cannot be null.");
        if (input.func_190926_b()) {
            return null;
        }
        List meteorRecipes = world.func_199532_z().func_241447_a_(BloodMagicRecipeType.METEOR);
        for (RecipeMeteor recipe : meteorRecipes) {
            if (!recipe.getInput().test(input)) continue;
            return recipe;
        }
        return null;
    }

    @Nullable
    public RecipePotionFlaskBase getPotionFlaskRecipe(World world, @Nonnull List<EffectHolder> holderList, @Nonnull List<ItemStack> input) {
        Preconditions.checkNotNull(input, (Object)"input cannot be null.");
        if (input.isEmpty()) {
            return null;
        }
        List potionRecipes = world.func_199532_z().func_241447_a_(BloodMagicRecipeType.POTIONFLASK);
        RecipePotionFlaskBase validRecipe = null;
        int recipePriority = Integer.MIN_VALUE;
        block0: for (RecipePotionFlaskBase recipe : potionRecipes) {
            int prio;
            if (recipe.getInput().size() != input.size()) continue;
            ArrayList<Ingredient> recipeInput = new ArrayList<Ingredient>(recipe.getInput());
            for (int i = 0; i < input.size(); ++i) {
                boolean matched = false;
                for (int j = 0; j < recipeInput.size(); ++j) {
                    Ingredient ingredient = (Ingredient)recipeInput.get(j);
                    if (!ingredient.test(input.get(i))) continue;
                    matched = true;
                    recipeInput.remove(j);
                    break;
                }
                if (!matched) continue block0;
            }
            if (!recipe.canModifyFlask(holderList) || (prio = recipe.getPriority(holderList)) <= recipePriority) continue;
            validRecipe = recipe;
            recipePriority = prio;
        }
        return validRecipe;
    }

    @Nullable
    public RecipeTartaricForge getTartaricForge(World world, @Nonnull List<ItemStack> input) {
        Preconditions.checkNotNull(input, (Object)"input cannot be null.");
        if (input.isEmpty()) {
            return null;
        }
        List tartaricForgeRecipes = world.func_199532_z().func_241447_a_(BloodMagicRecipeType.TARTARICFORGE);
        block0: for (RecipeTartaricForge recipe : tartaricForgeRecipes) {
            if (recipe.getInput().size() != input.size()) continue;
            ArrayList<Ingredient> recipeInput = new ArrayList<Ingredient>(recipe.getInput());
            for (int i = 0; i < input.size(); ++i) {
                boolean matched = false;
                for (int j = 0; j < recipeInput.size(); ++j) {
                    Ingredient ingredient = (Ingredient)recipeInput.get(j);
                    if (!ingredient.test(input.get(i))) continue;
                    matched = true;
                    recipeInput.remove(j);
                    break;
                }
                if (!matched) continue block0;
            }
            return recipe;
        }
        return null;
    }

    @Nullable
    public Pair<Boolean, RecipeAlchemyArray> getAlchemyArray(World world, @Nonnull ItemStack input, @Nonnull ItemStack catalyst) {
        Preconditions.checkNotNull((Object)input, (Object)"input cannot be null.");
        if (input.func_190926_b()) {
            return null;
        }
        List altarRecipes = world.func_199532_z().func_241447_a_(BloodMagicRecipeType.ARRAY);
        RecipeAlchemyArray partialMatch = null;
        for (RecipeAlchemyArray recipe : altarRecipes) {
            if (!recipe.getBaseInput().test(input)) continue;
            if (recipe.getAddedInput().test(catalyst)) {
                return Pair.of((Object)true, (Object)recipe);
            }
            if (partialMatch != null) continue;
            partialMatch = recipe;
        }
        return Pair.of((Object)false, partialMatch);
    }

    @Nullable
    public RecipeLivingDowngrade getLivingDowngrade(World world, @Nonnull ItemStack input) {
        Preconditions.checkNotNull((Object)input, (Object)"input cannot be null.");
        if (input.func_190926_b()) {
            return null;
        }
        List downgradeRecipes = world.func_199532_z().func_241447_a_(BloodMagicRecipeType.LIVINGDOWNGRADE);
        for (RecipeLivingDowngrade recipe : downgradeRecipes) {
            if (!recipe.getInput().test(input)) continue;
            return recipe;
        }
        return null;
    }

    public Set<RecipeBloodAltar> getAltarRecipes(World world) {
        return ImmutableSet.copyOf((Collection)world.func_199532_z().func_241447_a_(BloodMagicRecipeType.ALTAR));
    }

    public Set<RecipeTartaricForge> getTartaricForgeRecipes(World world) {
        return ImmutableSet.copyOf((Collection)world.func_199532_z().func_241447_a_(BloodMagicRecipeType.TARTARICFORGE));
    }

    public Set<RecipeAlchemyArray> getAlchemyArrayRecipes(World world) {
        return ImmutableSet.copyOf((Collection)world.func_199532_z().func_241447_a_(BloodMagicRecipeType.ARRAY));
    }

    public Set<RecipeARC> getARCRecipes(World world) {
        return ImmutableSet.copyOf((Collection)world.func_199532_z().func_241447_a_(BloodMagicRecipeType.ARC));
    }

    public Set<RecipeAlchemyTable> getAlchemyTableRecipes(World world) {
        return ImmutableSet.copyOf((Collection)world.func_199532_z().func_241447_a_(BloodMagicRecipeType.ALCHEMYTABLE));
    }

    public Set<RecipePotionFlaskBase> getPotionFlaskRecipes(World world) {
        return ImmutableSet.copyOf((Collection)world.func_199532_z().func_241447_a_(BloodMagicRecipeType.POTIONFLASK));
    }

    public Set<RecipeAlchemyArray> getCraftingAlchemyArrayRecipes(World world) {
        HashSet recipes = new HashSet(world.func_199532_z().func_241447_a_(BloodMagicRecipeType.ARRAY));
        HashSet<RecipeAlchemyArray> copyRecipes = new HashSet<RecipeAlchemyArray>();
        for (RecipeAlchemyArray recipe : recipes) {
            if (recipe.getOutput().func_190926_b()) continue;
            copyRecipes.add(recipe);
        }
        return copyRecipes;
    }
}

