/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.network;

import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import wayoftime.bloodmagic.tile.routing.TileFilteredRoutingNode;

public class ItemRoutingNodeButtonPacket {
    private BlockPos pos;
    private int buttonPress;

    public ItemRoutingNodeButtonPacket() {
        this(BlockPos.field_177992_a, 0);
    }

    public ItemRoutingNodeButtonPacket(BlockPos pos, int buttonPress) {
        this.pos = pos;
        this.buttonPress = buttonPress;
    }

    public static void encode(ItemRoutingNodeButtonPacket pkt, PacketBuffer buf) {
        buf.func_179255_a(pkt.pos);
        buf.writeInt(pkt.buttonPress);
    }

    public static ItemRoutingNodeButtonPacket decode(PacketBuffer buf) {
        ItemRoutingNodeButtonPacket pkt = new ItemRoutingNodeButtonPacket(buf.func_179259_c(), buf.readInt());
        return pkt;
    }

    public static void handle(ItemRoutingNodeButtonPacket message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null || player.field_70170_p.field_72995_K) {
                return;
            }
            TileEntity tile = player.func_130014_f_().func_175625_s(message.pos);
            if (tile instanceof TileFilteredRoutingNode) {
                int buttonPress = message.buttonPress;
                if (buttonPress >= 6) {
                    if (buttonPress == 6) {
                        ((TileFilteredRoutingNode)tile).incrementCurrentPriotiryToMaximum(9);
                    } else if (buttonPress == 7) {
                        ((TileFilteredRoutingNode)tile).decrementCurrentPriority();
                    }
                } else {
                    ((TileFilteredRoutingNode)tile).swapFilters(buttonPress);
                }
            }
        });
        context.get().setPacketHandled(true);
    }
}

