/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.network;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import wayoftime.bloodmagic.common.item.ItemLivingTrainer;

public class LivingTrainerPacket {
    private int slot;
    private int ghostSlot;
    private int level;

    public LivingTrainerPacket() {
    }

    public LivingTrainerPacket(int slot, int ghostSlot, int level) {
        this.slot = slot;
        this.ghostSlot = ghostSlot;
        this.level = level;
    }

    public static void encode(LivingTrainerPacket pkt, PacketBuffer buf) {
        buf.writeInt(pkt.slot);
        buf.writeInt(pkt.ghostSlot);
        buf.writeInt(pkt.level);
    }

    public static LivingTrainerPacket decode(PacketBuffer buf) {
        LivingTrainerPacket pkt = new LivingTrainerPacket(buf.readInt(), buf.readInt(), buf.readInt());
        return pkt;
    }

    public static void handle(LivingTrainerPacket message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> LivingTrainerPacket.sendKeyToServer(message, (PlayerEntity)((NetworkEvent.Context)context.get()).getSender()));
        context.get().setPacketHandled(true);
    }

    public static void sendKeyToServer(LivingTrainerPacket msg, PlayerEntity playerEntity) {
        ItemStack itemStack = ItemStack.field_190927_a;
        if (msg.slot > -1 && msg.slot < 9) {
            itemStack = playerEntity.field_71071_by.func_70301_a(msg.slot);
        }
        if (!itemStack.func_190926_b() && itemStack.func_77973_b() instanceof ItemLivingTrainer && msg.ghostSlot != -1) {
            ((ItemLivingTrainer)itemStack.func_77973_b()).setTomeLevel(itemStack, msg.ghostSlot, msg.level);
        }
    }
}

