/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.potion;

import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import wayoftime.bloodmagic.potion.PotionBloodMagic;
import wayoftime.bloodmagic.potion.PotionFireFuse;
import wayoftime.bloodmagic.potion.PotionSoulSnare;

public class BloodMagicPotions {
    public static final Effect SOUL_SNARE = new PotionSoulSnare();
    public static final Effect FIRE_FUSE = new PotionFireFuse();
    public static final Effect SOUL_FRAY = new PotionBloodMagic(EffectType.HARMFUL, -1);
    public static final Effect PLANT_LEECH = new PotionBloodMagic(EffectType.HARMFUL, 0xFF00FF);
    public static final Effect SACRIFICIAL_LAMB = new PotionBloodMagic(EffectType.HARMFUL, 0xFFFFFF);
    public static final Effect FLIGHT = new PotionBloodMagic(EffectType.BENEFICIAL, 2350561);
    public static final Effect SPECTRAL_SIGHT = new PotionBloodMagic(EffectType.BENEFICIAL, 3127315);

    public static void registerPotions(RegistryEvent.Register<Effect> evt) {
        IForgeRegistry reg = evt.getRegistry();
        reg.register((IForgeRegistryEntry)((Effect)SOUL_SNARE.setRegistryName("soulsnare")));
        reg.register((IForgeRegistryEntry)((Effect)FIRE_FUSE.setRegistryName("firefuse")));
        reg.register((IForgeRegistryEntry)((Effect)SOUL_FRAY.setRegistryName("soulfray")));
        reg.register((IForgeRegistryEntry)((Effect)PLANT_LEECH.setRegistryName("plantleech")));
        reg.register((IForgeRegistryEntry)((Effect)SACRIFICIAL_LAMB.setRegistryName("sacrificiallamb")));
        reg.register((IForgeRegistryEntry)((Effect)FLIGHT.setRegistryName("flight")));
        reg.register((IForgeRegistryEntry)((Effect)SPECTRAL_SIGHT.setRegistryName("spectral_sight")));
    }

    public static Effect getEffect(ResourceLocation rl) {
        return (Effect)ForgeRegistries.POTIONS.getValue(rl);
    }

    public static ResourceLocation getRegistryName(Effect effect) {
        return ForgeRegistries.POTIONS.getKey((IForgeRegistryEntry)effect);
    }
}

