/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.recipe;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;

public class EffectHolder {
    private final Effect potion;
    private int baseDuration;
    private int amplifier;
    private double ampDurationMod;
    private double lengthDurationMod;

    public EffectHolder(Effect potion, int baseDuration, int amplifier, double ampDurationMod, double lengthDurationMod) {
        this.potion = potion;
        this.baseDuration = baseDuration;
        this.amplifier = amplifier;
        this.ampDurationMod = ampDurationMod;
        this.lengthDurationMod = lengthDurationMod;
    }

    public EffectInstance getEffectInstance(boolean ambientIn, boolean showParticlesIn) {
        return new EffectInstance(this.potion, (int)((double)this.baseDuration * this.ampDurationMod * this.lengthDurationMod), this.amplifier, ambientIn, showParticlesIn);
    }

    public Effect getPotion() {
        return this.potion;
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public int getBaseDuration() {
        return this.baseDuration;
    }

    public double getAmpDurationMod() {
        return this.ampDurationMod;
    }

    public double getLengthDurationMod() {
        return this.lengthDurationMod;
    }

    public void setBaseDuration(int baseDuration) {
        this.baseDuration = baseDuration;
    }

    public void setAmplifier(int amplifier) {
        this.amplifier = amplifier;
    }

    public void setAmpDurationMod(double ampDurationMod) {
        this.ampDurationMod = ampDurationMod;
    }

    public void setLengthDurationMod(double lengthDurationMod) {
        this.lengthDurationMod = lengthDurationMod;
    }

    public CompoundNBT write(CompoundNBT nbt) {
        nbt.func_74768_a("Id", Effect.func_188409_a((Effect)this.getPotion()));
        this.writeInternal(nbt);
        return nbt;
    }

    private void writeInternal(CompoundNBT nbt) {
        nbt.func_74774_a("Amplifier", (byte)this.getAmplifier());
        nbt.func_74768_a("Duration", this.getBaseDuration());
        nbt.func_74780_a("AmpDurationMod", this.getAmpDurationMod());
        nbt.func_74780_a("LengthDurationMod", this.getLengthDurationMod());
    }

    public static EffectHolder read(CompoundNBT nbt) {
        int i = nbt.func_74762_e("Id");
        Effect effect = Effect.func_188412_a((int)i);
        return effect == null ? null : EffectHolder.readInternal(effect, nbt);
    }

    private static EffectHolder readInternal(Effect effect, CompoundNBT nbt) {
        byte amplifier = nbt.func_74771_c("Amplifier");
        int baseDuration = nbt.func_74762_e("Duration");
        double ampDurationMod = nbt.func_74769_h("AmpDurationMod");
        double lengthDurationMod = nbt.func_74769_h("LengthDurationMod");
        return new EffectHolder(effect, baseDuration, amplifier, ampDurationMod, lengthDurationMod);
    }
}

