/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.recipe;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import wayoftime.bloodmagic.common.meteor.MeteorLayer;
import wayoftime.bloodmagic.common.recipe.BloodMagicRecipeType;
import wayoftime.bloodmagic.common.registries.BloodMagicRecipeSerializers;
import wayoftime.bloodmagic.recipe.BloodMagicRecipe;

public class RecipeMeteor
extends BloodMagicRecipe {
    @Nonnull
    protected final Ingredient input;
    @Nonnegative
    private final int syphon;
    private final float explosionRadius;
    private final List<MeteorLayer> layerList;

    public RecipeMeteor(ResourceLocation id, Ingredient input, int syphon, float explosionRadius, List<MeteorLayer> layerList) {
        super(id);
        Preconditions.checkNotNull((Object)input, (Object)"input cannot be null.");
        Preconditions.checkArgument((syphon >= 0 ? 1 : 0) != 0, (Object)"syphon cannot be negative.");
        Preconditions.checkArgument((explosionRadius >= 0.0f ? 1 : 0) != 0, (Object)"explosionRadius cannot be negative.");
        this.input = input;
        this.syphon = syphon;
        this.explosionRadius = explosionRadius;
        this.layerList = layerList;
    }

    public void spawnMeteorInWorld(World world, BlockPos centerPos) {
        if (this.explosionRadius > 0.0f) {
            world.func_217398_a(null, (double)centerPos.func_177958_n(), (double)centerPos.func_177956_o(), (double)centerPos.func_177952_p(), this.explosionRadius, true, Explosion.Mode.BREAK);
        }
        HashMap<Integer, MeteorLayer> layerMap = new HashMap<Integer, MeteorLayer>();
        for (MeteorLayer layer : this.layerList) {
            layerMap.put(layer.layerRadius, layer);
        }
        ArrayList keyList = new ArrayList(layerMap.keySet());
        Collections.sort(keyList);
        int prevRadius = -1;
        for (int i = 0; i < keyList.size(); ++i) {
            MeteorLayer layer = (MeteorLayer)layerMap.get(keyList.get(i));
            layer.buildLayer(world, centerPos, prevRadius);
            prevRadius = layer.layerRadius;
        }
    }

    @Nonnull
    public Ingredient getInput() {
        return this.input;
    }

    public final int getSyphon() {
        return this.syphon;
    }

    @Override
    public void write(PacketBuffer buffer) {
        this.input.func_199564_a(buffer);
        buffer.writeInt(this.getSyphon());
        buffer.writeFloat(this.explosionRadius);
        buffer.writeInt(this.layerList.size());
        for (int i = 0; i < this.layerList.size(); ++i) {
            this.layerList.get(i).write(buffer);
        }
    }

    public IRecipeSerializer<? extends RecipeMeteor> func_199559_b() {
        return BloodMagicRecipeSerializers.METEOR.getRecipeSerializer();
    }

    public IRecipeType<RecipeMeteor> func_222127_g() {
        return BloodMagicRecipeType.METEOR;
    }
}

