/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.recipe.flask;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.util.ResourceLocation;
import wayoftime.bloodmagic.common.item.potion.ItemAlchemyFlask;
import wayoftime.bloodmagic.common.recipe.BloodMagicRecipeType;
import wayoftime.bloodmagic.common.registries.BloodMagicRecipeSerializers;
import wayoftime.bloodmagic.recipe.EffectHolder;
import wayoftime.bloodmagic.recipe.flask.RecipePotionFlaskBase;

public class RecipePotionIncreaseLength
extends RecipePotionFlaskBase {
    public Effect outputEffect;
    public double lengthDurationMod;

    public RecipePotionIncreaseLength(ResourceLocation id, List<Ingredient> input, Effect outputEffect, double lengthDurationMod, int syphon, int ticks, int minimumTier) {
        super(id, input, syphon, ticks, minimumTier);
        this.outputEffect = outputEffect;
        this.lengthDurationMod = lengthDurationMod;
    }

    public IRecipeSerializer<? extends RecipePotionIncreaseLength> func_199559_b() {
        return BloodMagicRecipeSerializers.POTIONLENGTH.getRecipeSerializer();
    }

    @Override
    public IRecipeType<RecipePotionFlaskBase> func_222127_g() {
        return BloodMagicRecipeType.POTIONFLASK;
    }

    @Override
    public boolean canModifyFlask(List<EffectHolder> flaskEffectList) {
        for (EffectHolder holder : flaskEffectList) {
            if (!holder.getPotion().equals(this.outputEffect)) continue;
            return holder.getAmpDurationMod() < this.lengthDurationMod;
        }
        return false;
    }

    @Override
    public void write(PacketBuffer buffer) {
        super.write(buffer);
        buffer.writeInt(Effect.func_188409_a((Effect)this.outputEffect));
        buffer.writeDouble(this.lengthDurationMod);
    }

    @Override
    public ItemStack getOutput(ItemStack flaskStack, List<EffectHolder> flaskEffectList) {
        ItemStack copyStack = flaskStack.func_77946_l();
        for (EffectHolder holder : flaskEffectList) {
            if (!holder.getPotion().equals(this.outputEffect)) continue;
            holder.setLengthDurationMod(this.lengthDurationMod);
        }
        ((ItemAlchemyFlask)copyStack.func_77973_b()).setEffectHoldersOfFlask(copyStack, flaskEffectList);
        return copyStack;
    }

    @Override
    public int getPriority(List<EffectHolder> flaskEffectList) {
        for (int i = 0; i < flaskEffectList.size(); ++i) {
            EffectHolder holder = flaskEffectList.get(i);
            if (!holder.getPotion().equals(this.outputEffect)) continue;
            return i + 1;
        }
        return 0;
    }

    @Override
    public List<EffectHolder> getExampleEffectList() {
        ArrayList<EffectHolder> holderList = new ArrayList<EffectHolder>();
        holderList.add(new EffectHolder(this.outputEffect, 3600, 0, 1.0, 1.0));
        return holderList;
    }
}

