/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.recipe.flask;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.common.item.potion.ItemAlchemyFlask;
import wayoftime.bloodmagic.common.recipe.BloodMagicRecipeType;
import wayoftime.bloodmagic.common.registries.BloodMagicRecipeSerializers;
import wayoftime.bloodmagic.recipe.EffectHolder;
import wayoftime.bloodmagic.recipe.flask.RecipePotionFlaskBase;

public class RecipePotionTransform
extends RecipePotionFlaskBase {
    public List<Pair<Effect, Integer>> outputEffectList;
    public List<Effect> inputEffectList;

    public RecipePotionTransform(ResourceLocation id, List<Ingredient> input, List<Pair<Effect, Integer>> outputEffectList, List<Effect> inputEffectList, int syphon, int ticks, int minimumTier) {
        super(id, input, syphon, ticks, minimumTier);
        this.outputEffectList = outputEffectList;
        this.inputEffectList = inputEffectList;
    }

    public IRecipeSerializer<? extends RecipePotionTransform> func_199559_b() {
        return BloodMagicRecipeSerializers.POTIONTRANSFORM.getRecipeSerializer();
    }

    @Override
    public IRecipeType<RecipePotionFlaskBase> func_222127_g() {
        return BloodMagicRecipeType.POTIONFLASK;
    }

    @Override
    public boolean canModifyFlask(List<EffectHolder> flaskEffectList) {
        if (flaskEffectList.size() < this.inputEffectList.size()) {
            return false;
        }
        int duplicateCount = this.getDuplicateEffects(flaskEffectList);
        if (duplicateCount >= this.outputEffectList.size()) {
            return false;
        }
        ArrayList<Effect> recipeInput = new ArrayList<Effect>(this.inputEffectList);
        for (int i = 0; i < flaskEffectList.size(); ++i) {
            Effect flaskEffect = flaskEffectList.get(i).getPotion();
            boolean matched = false;
            for (int j = 0; j < recipeInput.size(); ++j) {
                Effect ingredient = (Effect)recipeInput.get(j);
                if (!ingredient.equals(flaskEffect)) continue;
                recipeInput.remove(j);
                matched = true;
                break;
            }
            if (matched) continue;
        }
        return recipeInput.isEmpty();
    }

    protected int getDuplicateEffects(List<EffectHolder> flaskEffectList) {
        int duplicateCount = 0;
        ArrayList<Pair<Effect, Integer>> recipeOutput = new ArrayList<Pair<Effect, Integer>>(this.outputEffectList);
        block0: for (int i = 0; i < flaskEffectList.size(); ++i) {
            Effect flaskEffect = flaskEffectList.get(i).getPotion();
            int flaskBaseDuration = flaskEffectList.get(i).getBaseDuration();
            for (int j = 0; j < recipeOutput.size(); ++j) {
                Pair output = (Pair)recipeOutput.get(j);
                if (!((Effect)output.getKey()).equals(flaskEffect) || (Integer)output.getValue() > flaskBaseDuration) continue;
                recipeOutput.remove(j);
                ++duplicateCount;
                continue block0;
            }
        }
        return duplicateCount;
    }

    @Override
    public void write(PacketBuffer buffer) {
        super.write(buffer);
        buffer.writeInt(this.outputEffectList.size());
        for (Pair<Effect, Integer> effectHolder : this.outputEffectList) {
            buffer.writeInt(Effect.func_188409_a((Effect)((Effect)effectHolder.getKey())));
            buffer.writeInt(((Integer)effectHolder.getValue()).intValue());
        }
        buffer.writeInt(this.inputEffectList.size());
        for (Effect effect : this.inputEffectList) {
            buffer.writeInt(Effect.func_188409_a((Effect)effect));
        }
    }

    @Override
    public ItemStack getOutput(ItemStack flaskStack, List<EffectHolder> flaskEffectList) {
        int i;
        ItemStack copyStack = flaskStack.func_77946_l();
        boolean savePotencies = this.outputEffectList.size() == 1 && this.inputEffectList.size() == 1;
        int amplifier = 0;
        double ampDurMod = 1.0;
        double lengthDurMod = 1.0;
        ArrayList<EffectHolder> flaskEffectCopyList = new ArrayList<EffectHolder>(flaskEffectList);
        block0: for (int i2 = 0; i2 < this.inputEffectList.size(); ++i2) {
            Effect inputEffect = this.inputEffectList.get(i2);
            for (int j = 0; j < flaskEffectCopyList.size(); ++j) {
                EffectHolder flaskEffect = (EffectHolder)flaskEffectCopyList.get(j);
                if (!flaskEffect.getPotion().equals(inputEffect)) continue;
                if (savePotencies) {
                    amplifier = flaskEffect.getAmplifier();
                    ampDurMod = flaskEffect.getAmpDurationMod();
                    lengthDurMod = flaskEffect.getLengthDurationMod();
                }
                flaskEffectCopyList.remove(j);
                continue block0;
            }
        }
        boolean[] alreadyAddedArray = new boolean[this.outputEffectList.size()];
        block2: for (i = 0; i < this.outputEffectList.size(); ++i) {
            Effect outputEffect = (Effect)this.outputEffectList.get(i).getKey();
            int outputBaseDuration = (Integer)this.outputEffectList.get(i).getValue();
            for (int j = 0; j < flaskEffectCopyList.size(); ++j) {
                EffectHolder flaskEffect = (EffectHolder)flaskEffectCopyList.get(j);
                if (!flaskEffect.getPotion().equals(outputEffect)) continue;
                alreadyAddedArray[i] = true;
                if (flaskEffect.getBaseDuration() >= outputBaseDuration) continue block2;
                flaskEffect.setBaseDuration(outputBaseDuration);
                continue block2;
            }
            alreadyAddedArray[i] = false;
        }
        for (i = 0; i < this.outputEffectList.size(); ++i) {
            flaskEffectCopyList.add(new EffectHolder((Effect)this.outputEffectList.get(i).getKey(), (Integer)this.outputEffectList.get(i).getValue(), amplifier, ampDurMod, lengthDurMod));
        }
        ((ItemAlchemyFlask)copyStack.func_77973_b()).setEffectHoldersOfFlask(copyStack, flaskEffectCopyList);
        return copyStack;
    }

    @Override
    public int getPriority(List<EffectHolder> flaskEffectList) {
        int prio = 0;
        for (int i = 0; i < flaskEffectList.size(); ++i) {
            EffectHolder holder = flaskEffectList.get(i);
            for (int j = 0; j < this.inputEffectList.size(); ++j) {
                if (!holder.getPotion().equals(this.inputEffectList.get(j))) continue;
                prio += i + 1;
            }
        }
        return prio;
    }

    @Override
    public List<EffectHolder> getExampleEffectList() {
        ArrayList<EffectHolder> holderList = new ArrayList<EffectHolder>();
        for (Effect inputEffect : this.inputEffectList) {
            holderList.add(new EffectHolder(inputEffect, 3600, 0, 1.0, 1.0));
        }
        return holderList;
    }
}

